/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.paho.mqtt5;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.extension.ComponentExtension;
import org.apache.camel.component.paho.mqtt5.PahoMqtt5ComponentVerifierExtension;
import org.apache.camel.component.paho.mqtt5.PahoMqtt5Configuration;
import org.apache.camel.component.paho.mqtt5.PahoMqtt5Endpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultComponent;
import org.eclipse.paho.mqttv5.client.MqttClient;

@Component(value="paho-mqtt5")
public class PahoMqtt5Component
extends DefaultComponent {
    @Metadata
    private PahoMqtt5Configuration configuration = new PahoMqtt5Configuration();
    @Metadata(label="advanced")
    private MqttClient client;

    public PahoMqtt5Component() {
        this(null);
    }

    public PahoMqtt5Component(CamelContext context) {
        super(context);
        this.registerExtension((ComponentExtension)new PahoMqtt5ComponentVerifierExtension());
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        PahoMqtt5Configuration configuration = this.getConfiguration().copy();
        PahoMqtt5Endpoint answer = new PahoMqtt5Endpoint(uri, remaining, this, configuration);
        answer.setClient(this.client);
        this.setProperties((Endpoint)answer, parameters);
        return answer;
    }

    public PahoMqtt5Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(PahoMqtt5Configuration configuration) {
        this.configuration = configuration;
    }

    public MqttClient getClient() {
        return this.client;
    }

    public void setClient(MqttClient client) {
        this.client = client;
    }
}

