/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.paho;

import java.util.Map;
import org.apache.camel.component.extension.ComponentVerifierExtension;
import org.apache.camel.component.extension.verifier.DefaultComponentVerifierExtension;
import org.apache.camel.component.extension.verifier.ResultBuilder;
import org.apache.camel.component.extension.verifier.ResultErrorBuilder;
import org.apache.camel.component.extension.verifier.ResultErrorHelper;
import org.apache.camel.util.ObjectHelper;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;

public class PahoComponentVerifierExtension
extends DefaultComponentVerifierExtension {
    public PahoComponentVerifierExtension() {
        this("paho");
    }

    public PahoComponentVerifierExtension(String scheme) {
        super(scheme);
    }

    protected ComponentVerifierExtension.Result verifyParameters(Map<String, Object> parameters) {
        return ResultBuilder.withStatusAndScope((ComponentVerifierExtension.Result.Status)ComponentVerifierExtension.Result.Status.OK, (ComponentVerifierExtension.Scope)ComponentVerifierExtension.Scope.PARAMETERS).error(ResultErrorHelper.requiresOption((String)"brokerUrl", parameters)).build();
    }

    protected ComponentVerifierExtension.Result verifyConnectivity(Map<String, Object> parameters) {
        return ResultBuilder.withStatusAndScope((ComponentVerifierExtension.Result.Status)ComponentVerifierExtension.Result.Status.OK, (ComponentVerifierExtension.Scope)ComponentVerifierExtension.Scope.CONNECTIVITY).error(parameters, this::verifyCredentials).build();
    }

    private void verifyCredentials(ResultBuilder builder, Map<String, Object> parameters) {
        String brokerUrl = (String)parameters.get("brokerUrl");
        String username = (String)parameters.get("userName");
        String password = (String)parameters.get("password");
        if (ObjectHelper.isNotEmpty((Object)brokerUrl)) {
            try (MqttClient client = new MqttClient(brokerUrl, MqttClient.generateClientId());){
                if (ObjectHelper.isEmpty((Object)username) && ObjectHelper.isEmpty((Object)password)) {
                    client.connect();
                } else {
                    MqttConnectOptions connOpts = new MqttConnectOptions();
                    connOpts.setUserName(username);
                    connOpts.setPassword(password.toCharArray());
                    client.connect(connOpts);
                }
                client.disconnect();
            }
            catch (MqttException e) {
                builder.error(ResultErrorBuilder.withCodeAndDescription((ComponentVerifierExtension.VerificationError.Code)ComponentVerifierExtension.VerificationError.StandardCode.ILLEGAL_PARAMETER_VALUE, (String)"Unable to connect to MQTT broker").parameterKey("brokerUrl").build());
            }
        } else {
            builder.error(ResultErrorBuilder.withCodeAndDescription((ComponentVerifierExtension.VerificationError.Code)ComponentVerifierExtension.VerificationError.StandardCode.ILLEGAL_PARAMETER_VALUE, (String)"Invalid blank MQTT brokerUrl ").parameterKey("brokerUrl").build());
        }
    }
}

