/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.paho;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.paho.PahoConfiguration;
import org.apache.camel.component.paho.PahoEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultComponent;
import org.eclipse.paho.client.mqttv3.MqttClient;

@Component(value="paho")
public class PahoComponent
extends DefaultComponent {
    @Metadata
    private PahoConfiguration configuration = new PahoConfiguration();
    @Metadata(label="advanced")
    private MqttClient client;

    public PahoComponent() {
        this(null);
    }

    public PahoComponent(CamelContext context) {
        super(context);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        PahoConfiguration pahoConfiguration = this.getConfiguration().copy();
        PahoEndpoint answer = new PahoEndpoint(uri, remaining, this, pahoConfiguration);
        answer.setClient(this.client);
        this.setProperties((Endpoint)answer, parameters);
        return answer;
    }

    public PahoConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(PahoConfiguration configuration) {
        this.configuration = configuration;
    }

    public MqttClient getClient() {
        return this.client;
    }

    public void setClient(MqttClient client) {
        this.client = client;
    }
}

