/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.platform.http.main;

import io.netty.buffer.ByteBufInputStream;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.impl.Arguments;
import io.vertx.ext.web.RequestBody;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.BodyHandler;
import io.vertx.ext.web.impl.BlockingHandlerDecorator;
import io.vertx.ext.web.impl.Utils;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.management.RuntimeMBeanException;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.NonManagedService;
import org.apache.camel.Service;
import org.apache.camel.StartupListener;
import org.apache.camel.StaticService;
import org.apache.camel.component.platform.http.HttpEndpointModel;
import org.apache.camel.component.platform.http.PlatformHttpComponent;
import org.apache.camel.component.platform.http.main.jolokia.JolokiaHttpRequestHandlerSupport;
import org.apache.camel.component.platform.http.vertx.VertxPlatformHttpRouter;
import org.apache.camel.component.platform.http.vertx.VertxPlatformHttpServer;
import org.apache.camel.component.platform.http.vertx.VertxPlatformHttpServerConfiguration;
import org.apache.camel.console.DevConsole;
import org.apache.camel.console.DevConsoleRegistry;
import org.apache.camel.health.HealthCheck;
import org.apache.camel.health.HealthCheckHelper;
import org.apache.camel.health.HealthCheckRegistry;
import org.apache.camel.spi.CamelEvent;
import org.apache.camel.spi.EventNotifier;
import org.apache.camel.support.SimpleEventNotifierSupport;
import org.apache.camel.support.jsse.SSLContextParameters;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.AntPathMatcher;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.json.JsonObject;
import org.jolokia.server.core.http.HttpRequestHandler;
import org.json.simple.JSONAware;
import org.json.simple.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MainHttpServer
extends ServiceSupport
implements CamelContextAware,
StaticService,
NonManagedService {
    private static final Logger LOG = LoggerFactory.getLogger(MainHttpServer.class);
    private VertxPlatformHttpServer server;
    private VertxPlatformHttpRouter router;
    private CamelContext camelContext;
    private PlatformHttpComponent platformHttpComponent;
    private VertxPlatformHttpServerConfiguration configuration = new VertxPlatformHttpServerConfiguration();
    private boolean devConsoleEnabled;
    private boolean healthCheckEnabled;
    private boolean jolokiaEnabled;
    private boolean metricsEnabled;
    private boolean uploadEnabled;
    private String uploadSourceDir;

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public VertxPlatformHttpServerConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(VertxPlatformHttpServerConfiguration configuration) {
        this.configuration = configuration;
    }

    public boolean isDevConsoleEnabled() {
        return this.devConsoleEnabled;
    }

    public void setDevConsoleEnabled(boolean devConsoleEnabled) {
        this.devConsoleEnabled = devConsoleEnabled;
    }

    public boolean isHealthCheckEnabled() {
        return this.healthCheckEnabled;
    }

    public boolean isJolokiaEnabled() {
        return this.jolokiaEnabled;
    }

    public void setHealthCheckEnabled(boolean healthCheckEnabled) {
        this.healthCheckEnabled = healthCheckEnabled;
    }

    public void setJolokiaEnabled(boolean jolokiaEnabledEnabled) {
        this.jolokiaEnabled = jolokiaEnabledEnabled;
    }

    public boolean isMetricsEnabled() {
        return this.metricsEnabled;
    }

    public void setMetricsEnabled(boolean metricsEnabled) {
        this.metricsEnabled = metricsEnabled;
    }

    public boolean isUploadEnabled() {
        return this.uploadEnabled;
    }

    public void setUploadEnabled(boolean uploadEnabled) {
        this.uploadEnabled = uploadEnabled;
    }

    public String getUploadSourceDir() {
        return this.uploadSourceDir;
    }

    public void setUploadSourceDir(String uploadSourceDir) {
        this.uploadSourceDir = uploadSourceDir;
    }

    public int getPort() {
        return this.configuration.getBindPort();
    }

    public void setPort(int port) {
        this.configuration.setBindPort(port);
    }

    public String getHost() {
        return this.configuration.getBindHost();
    }

    public void setHost(String host) {
        this.configuration.setBindHost(host);
    }

    public String getPath() {
        return this.configuration.getPath();
    }

    public void setPath(String path) {
        this.configuration.setPath(path);
    }

    public Long getMaxBodySize() {
        return this.configuration.getMaxBodySize();
    }

    public void setMaxBodySize(Long maxBodySize) {
        this.configuration.setMaxBodySize(maxBodySize);
    }

    public SSLContextParameters getSslContextParameters() {
        return this.configuration.getSslContextParameters();
    }

    public void setSslContextParameters(SSLContextParameters sslContextParameters) {
        this.configuration.setSslContextParameters(sslContextParameters);
    }

    public boolean isUseGlobalSslContextParameters() {
        return this.configuration.isUseGlobalSslContextParameters();
    }

    public void setUseGlobalSslContextParameters(boolean useGlobalSslContextParameters) {
        this.configuration.setUseGlobalSslContextParameters(useGlobalSslContextParameters);
    }

    public VertxPlatformHttpServerConfiguration.Cors getCors() {
        return this.configuration.getCors();
    }

    public void setCors(VertxPlatformHttpServerConfiguration.Cors corsConfiguration) {
        this.configuration.setCors(corsConfiguration);
    }

    public VertxPlatformHttpServerConfiguration.BodyHandler getBodyHandler() {
        return this.configuration.getBodyHandler();
    }

    public void setBodyHandler(VertxPlatformHttpServerConfiguration.BodyHandler bodyHandler) {
        this.configuration.setBodyHandler(bodyHandler);
    }

    public VertxPlatformHttpRouter getRouter() {
        return this.router;
    }

    protected void doStart() throws Exception {
        ObjectHelper.notNull((Object)this.camelContext, (String)"CamelContext");
        this.server = new VertxPlatformHttpServer(this.configuration);
        this.camelContext.addService((Object)this.server);
        ServiceHelper.startService((Service)this.server);
        this.router = VertxPlatformHttpRouter.lookup((CamelContext)this.camelContext);
        this.platformHttpComponent = (PlatformHttpComponent)this.camelContext.getComponent("platform-http", PlatformHttpComponent.class);
        this.setupConsoles();
        this.setupStartupSummary();
    }

    protected void setupConsoles() {
        if (this.devConsoleEnabled) {
            this.setupDevConsole();
        }
        if (this.healthCheckEnabled) {
            this.setupHealthCheckConsole();
        }
        if (this.jolokiaEnabled) {
            this.setupJolokia();
        }
        if (this.uploadEnabled) {
            if (this.uploadSourceDir == null) {
                throw new IllegalArgumentException("UploadSourceDir must be configured when uploadEnabled=true");
            }
            this.setupUploadConsole(this.uploadSourceDir);
        }
    }

    protected void setupStartupSummary() throws Exception {
        this.camelContext.addStartupListener(new StartupListener(){
            private volatile Set<HttpEndpointModel> last;

            private void logSummary() {
                Set endpoints = MainHttpServer.this.platformHttpComponent.getHttpEndpoints();
                if (endpoints.isEmpty()) {
                    return;
                }
                if (this.last == null || this.last.size() != endpoints.size() || !this.last.containsAll(endpoints)) {
                    LOG.info("HTTP endpoints summary");
                    for (HttpEndpointModel u : endpoints) {
                        String line = "http://0.0.0.0:" + (MainHttpServer.this.server != null ? MainHttpServer.this.server.getPort() : MainHttpServer.this.getPort()) + u.getUri();
                        if (u.getVerbs() != null) {
                            line = line + " (" + u.getVerbs() + ")";
                        }
                        LOG.info("    {}", (Object)line);
                    }
                }
                this.last = new HashSet<HttpEndpointModel>(endpoints);
            }

            public void onCamelContextStarted(CamelContext context, boolean alreadyStarted) {
                if (alreadyStarted) {
                    this.logSummary();
                }
                MainHttpServer.this.camelContext.getManagementStrategy().addEventNotifier((EventNotifier)new SimpleEventNotifierSupport(){

                    public boolean isEnabled(CamelEvent event) {
                        return event instanceof CamelEvent.CamelContextStartedEvent || event instanceof CamelEvent.RouteReloadedEvent;
                    }

                    public void notify(CamelEvent event) {
                        CamelEvent.RouteReloadedEvent re;
                        if (event instanceof CamelEvent.RouteReloadedEvent && (re = (CamelEvent.RouteReloadedEvent)event).getIndex() < re.getTotal()) {
                            return;
                        }
                        this.logSummary();
                    }
                });
            }
        });
    }

    protected void setupHealthCheckConsole() {
        final Route health = this.router.route("/q/health");
        health.method(HttpMethod.GET);
        health.produces("application/json");
        final Route live = this.router.route("/q/health/live");
        live.method(HttpMethod.GET);
        live.produces("application/json");
        final Route ready = this.router.route("/q/health/ready");
        ready.method(HttpMethod.GET);
        ready.produces("application/json");
        Handler<RoutingContext> handler = new Handler<RoutingContext>(){

            public void handle(RoutingContext ctx) {
                boolean rdy;
                ctx.response().putHeader("content-type", "application/json");
                HealthCheckRegistry registry = HealthCheckRegistry.get((CamelContext)MainHttpServer.this.camelContext);
                String level = ctx.request().getParam("exposureLevel");
                if (level == null) {
                    level = registry.getExposureLevel();
                }
                String includeStackTrace = ctx.request().getParam("stackTrace");
                String includeData = ctx.request().getParam("data");
                boolean all = ctx.currentRoute() == health;
                boolean liv = ctx.currentRoute() == live;
                boolean bl = rdy = ctx.currentRoute() == ready;
                Collection res = all ? HealthCheckHelper.invoke((CamelContext)MainHttpServer.this.camelContext, (String)level) : (liv ? HealthCheckHelper.invokeLiveness((CamelContext)MainHttpServer.this.camelContext, (String)level) : HealthCheckHelper.invokeReadiness((CamelContext)MainHttpServer.this.camelContext, (String)level));
                StringBuilder sb = new StringBuilder();
                sb.append("{\n");
                boolean up = HealthCheckHelper.isResultsUp((Collection)res, (boolean)rdy);
                if ("oneline".equals(level)) {
                    MainHttpServer.healthCheckStatus(sb, up);
                } else if ("full".equals(level)) {
                    ArrayList<HealthCheck.Result> list = new ArrayList<HealthCheck.Result>(res);
                    MainHttpServer.healthCheckDetails(sb, list, up, level, includeStackTrace, includeData);
                } else {
                    List<HealthCheck.Result> downs = res.stream().filter(r -> r.getState().equals((Object)HealthCheck.State.DOWN)).collect(Collectors.toList());
                    MainHttpServer.healthCheckDetails(sb, downs, up, level, includeStackTrace, includeData);
                }
                sb.append("}\n");
                if (!up) {
                    ctx.response().setStatusCode(503);
                }
                ctx.end(sb.toString());
            }
        };
        health.handler((Handler)new BlockingHandlerDecorator((Handler)handler, true));
        live.handler((Handler)new BlockingHandlerDecorator((Handler)handler, true));
        ready.handler((Handler)new BlockingHandlerDecorator((Handler)handler, true));
        this.platformHttpComponent.addHttpEndpoint("/q/health", null, null);
    }

    protected void setupJolokia() {
        Route jolokia = this.router.route("/q/jolokia/*");
        jolokia.method(HttpMethod.GET);
        jolokia.method(HttpMethod.POST);
        Handler handler = routingContext -> {
            JSONObject json;
            block7: {
                HttpServerRequest req = routingContext.request();
                String remainingPath = Utils.pathOffset((String)req.path(), (RoutingContext)routingContext);
                HttpRequestHandler requestHandler = this.getHttpRequestHandler();
                json = null;
                try {
                    requestHandler.checkAccess(req.remoteAddress().host(), req.remoteAddress().host(), this.getOriginOrReferer(req));
                    if (req.method() == HttpMethod.GET) {
                        json = requestHandler.handleGetRequest(req.uri(), remainingPath, this.getParams(req.params()));
                    } else {
                        Arguments.require((routingContext.body() != null ? 1 : 0) != 0, (String)"Missing body");
                        ByteBufInputStream inputStream = new ByteBufInputStream(routingContext.body().buffer().getByteBuf());
                        json = requestHandler.handlePostRequest(req.uri(), (InputStream)inputStream, StandardCharsets.UTF_8.name(), this.getParams(req.params()));
                    }
                    if (json != null) break block7;
                }
                catch (Throwable exp) {
                    block8: {
                        try {
                            json = requestHandler.handleThrowable(exp instanceof RuntimeMBeanException ? ((RuntimeMBeanException)exp).getTargetException() : exp);
                            if (json != null) break block8;
                        }
                        catch (Throwable throwable) {
                            if (json == null) {
                                json = requestHandler.handleThrowable((Throwable)new Exception("Internal error while handling an exception"));
                            }
                            routingContext.response().setStatusCode(this.getStatusCode((JSONAware)json)).putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)"application/json").end(json.toJSONString());
                            throw throwable;
                        }
                        json = requestHandler.handleThrowable((Throwable)new Exception("Internal error while handling an exception"));
                    }
                    routingContext.response().setStatusCode(this.getStatusCode((JSONAware)json)).putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)"application/json").end(json.toJSONString());
                }
                json = requestHandler.handleThrowable((Throwable)new Exception("Internal error while handling an exception"));
            }
            routingContext.response().setStatusCode(this.getStatusCode((JSONAware)json)).putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)"application/json").end(json.toJSONString());
        };
        jolokia.handler((Handler)new BlockingHandlerDecorator(handler, true));
        this.platformHttpComponent.addHttpEndpoint("/q/jolokia", null, null);
    }

    private HttpRequestHandler getHttpRequestHandler() {
        HttpRequestHandler requestHandler;
        try (JolokiaHttpRequestHandlerSupport jolokiaService = new JolokiaHttpRequestHandlerSupport();){
            jolokiaService.start();
            requestHandler = jolokiaService.getHttpRequestHandler();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return requestHandler;
    }

    private Map<String, String[]> getParams(MultiMap params) {
        HashMap<String, String[]> response = new HashMap<String, String[]>();
        for (String name : params.names()) {
            response.put(name, params.getAll(name).toArray(new String[0]));
        }
        return response;
    }

    private String getOriginOrReferer(HttpServerRequest req) {
        String origin = req.getHeader(HttpHeaders.ORIGIN);
        if (origin == null) {
            origin = req.getHeader(HttpHeaders.REFERER);
        }
        return origin != null ? origin.replaceAll("[\\n\\r]*", "") : null;
    }

    protected int getStatusCode(JSONAware json) {
        if (json instanceof JSONObject && ((JSONObject)json).get((Object)"status") instanceof Integer) {
            return (Integer)((JSONObject)json).get((Object)"status");
        }
        return 200;
    }

    private static void healthCheckStatus(StringBuilder sb, boolean up) {
        if (up) {
            sb.append("    \"status\": \"UP\"\n");
        } else {
            sb.append("    \"status\": \"DOWN\"\n");
        }
    }

    private static void healthCheckDetails(StringBuilder sb, List<HealthCheck.Result> checks, boolean up, String level, String includeStackTrace, String includeData) {
        MainHttpServer.healthCheckStatus(sb, up);
        if (!checks.isEmpty()) {
            sb.append(",\n");
            sb.append("    \"checks\": [\n");
            for (int i = 0; i < checks.size(); ++i) {
                HealthCheck.Result d = checks.get(i);
                sb.append("        {\n");
                MainHttpServer.reportHealthCheck(sb, d, level, includeStackTrace, includeData);
                if (i < checks.size() - 1) {
                    sb.append("        },\n");
                    continue;
                }
                sb.append("        }\n");
            }
            sb.append("    ]\n");
        }
    }

    private static void reportHealthCheck(StringBuilder sb, HealthCheck.Result d, String level, String includeStackTrace, String includeData) {
        sb.append("            \"name\": \"").append(d.getCheck().getId()).append("\",\n");
        sb.append("            \"status\": \"").append(d.getState()).append("\"");
        if (("full".equals(level) || "true".equals(includeStackTrace)) && d.getError().isPresent()) {
            sb.append(",\n");
            String msg = MainHttpServer.allCausedByErrorMessages((Throwable)d.getError().get());
            sb.append("            \"error-message\": \"").append(msg).append("\"");
            if ("true".equals(includeStackTrace)) {
                sb.append(",\n");
                sb.append("            \"error-stacktrace\": \"").append(MainHttpServer.errorStackTrace((Throwable)d.getError().get())).append("\"");
            }
        }
        if (d.getMessage().isPresent()) {
            sb.append(",\n");
            sb.append("            \"message\": \"").append((String)d.getMessage().get()).append("\"");
        }
        if ("true".equals(includeData) && d.getDetails() != null && !d.getDetails().isEmpty()) {
            sb.append(",\n");
            Iterator it = new TreeSet(d.getDetails().keySet()).iterator();
            sb.append("            \"data\": {\n");
            while (it.hasNext()) {
                String k = (String)it.next();
                Object v = d.getDetails().get(k);
                if (v == null) {
                    v = "";
                }
                boolean last = !it.hasNext();
                sb.append("                 \"").append(k).append("\": \"").append(v).append("\"");
                if (!last) {
                    sb.append(",");
                }
                sb.append("\n");
            }
            sb.append("            }\n");
        }
    }

    private static String allCausedByErrorMessages(Throwable e) {
        StringBuilder sb = new StringBuilder();
        sb.append(e.getMessage());
        while (e.getCause() != null) {
            if ((e = e.getCause()).getMessage() == null) continue;
            sb.append("; Caused by: ");
            sb.append(ObjectHelper.classCanonicalName((Object)e));
            sb.append(": ");
            sb.append(e.getMessage());
        }
        return sb.toString();
    }

    private static String errorStackTrace(Throwable e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        String trace = sw.toString();
        trace = trace.replace('\"', '\'');
        trace = trace.replace('\t', ' ');
        trace = trace.replace(System.lineSeparator(), " ");
        return trace;
    }

    protected void setupDevConsole() {
        Route dev = this.router.route("/q/dev");
        dev.method(HttpMethod.GET);
        dev.produces("text/plain");
        dev.produces("application/json");
        Route devSub = this.router.route("/q/dev/*");
        devSub.method(HttpMethod.GET);
        devSub.produces("text/plain");
        devSub.produces("application/json");
        Handler<RoutingContext> handler = new Handler<RoutingContext>(){

            public void handle(RoutingContext ctx) {
                String id;
                DevConsoleRegistry dcr;
                int pos2;
                int pos1;
                String acp = ctx.request().getHeader("Accept");
                int n = pos1 = acp != null ? acp.indexOf("html") : Integer.MAX_VALUE;
                if (pos1 == -1) {
                    pos1 = Integer.MAX_VALUE;
                }
                int n2 = pos2 = acp != null ? acp.indexOf("json") : Integer.MAX_VALUE;
                if (pos2 == -1) {
                    pos2 = Integer.MAX_VALUE;
                }
                boolean html = pos1 < pos2;
                boolean json = pos2 < pos1;
                DevConsole.MediaType mediaType = json ? DevConsole.MediaType.JSON : DevConsole.MediaType.TEXT;
                ctx.response().putHeader("content-type", "text/plain");
                if (!MainHttpServer.this.camelContext.isDevConsole().booleanValue()) {
                    ctx.end("Developer Console is not enabled on CamelContext. Set camel.context.dev-console=true in application.properties");
                }
                if ((dcr = (DevConsoleRegistry)MainHttpServer.this.camelContext.getCamelContextExtension().getContextPlugin(DevConsoleRegistry.class)) == null || !dcr.isEnabled()) {
                    ctx.end("Developer Console is not enabled");
                    return;
                }
                String path = StringHelper.after((String)ctx.request().path(), (String)"/q/dev/");
                String s = path;
                if (s != null && s.contains("/")) {
                    s = StringHelper.before((String)s, (String)"/");
                }
                if ((id = s) == null || id.isEmpty() || id.equals("index")) {
                    StringBuilder sb = new StringBuilder();
                    JsonObject root = new JsonObject();
                    dcr.stream().forEach(c -> {
                        if (json) {
                            JsonObject jo = new JsonObject();
                            jo.put((Object)"id", (Object)c.getId());
                            jo.put((Object)"displayName", (Object)c.getDisplayName());
                            jo.put((Object)"description", (Object)c.getDescription());
                            root.put((Object)c.getId(), (Object)jo);
                        } else {
                            Object link = c.getId();
                            String eol = "\n";
                            if (html) {
                                link = "<a href=\"dev/" + (String)link + "\">" + c.getId() + "</a>";
                                eol = "<br/>\n";
                            }
                            sb.append((String)link).append(": ").append(c.getDescription()).append(eol);
                            if ("top".equals(c.getId())) {
                                link = ((String)link).replace("top", "top/*");
                                sb.append((String)link).append(": ").append("Display the top processors").append(eol);
                            }
                        }
                    });
                    if (!sb.isEmpty()) {
                        String out = sb.toString();
                        if (html) {
                            ctx.response().putHeader("content-type", "text/html");
                        }
                        ctx.end(out);
                    } else if (!root.isEmpty()) {
                        ctx.response().putHeader("content-type", "application/json");
                        String out = root.toJson();
                        ctx.end(out);
                    } else {
                        ctx.end();
                    }
                } else {
                    HashMap<String, String> params = new HashMap<String, String>();
                    ctx.queryParams().forEach(params::put);
                    params.put("CamelHttpPath", path);
                    StringBuilder sb = new StringBuilder();
                    JsonObject root = new JsonObject();
                    dcr.stream().sorted((o1, o2) -> {
                        int p1 = id.indexOf(o1.getId());
                        int p2 = id.indexOf(o2.getId());
                        return Integer.compare(p1, p2);
                    }).forEach(c -> {
                        boolean include;
                        boolean bl = include = "all".equals(id) || c.getId().equalsIgnoreCase(id);
                        if (include && c.supportMediaType(mediaType)) {
                            Object out = c.call(mediaType, params);
                            if (out != null && mediaType == DevConsole.MediaType.TEXT) {
                                sb.append(c.getDisplayName()).append(":");
                                sb.append("\n\n");
                                sb.append(out);
                                sb.append("\n\n");
                            } else if (out != null && mediaType == DevConsole.MediaType.JSON) {
                                root.put((Object)c.getId(), out);
                            }
                        }
                    });
                    if (!sb.isEmpty()) {
                        String out = sb.toString();
                        ctx.end(out);
                    } else if (!root.isEmpty()) {
                        ctx.response().putHeader("content-type", "application/json");
                        String out = root.toJson();
                        ctx.end(out);
                    } else {
                        ctx.end("Developer Console not found: " + id);
                    }
                }
            }
        };
        dev.handler((Handler)new BlockingHandlerDecorator((Handler)handler, true));
        devSub.handler((Handler)new BlockingHandlerDecorator((Handler)handler, true));
        this.platformHttpComponent.addHttpEndpoint("/q/dev", null, null);
    }

    protected void setupUploadConsole(final String dir) {
        Route upload = this.router.route("/q/upload/:filename").method(HttpMethod.PUT).handler((Handler)BodyHandler.create((boolean)true));
        Route uploadDelete = this.router.route("/q/upload/:filename");
        uploadDelete.method(HttpMethod.DELETE);
        Handler<RoutingContext> handler = new Handler<RoutingContext>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void handle(RoutingContext ctx) {
                int status;
                block7: {
                    int n;
                    File[] fileArray;
                    AntPathMatcher match;
                    String name;
                    block10: {
                        block8: {
                            block9: {
                                boolean delete;
                                name = ctx.pathParam("filename");
                                if (name == null) {
                                    ctx.response().setStatusCode(400);
                                    ctx.end();
                                    return;
                                }
                                status = 200;
                                boolean bl = delete = HttpMethod.DELETE == ctx.request().method();
                                if (!delete) break block8;
                                if (!name.contains("*")) break block9;
                                if (name.equals("*")) {
                                    name = "**";
                                }
                                match = AntPathMatcher.INSTANCE;
                                File[] files = new File(dir).listFiles();
                                if (files == null) break block7;
                                fileArray = files;
                                n = fileArray.length;
                                break block10;
                            }
                            File f = new File(dir, name);
                            if (!f.exists() || !f.isFile()) break block7;
                            LOG.info("Deleting file: {}/{}", (Object)dir, (Object)name);
                            FileUtil.deleteFile((File)f);
                            break block7;
                        }
                        File f = new File(dir, name);
                        boolean exists = f.isFile() && f.exists();
                        LOG.info("{} file: {}/{}", new Object[]{exists ? "Updating" : "Creating", dir, name});
                        File tmp = new File(dir, name + ".tmp");
                        FileOutputStream fos = null;
                        try {
                            fos = new FileOutputStream(tmp, false);
                            RequestBody rb = ctx.body();
                            IOHelper.writeText((String)rb.asString(), (OutputStream)fos);
                            FileUtil.renameFileUsingCopy((File)tmp, (File)f);
                            FileUtil.deleteFile((File)tmp);
                        }
                        catch (Exception e) {
                            try {
                                LOG.warn("Error saving file: {}/{} due to: {}", new Object[]{dir, name, e.getMessage(), e});
                                status = 500;
                            }
                            catch (Throwable throwable) {
                                IOHelper.close(fos);
                                FileUtil.deleteFile((File)tmp);
                                throw throwable;
                            }
                            IOHelper.close((Closeable)fos);
                            FileUtil.deleteFile((File)tmp);
                            break block7;
                        }
                        IOHelper.close((Closeable)fos);
                        FileUtil.deleteFile((File)tmp);
                        break block7;
                    }
                    for (int i = 0; i < n; ++i) {
                        File f = fileArray[i];
                        if (f.getName().startsWith(".") || f.isHidden() || !match.match(name, f.getName())) continue;
                        LOG.info("Deleting file: {}/{}", (Object)dir, (Object)name);
                        FileUtil.deleteFile((File)f);
                    }
                }
                ctx.response().setStatusCode(status);
                ctx.end();
            }
        };
        upload.handler((Handler)new BlockingHandlerDecorator((Handler)handler, true));
        uploadDelete.handler((Handler)new BlockingHandlerDecorator((Handler)handler, true));
        this.platformHttpComponent.addHttpEndpoint("/q/upload", "PUT,DELETE", null);
    }
}

