/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.platform.http.vertx;

import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpMethod;
import io.vertx.ext.web.FileUpload;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.RoutingContext;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Pattern;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.attachment.AttachmentMessage;
import org.apache.camel.attachment.CamelFileDataSource;
import org.apache.camel.component.platform.http.PlatformHttpEndpoint;
import org.apache.camel.component.platform.http.spi.Method;
import org.apache.camel.component.platform.http.vertx.VertxPlatformHttpRouter;
import org.apache.camel.component.platform.http.vertx.VertxPlatformHttpSupport;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.support.DefaultConsumer;
import org.apache.camel.util.FileUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VertxPlatformHttpConsumer
extends DefaultConsumer {
    private static final Logger LOGGER = LoggerFactory.getLogger(VertxPlatformHttpConsumer.class);
    private static final Pattern PATH_PARAMETER_PATTERN = Pattern.compile("\\{([^/}]+)\\}");
    private final List<Handler<RoutingContext>> handlers;
    private final String fileNameExtWhitelist;
    private Set<Method> methods;
    private String path;
    private Route route;
    private VertxPlatformHttpRouter router;

    public VertxPlatformHttpConsumer(PlatformHttpEndpoint endpoint, Processor processor, List<Handler<RoutingContext>> handlers) {
        super((Endpoint)endpoint, processor);
        this.handlers = handlers;
        this.fileNameExtWhitelist = endpoint.getFileNameExtWhitelist() == null ? null : endpoint.getFileNameExtWhitelist().toLowerCase(Locale.US);
    }

    public PlatformHttpEndpoint getEndpoint() {
        return (PlatformHttpEndpoint)super.getEndpoint();
    }

    protected void doInit() throws Exception {
        super.doInit();
        this.methods = Method.parseList((String)this.getEndpoint().getHttpMethodRestrict());
        this.path = this.configureEndpointPath(this.getEndpoint());
        this.router = VertxPlatformHttpRouter.lookup(this.getEndpoint().getCamelContext());
    }

    protected void doStart() throws Exception {
        super.doStart();
        Route newRoute = this.router.route(this.path);
        if (!this.methods.equals(Method.getAll())) {
            this.methods.forEach(m -> newRoute.method(HttpMethod.valueOf((String)m.name())));
        }
        if (this.getEndpoint().getConsumes() != null) {
            newRoute.consumes(this.getEndpoint().getConsumes());
        }
        if (this.getEndpoint().getProduces() != null) {
            newRoute.produces(this.getEndpoint().getProduces());
        }
        newRoute.handler(this.router.bodyHandler());
        for (Handler<RoutingContext> handler : this.handlers) {
            newRoute.handler(handler);
        }
        newRoute.handler(this::handleRequest);
        this.route = newRoute;
    }

    protected void doStop() throws Exception {
        if (this.route != null) {
            this.route.remove();
            this.route = null;
        }
        super.doStop();
    }

    protected void doSuspend() throws Exception {
        if (this.route != null) {
            this.route.disable();
        }
        super.doSuspend();
    }

    protected void doResume() throws Exception {
        if (this.route != null) {
            this.route.enable();
        }
        super.doResume();
    }

    private String configureEndpointPath(PlatformHttpEndpoint endpoint) {
        String path = endpoint.getPath();
        if (endpoint.isMatchOnUriPrefix() && !path.endsWith("*")) {
            path = path + "*";
        }
        return PATH_PARAMETER_PATTERN.matcher(path).replaceAll(":$1");
    }

    private void handleRequest(RoutingContext ctx) {
        Vertx vertx = ctx.vertx();
        Exchange exchange = this.toExchange(ctx);
        vertx.executeBlocking(promise -> {
            try {
                this.createUoW(exchange);
            }
            catch (Exception e) {
                promise.fail((Throwable)e);
                return;
            }
            this.getAsyncProcessor().process(exchange, c -> {
                if (!exchange.isFailed()) {
                    promise.complete();
                } else {
                    promise.fail((Throwable)exchange.getException());
                }
            });
        }, false, result -> {
            Throwable failure = null;
            try {
                if (result.succeeded()) {
                    try {
                        VertxPlatformHttpSupport.writeResponse(ctx, exchange, this.getEndpoint().getHeaderFilterStrategy());
                    }
                    catch (Exception e) {
                        failure = e;
                    }
                } else {
                    failure = result.cause();
                }
                if (failure != null) {
                    this.getExceptionHandler().handleException("Failed handling platform-http endpoint " + this.getEndpoint().getPath(), failure);
                    ctx.fail(failure);
                }
            }
            finally {
                this.doneUoW(exchange);
                this.releaseExchange(exchange, false);
            }
        });
    }

    private Exchange toExchange(RoutingContext ctx) {
        Exchange exchange = this.createExchange(false);
        exchange.setPattern(ExchangePattern.InOut);
        Message in = this.toCamelMessage(ctx, exchange);
        String charset = ctx.parsedHeaders().contentType().parameter("charset");
        if (charset != null) {
            exchange.setProperty(ExchangePropertyKey.CHARSET_NAME, (Object)charset);
            in.setHeader("CamelHttpCharacterEncoding", (Object)charset);
        }
        return exchange;
    }

    private Message toCamelMessage(RoutingContext ctx, Exchange exchange) {
        Message result = exchange.getIn();
        HeaderFilterStrategy headerFilterStrategy = this.getEndpoint().getHeaderFilterStrategy();
        VertxPlatformHttpSupport.populateCamelHeaders(ctx, result.getHeaders(), exchange, headerFilterStrategy);
        String mimeType = ctx.parsedHeaders().contentType().value();
        boolean isMultipartFormData = "multipart/form-data".equals(mimeType);
        if ("application/x-www-form-urlencoded".equals(mimeType) || isMultipartFormData) {
            MultiMap formData = ctx.request().formAttributes();
            HashMap<String, Object> body = new HashMap<String, Object>();
            for (String key : formData.names()) {
                for (String value : formData.getAll(key)) {
                    if (headerFilterStrategy == null || headerFilterStrategy.applyFilterToExternalHeaders(key, (Object)value, exchange)) continue;
                    VertxPlatformHttpSupport.appendHeader(result.getHeaders(), key, value);
                    VertxPlatformHttpSupport.appendHeader(body, key, value);
                }
            }
            if (!body.isEmpty()) {
                result.setBody(body);
            }
            if (isMultipartFormData) {
                this.populateAttachments(ctx.fileUploads(), result);
            }
        } else {
            Method m = Method.valueOf((String)ctx.request().method().name());
            if (m.canHaveBody()) {
                Buffer body = ctx.getBody();
                if (body != null) {
                    result.setBody((Object)body);
                } else {
                    result.setBody(null);
                }
            } else {
                result.setBody(null);
            }
        }
        return result;
    }

    private void populateAttachments(Set<FileUpload> uploads, Message message) {
        for (FileUpload upload : uploads) {
            String ext;
            String name = upload.name();
            String fileName = upload.fileName();
            LOGGER.trace("HTTP attachment {} = {}", (Object)name, (Object)fileName);
            boolean accepted = true;
            if (this.fileNameExtWhitelist != null && (ext = FileUtil.onlyExt((String)fileName)) != null) {
                ext = ext.toLowerCase(Locale.US);
                if (!this.fileNameExtWhitelist.equals("*") && !this.fileNameExtWhitelist.contains(ext)) {
                    accepted = false;
                }
            }
            if (accepted) {
                File localFile = new File(upload.uploadedFileName());
                AttachmentMessage attachmentMessage = (AttachmentMessage)message.getExchange().getMessage(AttachmentMessage.class);
                attachmentMessage.addAttachment(fileName, new DataHandler((DataSource)new CamelFileDataSource(localFile, fileName)));
                continue;
            }
            LOGGER.debug("Cannot add file as attachment: {} because the file is not accepted according to fileNameExtWhitelist: {}", (Object)fileName, (Object)this.fileNameExtWhitelist);
        }
    }
}

