/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.platform.http.vertx;

import io.vertx.core.Vertx;
import io.vertx.core.http.CookieSameSite;
import io.vertx.ext.web.handler.SessionHandler;
import io.vertx.ext.web.sstore.ClusteredSessionStore;
import io.vertx.ext.web.sstore.LocalSessionStore;
import io.vertx.ext.web.sstore.SessionStore;
import java.time.Duration;
import java.util.List;
import org.apache.camel.component.platform.http.vertx.auth.AuthenticationConfig;
import org.apache.camel.support.jsse.SSLContextParameters;

public class VertxPlatformHttpServerConfiguration {
    public static final String DEFAULT_BIND_HOST = "0.0.0.0";
    public static final int DEFAULT_BIND_PORT = 8080;
    public static final String DEFAULT_PATH = "/";
    private String bindHost = "0.0.0.0";
    private int bindPort = 8080;
    private String path = "/";
    private Long maxBodySize;
    private SSLContextParameters sslContextParameters;
    private boolean useGlobalSslContextParameters;
    private BodyHandler bodyHandler = new BodyHandler();
    private Cors cors = new Cors();
    private SessionConfig sessionConfig = new SessionConfig();
    private AuthenticationConfig authenticationConfig = new AuthenticationConfig();

    public int getPort() {
        return this.getBindPort();
    }

    public void setPort(int port) {
        this.setBindPort(port);
    }

    public void setHost(String host) {
        this.setBindHost(host);
    }

    public String getHost() {
        return this.getBindHost();
    }

    public String getBindHost() {
        return this.bindHost;
    }

    public void setBindHost(String bindHost) {
        this.bindHost = bindHost;
    }

    public int getBindPort() {
        return this.bindPort;
    }

    public void setBindPort(int bindPort) {
        this.bindPort = bindPort;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public Long getMaxBodySize() {
        return this.maxBodySize;
    }

    public void setMaxBodySize(Long maxBodySize) {
        this.maxBodySize = maxBodySize;
    }

    public SSLContextParameters getSslContextParameters() {
        return this.sslContextParameters;
    }

    public void setSslContextParameters(SSLContextParameters sslContextParameters) {
        this.sslContextParameters = sslContextParameters;
    }

    public boolean isUseGlobalSslContextParameters() {
        return this.useGlobalSslContextParameters;
    }

    public void setUseGlobalSslContextParameters(boolean useGlobalSslContextParameters) {
        this.useGlobalSslContextParameters = useGlobalSslContextParameters;
    }

    public Cors getCors() {
        return this.cors;
    }

    public void setCors(Cors corsConfiguration) {
        this.cors = corsConfiguration;
    }

    public SessionConfig getSessionConfig() {
        return this.sessionConfig;
    }

    public void setSessionConfig(SessionConfig sessionConfig) {
        this.sessionConfig = sessionConfig;
    }

    public BodyHandler getBodyHandler() {
        return this.bodyHandler;
    }

    public void setBodyHandler(BodyHandler bodyHandler) {
        this.bodyHandler = bodyHandler;
    }

    public AuthenticationConfig getAuthenticationConfig() {
        return this.authenticationConfig;
    }

    public void setAuthenticationConfig(AuthenticationConfig authenticationConfig) {
        this.authenticationConfig = authenticationConfig;
    }

    public static class BodyHandler {
        private boolean handleFileUploads = true;
        private String uploadsDirectory;
        private boolean mergeFormAttributes = true;
        private boolean deleteUploadedFilesOnEnd = true;
        private boolean preallocateBodyBuffer = true;

        public boolean isHandleFileUploads() {
            return this.handleFileUploads;
        }

        public void setHandleFileUploads(boolean handleFileUploads) {
            this.handleFileUploads = handleFileUploads;
        }

        public String getUploadsDirectory() {
            return this.uploadsDirectory;
        }

        public void setUploadsDirectory(String uploadsDirectory) {
            this.uploadsDirectory = uploadsDirectory;
        }

        public boolean isMergeFormAttributes() {
            return this.mergeFormAttributes;
        }

        public void setMergeFormAttributes(boolean mergeFormAttributes) {
            this.mergeFormAttributes = mergeFormAttributes;
        }

        public boolean isDeleteUploadedFilesOnEnd() {
            return this.deleteUploadedFilesOnEnd;
        }

        public void setDeleteUploadedFilesOnEnd(boolean deleteUploadedFilesOnEnd) {
            this.deleteUploadedFilesOnEnd = deleteUploadedFilesOnEnd;
        }

        public boolean isPreallocateBodyBuffer() {
            return this.preallocateBodyBuffer;
        }

        public void setPreallocateBodyBuffer(boolean preallocateBodyBuffer) {
            this.preallocateBodyBuffer = preallocateBodyBuffer;
        }
    }

    public static class Cors {
        private boolean enabled;
        private List<String> origins;
        private List<String> methods;
        private List<String> headers;
        private List<String> exposedHeaders;
        private Duration accessControlMaxAge;

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public List<String> getOrigins() {
            return this.origins;
        }

        public void setOrigins(List<String> origins) {
            this.origins = origins;
        }

        public List<String> getMethods() {
            return this.methods;
        }

        public void setMethods(List<String> methods) {
            this.methods = methods;
        }

        public List<String> getHeaders() {
            return this.headers;
        }

        public List<String> getExposedHeaders() {
            return this.exposedHeaders;
        }

        public void setExposedHeaders(List<String> exposedHeaders) {
            this.exposedHeaders = exposedHeaders;
        }

        public void setHeaders(List<String> headers) {
            this.headers = headers;
        }

        public Duration getAccessControlMaxAge() {
            return this.accessControlMaxAge;
        }

        public void setAccessControlMaxAge(Duration accessControlMaxAge) {
            this.accessControlMaxAge = accessControlMaxAge;
        }
    }

    public static class SessionConfig {
        private boolean enabled;
        private SessionStoreType storeType = SessionStoreType.LOCAL;
        private String sessionCookieName = "vertx-web.session";
        private String sessionCookiePath = "/";
        private long sessionTimeOut = 1800000L;
        private boolean cookieSecure = false;
        private boolean cookieHttpOnly = false;
        private int sessionIdMinLength = 16;
        private CookieSameSite cookieSameSite = CookieSameSite.STRICT;

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public SessionStoreType getStoreType() {
            return this.storeType;
        }

        public void setStoreType(SessionStoreType storeType) {
            this.storeType = storeType;
        }

        public String getSessionCookieName() {
            return this.sessionCookieName;
        }

        public void setSessionCookieName(String sessionCookieName) {
            this.sessionCookieName = sessionCookieName;
        }

        public String getSessionCookiePath() {
            return this.sessionCookiePath;
        }

        public void setSessionCookiePath(String sessionCookiePath) {
            this.sessionCookiePath = sessionCookiePath;
        }

        public long getSessionTimeOut() {
            return this.sessionTimeOut;
        }

        public void setSessionTimeout(long timeout) {
            this.sessionTimeOut = timeout;
        }

        public boolean isCookieSecure() {
            return this.cookieSecure;
        }

        public void setCookieSecure(boolean cookieSecure) {
            this.cookieSecure = cookieSecure;
        }

        public boolean isCookieHttpOnly() {
            return this.cookieHttpOnly;
        }

        public void setCookieHttpOnly(boolean cookieHttpOnly) {
            this.cookieHttpOnly = cookieHttpOnly;
        }

        public int getSessionIdMinLength() {
            return this.sessionIdMinLength;
        }

        public void setSessionIdMinLength(int sessionIdMinLength) {
            this.sessionIdMinLength = sessionIdMinLength;
        }

        public CookieSameSite getCookieSameSite() {
            return this.cookieSameSite;
        }

        public void setCookieSameSite(CookieSameSite cookieSameSite) {
            this.cookieSameSite = cookieSameSite;
        }

        public SessionHandler createSessionHandler(Vertx vertx) {
            SessionStore sessionStore = this.storeType.create(vertx);
            SessionHandler handler = SessionHandler.create((SessionStore)sessionStore);
            this.configure(handler);
            return handler;
        }

        private void configure(SessionHandler handler) {
            handler.setSessionTimeout(this.sessionTimeOut).setSessionCookieName(this.sessionCookieName).setSessionCookiePath(this.sessionCookiePath).setSessionTimeout(this.sessionTimeOut).setCookieHttpOnlyFlag(this.cookieHttpOnly).setCookieSecureFlag(this.cookieSecure).setMinLength(this.sessionIdMinLength).setCookieSameSite(this.cookieSameSite);
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum SessionStoreType {
        LOCAL{

            @Override
            public SessionStore create(Vertx vertx) {
                return LocalSessionStore.create((Vertx)vertx);
            }
        }
        ,
        CLUSTERED{

            @Override
            public SessionStore create(Vertx vertx) {
                return ClusteredSessionStore.create((Vertx)vertx);
            }
        };


        public abstract SessionStore create(Vertx var1);
    }
}

