/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.platform.http.vertx;

import io.netty.handler.codec.http.HttpHeaderValues;
import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.streams.Pump;
import io.vertx.core.streams.ReadStream;
import io.vertx.core.streams.WriteStream;
import io.vertx.ext.web.RoutingContext;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.TypeConverter;
import org.apache.camel.component.platform.http.vertx.AsyncInputStream;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.MessageHelper;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class VertxPlatformHttpSupport {
    private static final Logger LOGGER = LoggerFactory.getLogger(VertxPlatformHttpSupport.class);
    public static final String DEFAULT_CONTENT_TYPE_ON_EXCEPTION = "text/plain; charset=utf-8";

    private VertxPlatformHttpSupport() {
    }

    static Object toHttpResponse(HttpServerResponse response, Message message, HeaderFilterStrategy headerFilterStrategy, boolean muteExceptions) {
        Object body;
        Integer length;
        Exchange exchange = message.getExchange();
        int code = VertxPlatformHttpSupport.determineResponseCode(exchange, message.getBody());
        response.setStatusCode(code);
        if (headerFilterStrategy != null) {
            VertxPlatformHttpSupport.copyMessageHeadersToResponse(response, message, headerFilterStrategy, exchange);
        }
        if ((length = VertxPlatformHttpSupport.determineContentLength(body = VertxPlatformHttpSupport.getBody(message, muteExceptions, exchange))) != null) {
            response.putHeader("Content-Length", String.valueOf(length));
        } else {
            response.setChunked(true);
        }
        String contentType = MessageHelper.getContentType((Message)message);
        if (contentType != null) {
            response.putHeader("Content-Type", contentType);
        }
        return body;
    }

    private static Object getBody(Message message, boolean muteExceptions, Exchange exchange) {
        Exception exception = exchange.getException();
        if (exception != null) {
            return VertxPlatformHttpSupport.handleExceptions(message, muteExceptions, exception, exchange);
        }
        return message.getBody();
    }

    private static Object handleExceptions(Message message, boolean muteExceptions, Exception exception, Exchange exchange) {
        Object body;
        if (muteExceptions) {
            body = "";
            message.setHeader("Content-Type", (Object)DEFAULT_CONTENT_TYPE_ON_EXCEPTION);
        } else {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            exception.printStackTrace(pw);
            body = ByteBuffer.wrap(sw.toString().getBytes(StandardCharsets.UTF_8));
            message.setHeader("Content-Type", (Object)DEFAULT_CONTENT_TYPE_ON_EXCEPTION);
        }
        ExchangeHelper.setFailureHandled((Exchange)exchange);
        return body;
    }

    private static void copyMessageHeadersToResponse(HttpServerResponse response, Message message, HeaderFilterStrategy headerFilterStrategy, Exchange exchange) {
        TypeConverter tc = exchange.getContext().getTypeConverter();
        for (Map.Entry entry : message.getHeaders().entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            Iterator it = org.apache.camel.support.ObjectHelper.createIterator(value, null, (boolean)true);
            VertxPlatformHttpSupport.putHeader(response, headerFilterStrategy, exchange, it, tc, key);
        }
    }

    private static void putHeader(HttpServerResponse response, HeaderFilterStrategy headerFilterStrategy, Exchange exchange, Iterator<?> it, TypeConverter tc, String key) {
        String firstValue = null;
        ArrayList<String> values = null;
        while (it.hasNext()) {
            String headerValue = (String)tc.convertTo(String.class, it.next());
            if (headerValue == null || headerFilterStrategy.applyFilterToCamelHeaders(key, (Object)headerValue, exchange)) continue;
            if (firstValue == null) {
                firstValue = headerValue;
                continue;
            }
            if (values == null) {
                values = new ArrayList<String>();
                values.add(firstValue);
            }
            values.add(headerValue);
        }
        if (values != null) {
            response.putHeader(key, values);
        } else if (firstValue != null) {
            response.putHeader(key, firstValue);
        }
    }

    static Integer determineContentLength(Object body) {
        if (body instanceof byte[]) {
            return ((byte[])body).length;
        }
        if (body instanceof ByteBuffer) {
            return ((ByteBuffer)body).remaining();
        }
        return null;
    }

    static int determineResponseCode(Exchange camelExchange, Object body) {
        int codeToUse;
        boolean failed = camelExchange.isFailed();
        int defaultCode = failed ? 500 : 200;
        Message message = camelExchange.getMessage();
        Integer currentCode = (Integer)message.getHeader("CamelHttpResponseCode", Integer.class);
        int n = codeToUse = currentCode == null ? defaultCode : currentCode;
        if (codeToUse != 500 && (body == null || body instanceof String && ((String)body).isBlank())) {
            codeToUse = currentCode == null ? 204 : currentCode;
        }
        return codeToUse;
    }

    static Future<Void> writeResponse(RoutingContext ctx, Exchange camelExchange, HeaderFilterStrategy headerFilterStrategy, boolean muteExceptions) {
        Object body = VertxPlatformHttpSupport.toHttpResponse(ctx.response(), camelExchange.getMessage(), headerFilterStrategy, muteExceptions);
        Promise promise = Promise.promise();
        if (body == null) {
            LOGGER.trace("No payload to send as reply for exchange: {}", (Object)camelExchange);
            ctx.end();
            promise.complete();
        } else if (body instanceof String) {
            ctx.end((String)body);
            promise.complete();
        } else if (body instanceof InputStream) {
            VertxPlatformHttpSupport.writeResponseAs((Promise<Void>)promise, ctx, (InputStream)body);
        } else if (body instanceof Buffer) {
            ctx.end((Buffer)body);
            promise.complete();
        } else {
            try {
                VertxPlatformHttpSupport.writeResponseAsFallback((Promise<Void>)promise, camelExchange, body, ctx);
            }
            catch (IOException | NoTypeConversionAvailableException e) {
                promise.fail(e);
            }
        }
        return promise.future();
    }

    private static void writeResponseAsFallback(Promise<Void> promise, Exchange camelExchange, Object body, RoutingContext ctx) throws NoTypeConversionAvailableException, IOException {
        TypeConverter tc = camelExchange.getContext().getTypeConverter();
        ByteBuffer bb = (ByteBuffer)tc.tryConvertTo(ByteBuffer.class, camelExchange, body);
        if (bb != null) {
            VertxPlatformHttpSupport.writeResponseAs(promise, ctx, bb);
        } else {
            InputStream is = (InputStream)tc.mandatoryConvertTo(InputStream.class, camelExchange, body);
            VertxPlatformHttpSupport.writeResponseAs(promise, ctx, is);
        }
    }

    private static void writeResponseAs(Promise<Void> promise, RoutingContext ctx, ByteBuffer bb) {
        Buffer b = Buffer.buffer((int)bb.capacity());
        b.setBytes(0, bb);
        ctx.end(b);
        promise.complete();
    }

    private static void writeResponseAs(Promise<Void> promise, RoutingContext ctx, InputStream is) {
        HttpServerResponse response = ctx.response();
        Vertx vertx = ctx.vertx();
        Context context = vertx.getOrCreateContext();
        AsyncInputStream asyncInputStream = new AsyncInputStream(vertx, context, is);
        asyncInputStream.exceptionHandler(arg_0 -> promise.fail(arg_0));
        asyncInputStream.endHandler(event -> response.end().onComplete(result -> asyncInputStream.close((Handler<AsyncResult<Void>>)((Handler)closeResult -> promise.complete()))));
        Pump pump = Pump.pump((ReadStream)asyncInputStream, (WriteStream)response);
        context.runOnContext(event -> pump.start());
    }

    static void populateCamelHeaders(RoutingContext ctx, Map<String, Object> headersMap, Exchange exchange, HeaderFilterStrategy headerFilterStrategy) {
        SocketAddress remoteAddress;
        HttpServerRequest request = ctx.request();
        headersMap.put("CamelHttpPath", ctx.normalizedPath());
        if (headerFilterStrategy != null) {
            VertxPlatformHttpSupport.applyHeaderFilterStrategy(ctx, headersMap, exchange, headerFilterStrategy, request);
        }
        for (Map.Entry en : ctx.pathParams().entrySet()) {
            VertxPlatformHttpSupport.appendHeader(headersMap, (String)en.getKey(), en.getValue());
        }
        SocketAddress localAddress = request.localAddress();
        if (localAddress != null) {
            headersMap.put("CamelVertxPlatformHttpLocalAddress", localAddress);
        }
        if ((remoteAddress = request.remoteAddress()) != null) {
            headersMap.put("CamelVertxPlatformHttpRemoteAddress", remoteAddress);
        }
        headersMap.put("CamelHttpMethod", request.method().toString());
        headersMap.put("CamelHttpUrl", request.absoluteURI());
        headersMap.put("CamelHttpUri", request.uri());
        headersMap.put("CamelHttpQuery", request.query());
        headersMap.put("CamelHttpRawQuery", request.query());
    }

    private static void applyHeaderFilterStrategy(RoutingContext ctx, Map<String, Object> headersMap, Exchange exchange, HeaderFilterStrategy headerFilterStrategy, HttpServerRequest request) {
        MultiMap requestHeaders = request.headers();
        String authz = requestHeaders.get("authorization");
        if (authz != null && authz.trim().startsWith("Basic") && !headerFilterStrategy.applyFilterToExternalHeaders("CamelAuthentication", (Object)"Basic", exchange)) {
            VertxPlatformHttpSupport.appendHeader(headersMap, "CamelAuthentication", "Basic");
        }
        for (String name : requestHeaders.names()) {
            for (String value : requestHeaders.getAll(name)) {
                if (headerFilterStrategy.applyFilterToExternalHeaders(name, (Object)value, exchange)) continue;
                VertxPlatformHttpSupport.appendHeader(headersMap, name, value);
            }
        }
        MultiMap pathParameters = ctx.queryParams();
        if (!pathParameters.isEmpty()) {
            for (String name : pathParameters.names()) {
                for (String value : pathParameters.getAll(name)) {
                    if (headerFilterStrategy.applyFilterToExternalHeaders(name, (Object)value, exchange)) continue;
                    VertxPlatformHttpSupport.appendHeader(headersMap, name, value);
                }
            }
        }
    }

    static void appendHeader(Map<String, Object> headers, String key, Object value) {
        if (headers.containsKey(key)) {
            value = VertxPlatformHttpSupport.addToList(headers, key, value);
        }
        headers.put(key, value);
    }

    private static Object addToList(Map<String, Object> headers, String key, Object value) {
        ArrayList<Object> list;
        Object existing = headers.get(key);
        if (existing instanceof List) {
            list = (ArrayList<Object>)existing;
        } else {
            list = new ArrayList<Object>();
            list.add(existing);
        }
        list.add(value);
        value = list;
        return value;
    }

    static boolean isMultiPartFormData(RoutingContext ctx) {
        return VertxPlatformHttpSupport.isContentTypeMatching(ctx, HttpHeaderValues.MULTIPART_FORM_DATA.toString());
    }

    static boolean isFormUrlEncoded(RoutingContext ctx) {
        return VertxPlatformHttpSupport.isContentTypeMatching(ctx, HttpHeaderValues.APPLICATION_X_WWW_FORM_URLENCODED.toString());
    }

    private static boolean isContentTypeMatching(RoutingContext ctx, String expectedContentType) {
        String contentType = ctx.parsedHeaders().contentType().value();
        boolean match = false;
        if (ObjectHelper.isNotEmpty((String)contentType)) {
            String lowerCaseContentType = contentType.toLowerCase();
            match = lowerCaseContentType.startsWith(expectedContentType);
        }
        return match;
    }
}

