/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.platform.http;

import org.apache.camel.AsyncEndpoint;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.platform.http.PlatformHttpHeaderFilterStrategy;
import org.apache.camel.component.platform.http.spi.PlatformHttpEngine;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spi.HeaderFilterStrategyAware;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriEndpoint(firstVersion="3.0.0", scheme="platform-http", title="Platform HTTP", syntax="platform-http:path", label="http", consumerOnly=true)
public class PlatformHttpEndpoint
extends DefaultEndpoint
implements AsyncEndpoint,
HeaderFilterStrategyAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(PlatformHttpEndpoint.class);
    @UriPath(description="The path under which this endpoint serves the HTTP requests")
    @Metadata(required=true)
    private final String path;
    @UriParam(label="consumer", description="A comma separated list of HTTP methods to serve, e.g. GET,POST . If no methods are specified, all methods will be served.")
    private String httpMethodRestrict;
    @UriParam(label="consumer", description="The content type this endpoint accepts as an input, such as application/xml or application/json. <code>null</code> or <code>&#42;/&#42;</code> mean no restriction.")
    private String consumes;
    @UriParam(label="consumer", description="The content type this endpoint produces, such as application/xml or application/json.")
    private String produces;
    @UriParam(label="consumer,advanced", description="A comma or whitespace separated list of file extensions. Uploads having these extensions will be stored locally. Null value or asterisk (*) will allow all files.")
    private String fileNameExtWhitelist;
    @UriParam(label="advanced", description="An HTTP Server engine implementation to serve the requests of this endpoint.")
    private PlatformHttpEngine platformHttpEngine;
    @UriParam(label="advanced", description="To use a custom HeaderFilterStrategy to filter headers to and from Camel message.")
    private HeaderFilterStrategy headerFilterStrategy = new PlatformHttpHeaderFilterStrategy();

    public PlatformHttpEndpoint(String uri, String remaining, Component component) {
        super(uri, component);
        this.path = remaining;
    }

    public Producer createProducer() throws Exception {
        throw new UnsupportedOperationException("Producer is not supported");
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        return this.platformHttpEngine.createConsumer(this, processor);
    }

    public HeaderFilterStrategy getHeaderFilterStrategy() {
        return this.headerFilterStrategy;
    }

    public void setHeaderFilterStrategy(HeaderFilterStrategy headerFilterStrategy) {
        this.headerFilterStrategy = headerFilterStrategy;
    }

    public String getPath() {
        return this.path;
    }

    public PlatformHttpEngine getPlatformHttpEngine() {
        return this.platformHttpEngine;
    }

    public void setPlatformHttpEngine(PlatformHttpEngine platformHttpEngine) {
        this.platformHttpEngine = platformHttpEngine;
    }

    public String getHttpMethodRestrict() {
        return this.httpMethodRestrict;
    }

    public void setHttpMethodRestrict(String httpMethodRestrict) {
        this.httpMethodRestrict = httpMethodRestrict;
    }

    public String getFileNameExtWhitelist() {
        return this.fileNameExtWhitelist;
    }

    public void setFileNameExtWhitelist(String fileNameExtWhitelist) {
        this.fileNameExtWhitelist = fileNameExtWhitelist;
    }

    public String getConsumes() {
        return this.consumes;
    }

    public void setConsumes(String consumes) {
        this.consumes = consumes;
    }

    public String getProduces() {
        return this.produces;
    }

    public void setProduces(String produces) {
        this.produces = produces;
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.platformHttpEngine == null) {
            LOGGER.debug("Lookup platform http engine from registry");
            this.platformHttpEngine = (PlatformHttpEngine)this.getCamelContext().getRegistry().lookupByNameAndType("platform-http-engine", PlatformHttpEngine.class);
            if (this.platformHttpEngine == null) {
                throw new IllegalStateException(PlatformHttpEngine.class.getSimpleName() + " neither set on this " + PlatformHttpEndpoint.class.getSimpleName() + " neither found in Camel Registry.");
            }
        }
    }
}

