/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.platform.http;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.Processor;
import org.apache.camel.component.platform.http.PlatformHttpEndpoint;
import org.apache.camel.component.platform.http.spi.PlatformHttpEngine;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.RestApiConsumerFactory;
import org.apache.camel.spi.RestConfiguration;
import org.apache.camel.spi.RestConsumerFactory;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.support.RestComponentHelper;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.FileUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@org.apache.camel.spi.annotations.Component(value="platform-http")
public class PlatformHttpComponent
extends DefaultComponent
implements RestConsumerFactory,
RestApiConsumerFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(PlatformHttpComponent.class);
    @Metadata(label="advanced", description="An HTTP Server engine implementation to serve the requests")
    private volatile PlatformHttpEngine engine;
    private volatile boolean localEngine;
    private final Object lock = new Object();

    public PlatformHttpComponent() {
        this(null);
    }

    public PlatformHttpComponent(CamelContext context) {
        super(context);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        PlatformHttpEndpoint endpoint = new PlatformHttpEndpoint(uri, remaining, (Component)this);
        endpoint.setPlatformHttpEngine(this.engine);
        return endpoint;
    }

    public Consumer createApiConsumer(CamelContext camelContext, Processor processor, String contextPath, RestConfiguration configuration, Map<String, Object> parameters) throws Exception {
        return this.doCreateConsumer(camelContext, processor, "GET", contextPath, null, null, null, configuration, parameters, true);
    }

    public Consumer createConsumer(CamelContext camelContext, Processor processor, String verb, String basePath, String uriTemplate, String consumes, String produces, RestConfiguration configuration, Map<String, Object> parameters) throws Exception {
        return this.doCreateConsumer(camelContext, processor, verb, basePath, uriTemplate, consumes, produces, configuration, parameters, false);
    }

    protected void doStart() throws Exception {
        super.doStart();
        ServiceHelper.startService((Object)this.getOrCreateEngine());
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this.localEngine) {
            ServiceHelper.stopService((Object)this.engine);
        }
    }

    public PlatformHttpEngine getEngine() {
        return this.engine;
    }

    public void setEngine(PlatformHttpEngine engine) {
        this.engine = engine;
    }

    private Consumer doCreateConsumer(CamelContext camelContext, Processor processor, String verb, String basePath, String uriTemplate, String consumes, String produces, RestConfiguration configuration, Map<String, Object> parameters, boolean api) throws Exception {
        String path = basePath;
        if (uriTemplate != null) {
            path = uriTemplate.startsWith("/") ? path + uriTemplate : path + "/" + uriTemplate;
        }
        path = FileUtil.stripLeadingSeparator((String)path);
        RestConfiguration config = configuration;
        if (config == null) {
            config = CamelContextHelper.getRestConfiguration((CamelContext)this.getCamelContext(), (String)"platform-http");
        }
        Map map = RestComponentHelper.initRestEndpointProperties((String)"platform-http", (RestConfiguration)config);
        boolean cors = config.isEnableCORS();
        if (cors) {
            map.put("optionsEnabled", "true");
        }
        if (api) {
            map.put("matchOnUriPrefix", "true");
        }
        RestComponentHelper.addHttpRestrictParam((Map)map, (String)verb, (boolean)cors);
        String url = RestComponentHelper.createRestConsumerUrl((String)"platform-http", (String)path, (Map)map);
        PlatformHttpEndpoint endpoint = (PlatformHttpEndpoint)camelContext.getEndpoint(url, PlatformHttpEndpoint.class);
        this.setProperties((Endpoint)endpoint, parameters);
        endpoint.setConsumes(consumes);
        endpoint.setProduces(produces);
        Consumer consumer = endpoint.createConsumer(processor);
        if (config.getConsumerProperties() != null && !config.getConsumerProperties().isEmpty()) {
            this.setProperties(camelContext, consumer, config.getConsumerProperties());
        }
        return consumer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PlatformHttpEngine getOrCreateEngine() {
        if (this.engine == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.engine == null) {
                    LOGGER.debug("Lookup platform http engine from registry");
                    this.engine = (PlatformHttpEngine)this.getCamelContext().getRegistry().lookupByNameAndType("platform-http-engine", PlatformHttpEngine.class);
                    if (this.engine == null) {
                        LOGGER.debug("Lookup platform http engine from factory");
                        this.engine = (PlatformHttpEngine)((ExtendedCamelContext)this.getCamelContext().adapt(ExtendedCamelContext.class)).getFactoryFinder("META-INF/services/org/apache/camel/").newInstance("platform-http-engine", PlatformHttpEngine.class).orElseThrow(() -> new IllegalStateException("PlatformHttpEngine is neither set on this endpoint neither found in Camel Registry or FactoryFinder."));
                        this.localEngine = true;
                    }
                }
            }
        }
        CamelContextAware.trySetCamelContext((Object)this.engine, (CamelContext)this.getCamelContext());
        ServiceHelper.initService((Object)this.engine);
        return this.engine;
    }
}

