/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.platform.http;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.component.platform.http.HttpEndpointModel;
import org.apache.camel.component.platform.http.PlatformHttpEndpoint;
import org.apache.camel.component.platform.http.spi.PlatformHttpEngine;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.RestApiConsumerFactory;
import org.apache.camel.spi.RestConfiguration;
import org.apache.camel.spi.RestConsumerFactory;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.support.RestComponentHelper;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@org.apache.camel.spi.annotations.Component(value="platform-http")
public class PlatformHttpComponent
extends DefaultComponent
implements RestConsumerFactory,
RestApiConsumerFactory {
    private static final Logger LOG = LoggerFactory.getLogger(PlatformHttpComponent.class);
    @Metadata(label="advanced", description="An HTTP Server engine implementation to serve the requests")
    private volatile PlatformHttpEngine engine;
    private final Set<HttpEndpointModel> httpEndpoints = new TreeSet<HttpEndpointModel>();
    private volatile boolean localEngine;
    private final Object lock = new Object();

    public PlatformHttpComponent() {
        this(null);
    }

    public PlatformHttpComponent(CamelContext context) {
        super(context);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        PlatformHttpEndpoint endpoint = new PlatformHttpEndpoint(uri, remaining, (Component)this);
        endpoint.setPlatformHttpEngine(this.engine);
        this.setProperties((Endpoint)endpoint, parameters);
        return endpoint;
    }

    public Consumer createApiConsumer(CamelContext camelContext, Processor processor, String contextPath, RestConfiguration configuration, Map<String, Object> parameters) throws Exception {
        Consumer consumer = this.doCreateConsumer(camelContext, processor, "GET", contextPath, null, null, null, configuration, parameters, true);
        this.addHttpEndpoint(contextPath, "GET");
        return consumer;
    }

    public Consumer createConsumer(CamelContext camelContext, Processor processor, String verb, String basePath, String uriTemplate, String consumes, String produces, RestConfiguration configuration, Map<String, Object> parameters) throws Exception {
        Consumer consumer = this.doCreateConsumer(camelContext, processor, verb, basePath, uriTemplate, consumes, produces, configuration, parameters, false);
        if (uriTemplate != null) {
            if (uriTemplate.startsWith("/")) {
                this.addHttpEndpoint(basePath + uriTemplate, verb);
            } else {
                this.addHttpEndpoint(basePath + "/" + uriTemplate, verb);
            }
        } else {
            this.addHttpEndpoint(basePath, verb);
        }
        return consumer;
    }

    public void addHttpEndpoint(String uri, String verbs) {
        HttpEndpointModel model = this.httpEndpoints.stream().filter(e -> e.getUri().equals(uri)).findFirst().orElse(null);
        if (model == null) {
            model = new HttpEndpointModel(uri, verbs);
            this.httpEndpoints.add(model);
        } else {
            model.addVerb(verbs);
        }
    }

    public void removeHttpEndpoint(String uri) {
        this.httpEndpoints.stream().filter(e -> e.getUri().equals(uri)).findFirst().ifPresent(this.httpEndpoints::remove);
    }

    public Set<HttpEndpointModel> getHttpEndpoints() {
        return Collections.unmodifiableSet(this.httpEndpoints);
    }

    protected void doStart() throws Exception {
        super.doStart();
        ServiceHelper.startService((Object)this.getOrCreateEngine());
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this.localEngine) {
            ServiceHelper.stopService((Object)this.engine);
        }
    }

    public PlatformHttpEngine getEngine() {
        return this.engine;
    }

    public void setEngine(PlatformHttpEngine engine) {
        this.engine = engine;
    }

    private Consumer doCreateConsumer(CamelContext camelContext, Processor processor, String verb, String basePath, String uriTemplate, String consumes, String produces, RestConfiguration configuration, Map<String, Object> parameters, boolean api) throws Exception {
        String contextPath;
        Object path = basePath;
        if (uriTemplate != null) {
            path = uriTemplate.startsWith("/") ? (String)path + uriTemplate : (String)path + "/" + uriTemplate;
        }
        path = FileUtil.stripLeadingSeparator((String)path);
        RestConfiguration config = configuration;
        if (config == null) {
            config = CamelContextHelper.getRestConfiguration((CamelContext)this.getCamelContext(), (String)"platform-http");
        }
        if (ObjectHelper.isNotEmpty((String)(contextPath = config.getContextPath()))) {
            contextPath = FileUtil.stripTrailingSeparator((String)contextPath);
            if (ObjectHelper.isNotEmpty((String)(contextPath = FileUtil.stripLeadingSeparator((String)contextPath)))) {
                path = contextPath + "/" + (String)path;
            }
        }
        Map map = RestComponentHelper.initRestEndpointProperties((String)"platform-http", (RestConfiguration)config);
        boolean cors = config.isEnableCORS();
        if (api) {
            map.put("matchOnUriPrefix", "true");
        }
        RestComponentHelper.addHttpRestrictParam((Map)map, (String)verb, (boolean)cors);
        String url = RestComponentHelper.createRestConsumerUrl((String)"platform-http", (String)path, (Map)map);
        PlatformHttpEndpoint endpoint = (PlatformHttpEndpoint)camelContext.getEndpoint(url, parameters);
        endpoint.setConsumes(consumes);
        endpoint.setProduces(produces);
        Consumer consumer = endpoint.createConsumer(processor);
        if (config.getConsumerProperties() != null && !config.getConsumerProperties().isEmpty()) {
            this.setProperties(camelContext, consumer, config.getConsumerProperties());
        }
        return consumer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PlatformHttpEngine getOrCreateEngine() {
        if (this.engine == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.engine == null) {
                    LOG.debug("Lookup platform http engine from registry");
                    this.engine = (PlatformHttpEngine)this.getCamelContext().getRegistry().lookupByNameAndType("platform-http-engine", PlatformHttpEngine.class);
                    if (this.engine == null) {
                        LOG.debug("Lookup platform http engine from factory");
                        this.engine = (PlatformHttpEngine)this.getCamelContext().getCamelContextExtension().getFactoryFinder("META-INF/services/org/apache/camel/").newInstance("platform-http-engine", PlatformHttpEngine.class).orElseThrow(() -> new IllegalStateException("PlatformHttpEngine is neither set on this endpoint neither found in Camel Registry or FactoryFinder."));
                        this.localEngine = true;
                    }
                }
            }
        }
        CamelContextAware.trySetCamelContext((Object)this.engine, (CamelContext)this.getCamelContext());
        ServiceHelper.initService((Object)this.engine);
        return this.engine;
    }

    protected void doInit() throws Exception {
        super.doInit();
        try {
            RestConfiguration config = CamelContextHelper.getRestConfiguration((CamelContext)this.getCamelContext(), (String)"platform-http");
            if (config.getComponentProperties() != null && !config.getComponentProperties().isEmpty()) {
                this.setProperties((Object)this, config.getComponentProperties());
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

