/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.platform.http.spi;

import java.util.Arrays;
import java.util.Collections;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;

public enum Method {
    GET,
    HEAD,
    POST,
    PUT,
    DELETE,
    TRACE,
    OPTIONS,
    CONNECT,
    PATCH;

    private static final Set<Method> ALL;

    public static Set<Method> getAll() {
        return ALL;
    }

    public static Set<Method> parseList(String methodList) {
        if (methodList == null) {
            return ALL;
        }
        String[] methods = (methodList = methodList.toUpperCase(Locale.ROOT)).split(",");
        if (methods.length == 0) {
            return ALL;
        }
        if (methods.length == 1) {
            return Collections.singleton(Method.valueOf(methods[0]));
        }
        TreeSet<Method> result = new TreeSet<Method>();
        for (String method : methods) {
            result.add(Method.valueOf(method.trim()));
        }
        return ALL.equals(result) ? ALL : Collections.unmodifiableSet(result);
    }

    static {
        ALL = Collections.unmodifiableSet(new TreeSet<Method>(Arrays.asList(Method.values())));
    }
}

