/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.platform.http;

import org.apache.camel.AsyncEndpoint;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.platform.http.PlatformHttpComponent;
import org.apache.camel.component.platform.http.PlatformHttpConsumer;
import org.apache.camel.component.platform.http.PlatformHttpHeaderFilterStrategy;
import org.apache.camel.component.platform.http.spi.PlatformHttpEngine;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spi.HeaderFilterStrategyAware;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;

@UriEndpoint(firstVersion="3.0.0", scheme="platform-http", title="Platform HTTP", syntax="platform-http:path", category={Category.HTTP}, consumerOnly=true)
public class PlatformHttpEndpoint
extends DefaultEndpoint
implements AsyncEndpoint,
HeaderFilterStrategyAware {
    private static final String PROXY_PATH = "proxy";
    @UriPath(description="The path under which this endpoint serves the HTTP requests, for proxy use 'proxy'")
    @Metadata(required=true)
    private final String path;
    @UriParam(label="consumer", defaultValue="false", description="Whether or not the consumer should try to find a target consumer by matching the URI prefix if no exact match is found.")
    private boolean matchOnUriPrefix;
    @UriParam(label="consumer", description="A comma separated list of HTTP methods to serve, e.g. GET,POST . If no methods are specified, all methods will be served.")
    private String httpMethodRestrict;
    @UriParam(label="consumer", description="The content type this endpoint accepts as an input, such as application/xml or application/json. <code>null</code> or <code>&#42;/&#42;</code> mean no restriction.")
    private String consumes;
    @UriParam(label="consumer", description="The content type this endpoint produces, such as application/xml or application/json.")
    private String produces;
    @UriParam(label="consumer", defaultValue="true", description="If enabled and an Exchange failed processing on the consumer side the response's body won't contain the exception's stack trace.")
    private boolean muteException = true;
    @UriParam(label="consumer,advanced", description="A comma or whitespace separated list of file extensions. Uploads having these extensions will be stored locally. Null value or asterisk (*) will allow all files.")
    private String fileNameExtWhitelist;
    @UriParam(label="advanced", description="An HTTP Server engine implementation to serve the requests of this endpoint.")
    private PlatformHttpEngine platformHttpEngine;
    @UriParam(label="advanced", description="To use a custom HeaderFilterStrategy to filter headers to and from Camel message.")
    private HeaderFilterStrategy headerFilterStrategy = new PlatformHttpHeaderFilterStrategy();
    @UriParam(label="consumer", description="Whether to use streaming for large requests and responses (currently only supported by camel-platform-http-vertx)")
    private boolean useStreaming;
    @UriParam(label="advanced,consumer", defaultValue="false", description="When Camel is complete processing the message, and the HTTP server is writing response. This option controls whether Camel should catch any failure during writing response and store this on the Exchange, which allows onCompletion/UnitOfWork to regard the Exchange as failed and have access to the caused exception from the HTTP server.")
    private boolean handleWriteResponseError;

    public PlatformHttpEndpoint(String uri, String remaining, Component component) {
        super(uri, component);
        this.path = remaining;
    }

    public PlatformHttpComponent getComponent() {
        return (PlatformHttpComponent)super.getComponent();
    }

    public Producer createProducer() throws Exception {
        throw new UnsupportedOperationException("Producer is not supported");
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        PlatformHttpConsumer consumer = new PlatformHttpConsumer((Endpoint)this, processor);
        this.configureConsumer((Consumer)consumer);
        return consumer;
    }

    protected Consumer createDelegateConsumer(Processor processor) throws Exception {
        Consumer consumer = this.getOrCreateEngine().createConsumer(this, processor);
        this.configureConsumer(consumer);
        return consumer;
    }

    public HeaderFilterStrategy getHeaderFilterStrategy() {
        return this.headerFilterStrategy;
    }

    public void setHeaderFilterStrategy(HeaderFilterStrategy headerFilterStrategy) {
        this.headerFilterStrategy = headerFilterStrategy;
    }

    public String getPath() {
        return this.isHttpProxy() ? "/" : this.path;
    }

    public PlatformHttpEngine getPlatformHttpEngine() {
        return this.platformHttpEngine;
    }

    public void setPlatformHttpEngine(PlatformHttpEngine platformHttpEngine) {
        this.platformHttpEngine = platformHttpEngine;
    }

    public boolean isMatchOnUriPrefix() {
        return this.matchOnUriPrefix;
    }

    public void setMatchOnUriPrefix(boolean matchOnUriPrefix) {
        this.matchOnUriPrefix = matchOnUriPrefix;
    }

    public String getHttpMethodRestrict() {
        return this.httpMethodRestrict;
    }

    public void setHttpMethodRestrict(String httpMethodRestrict) {
        this.httpMethodRestrict = httpMethodRestrict;
    }

    public String getFileNameExtWhitelist() {
        return this.fileNameExtWhitelist;
    }

    public void setFileNameExtWhitelist(String fileNameExtWhitelist) {
        this.fileNameExtWhitelist = fileNameExtWhitelist;
    }

    public String getConsumes() {
        return this.consumes;
    }

    public void setConsumes(String consumes) {
        this.consumes = consumes;
    }

    public String getProduces() {
        return this.produces;
    }

    public void setProduces(String produces) {
        this.produces = produces;
    }

    public boolean isMuteException() {
        return this.muteException;
    }

    public void setMuteException(boolean muteException) {
        this.muteException = muteException;
    }

    public boolean isUseStreaming() {
        return this.useStreaming;
    }

    public void setUseStreaming(boolean useStreaming) {
        this.useStreaming = useStreaming;
    }

    public boolean isHandleWriteResponseError() {
        return this.handleWriteResponseError;
    }

    public void setHandleWriteResponseError(boolean handleWriteResponseError) {
        this.handleWriteResponseError = handleWriteResponseError;
    }

    PlatformHttpEngine getOrCreateEngine() {
        return this.platformHttpEngine != null ? this.platformHttpEngine : this.getComponent().getOrCreateEngine();
    }

    public boolean isHttpProxy() {
        return this.path.startsWith(PROXY_PATH);
    }
}

