/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.properties;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.properties.AugmentedPropertyNameAwarePropertiesParser;
import org.apache.camel.component.properties.DefaultPropertiesParser;
import org.apache.camel.component.properties.DefaultPropertiesResolver;
import org.apache.camel.component.properties.EnvPropertiesFunction;
import org.apache.camel.component.properties.PropertiesEndpoint;
import org.apache.camel.component.properties.PropertiesFunction;
import org.apache.camel.component.properties.PropertiesLocation;
import org.apache.camel.component.properties.PropertiesParser;
import org.apache.camel.component.properties.PropertiesResolver;
import org.apache.camel.component.properties.ServiceHostPropertiesFunction;
import org.apache.camel.component.properties.ServicePortPropertiesFunction;
import org.apache.camel.component.properties.ServicePropertiesFunction;
import org.apache.camel.component.properties.SysPropertiesFunction;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.support.LRUCacheFactory;
import org.apache.camel.util.FilePathResolver;
import org.apache.camel.util.ObjectHelper;

@org.apache.camel.spi.annotations.Component(value="properties")
public class PropertiesComponent
extends DefaultComponent
implements org.apache.camel.spi.PropertiesComponent {
    public static final int SYSTEM_PROPERTIES_MODE_NEVER = 0;
    public static final int SYSTEM_PROPERTIES_MODE_FALLBACK = 1;
    public static final int SYSTEM_PROPERTIES_MODE_OVERRIDE = 2;
    public static final int ENVIRONMENT_VARIABLES_MODE_NEVER = 0;
    public static final int ENVIRONMENT_VARIABLES_MODE_FALLBACK = 1;
    public static final int ENVIRONMENT_VARIABLES_MODE_OVERRIDE = 2;
    public static final String OVERRIDE_PROPERTIES = PropertiesComponent.class.getName() + ".OverrideProperties";
    private final Map<CacheKey, Properties> cacheMap = LRUCacheFactory.newLRUSoftCache((int)1000);
    private final Map<String, PropertiesFunction> functions = new LinkedHashMap<String, PropertiesFunction>();
    private PropertiesResolver propertiesResolver = new DefaultPropertiesResolver(this);
    private PropertiesParser propertiesParser = new DefaultPropertiesParser(this);
    private List<PropertiesLocation> locations = Collections.emptyList();
    private transient String propertyPrefixResolved;
    @Metadata
    private boolean ignoreMissingLocation;
    @Metadata
    private String encoding;
    @Metadata(defaultValue="true")
    private boolean cache = true;
    @Metadata(label="advanced")
    private String propertyPrefix;
    @Metadata(label="advanced")
    private String propertySuffix;
    private transient String propertySuffixResolved;
    @Metadata(label="advanced", defaultValue="true")
    private boolean fallbackToUnaugmentedProperty = true;
    @Metadata(defaultValue="true")
    private boolean defaultFallbackEnabled = true;
    @Metadata(label="advanced", defaultValue="{{")
    private String prefixToken = "{{";
    @Metadata(label="advanced", defaultValue="}}")
    private String suffixToken = "}}";
    @Metadata(label="advanced")
    private Properties initialProperties;
    @Metadata(label="advanced")
    private Properties overrideProperties;
    @Metadata(defaultValue="2", enums="0,1,2")
    private int systemPropertiesMode = 2;
    @Metadata(defaultValue="1", enums="0,1,2")
    private int environmentVariableMode = 1;

    public PropertiesComponent() {
        this.addFunction(new EnvPropertiesFunction());
        this.addFunction(new SysPropertiesFunction());
        this.addFunction(new ServicePropertiesFunction());
        this.addFunction(new ServiceHostPropertiesFunction());
        this.addFunction(new ServicePortPropertiesFunction());
    }

    public PropertiesComponent(String location) {
        this();
        this.setLocation(location);
    }

    public PropertiesComponent(String ... locations) {
        this();
        this.setLocations(locations);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        String locations;
        List<PropertiesLocation> paths = this.locations;
        Boolean ignoreMissingLocationLoc = (Boolean)this.getAndRemoveParameter(parameters, "ignoreMissingLocation", Boolean.class);
        if (ignoreMissingLocationLoc != null) {
            this.ignoreMissingLocation = ignoreMissingLocationLoc;
        }
        if ((locations = (String)this.getAndRemoveParameter(parameters, "locations", String.class)) != null) {
            this.log.trace("Overriding default locations with location: {}", (Object)locations);
            paths = Arrays.stream(locations.split(",")).map(PropertiesLocation::new).collect(Collectors.toList());
        }
        String endpointUri = this.parseUri(remaining, paths);
        this.log.debug("Endpoint uri parsed as: {}", (Object)endpointUri);
        Endpoint delegate = this.getCamelContext().getEndpoint(endpointUri);
        PropertiesEndpoint answer = new PropertiesEndpoint(uri, delegate, (Component)this);
        this.setProperties((Object)answer, parameters);
        return answer;
    }

    public String parseUri(String uri) throws Exception {
        return this.parseUri(uri, this.locations);
    }

    public String parseUri(String uri, String ... locations) throws Exception {
        return this.parseUri(uri, locations != null ? Arrays.stream(locations).map(PropertiesLocation::new).collect(Collectors.toList()) : Collections.emptyList());
    }

    public Properties loadProperties() throws Exception {
        return this.doLoadProperties(this.locations);
    }

    public Properties loadProperties(String ... locations) throws Exception {
        if (locations != null) {
            return this.doLoadProperties(Arrays.stream(locations).map(PropertiesLocation::new).collect(Collectors.toList()));
        }
        return new Properties();
    }

    protected Properties doLoadProperties(List<PropertiesLocation> paths) throws Exception {
        Properties prop = new Properties();
        if (this.initialProperties != null) {
            prop.putAll((Map<?, ?>)this.initialProperties);
        }
        if (paths != null) {
            Properties locationsProp;
            List<PropertiesLocation> locations = this.parseLocations(paths);
            CacheKey key = new CacheKey(locations);
            Properties properties = locationsProp = this.cache ? this.cacheMap.get(key) : null;
            if (locationsProp == null) {
                locationsProp = this.propertiesResolver.resolveProperties(this.getCamelContext(), this.ignoreMissingLocation, locations);
                if (this.cache) {
                    this.cacheMap.put(key, locationsProp);
                }
            }
            prop.putAll((Map<?, ?>)locationsProp);
        }
        if (this.overrideProperties != null) {
            Properties override = new Properties();
            override.putAll((Map<?, ?>)prop);
            override.putAll((Map<?, ?>)this.overrideProperties);
            prop = override;
        }
        return prop;
    }

    protected String parseUri(String uri, List<PropertiesLocation> paths) throws Exception {
        Properties prop = this.doLoadProperties(paths);
        if (!uri.contains(this.prefixToken) && !uri.startsWith(this.prefixToken)) {
            uri = this.prefixToken + uri;
        }
        if (!uri.contains(this.suffixToken) && !uri.endsWith(this.suffixToken)) {
            uri = uri + this.suffixToken;
        }
        this.log.trace("Parsing uri {} with properties: {}", (Object)uri, (Object)prop);
        if (this.propertiesParser instanceof AugmentedPropertyNameAwarePropertiesParser) {
            return ((AugmentedPropertyNameAwarePropertiesParser)this.propertiesParser).parseUri(uri, prop, this.prefixToken, this.suffixToken, this.propertyPrefixResolved, this.propertySuffixResolved, this.fallbackToUnaugmentedProperty, this.defaultFallbackEnabled);
        }
        return this.propertiesParser.parseUri(uri, prop, this.prefixToken, this.suffixToken);
    }

    public List<PropertiesLocation> getLocations() {
        return this.locations;
    }

    public void setLocations(List<PropertiesLocation> locations) {
        this.locations = Collections.unmodifiableList(locations);
    }

    public void setLocations(String[] locationStrings) {
        ArrayList<PropertiesLocation> locations = new ArrayList<PropertiesLocation>();
        if (locationStrings != null) {
            for (String locationString : locationStrings) {
                locations.add(new PropertiesLocation(locationString));
            }
        }
        this.setLocations((List<PropertiesLocation>)locations);
    }

    public void setLocations(Collection<String> locationStrings) {
        ArrayList<PropertiesLocation> locations = new ArrayList<PropertiesLocation>();
        if (locationStrings != null) {
            for (String locationString : locationStrings) {
                locations.add(new PropertiesLocation(locationString));
            }
        }
        this.setLocations((List<PropertiesLocation>)locations);
    }

    public void addLocation(String location) {
        if (location != null) {
            ArrayList<PropertiesLocation> newLocations = new ArrayList<PropertiesLocation>();
            for (String loc : location.split(",")) {
                newLocations.add(new PropertiesLocation(loc));
            }
            List<PropertiesLocation> current = this.getLocations();
            if (!current.isEmpty()) {
                newLocations.addAll(0, current);
            }
            this.setLocations((List<PropertiesLocation>)newLocations);
        }
    }

    public void setLocation(String location) {
        if (location != null) {
            this.setLocations(location.split(","));
        }
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public PropertiesResolver getPropertiesResolver() {
        return this.propertiesResolver;
    }

    public void setPropertiesResolver(PropertiesResolver propertiesResolver) {
        this.propertiesResolver = propertiesResolver;
    }

    public PropertiesParser getPropertiesParser() {
        return this.propertiesParser;
    }

    public void setPropertiesParser(PropertiesParser propertiesParser) {
        this.propertiesParser = propertiesParser;
    }

    public boolean isCache() {
        return this.cache;
    }

    public void setCache(boolean cache) {
        this.cache = cache;
    }

    public String getPropertyPrefix() {
        return this.propertyPrefix;
    }

    public void setPropertyPrefix(String propertyPrefix) {
        this.propertyPrefix = propertyPrefix;
        this.propertyPrefixResolved = propertyPrefix;
        if (ObjectHelper.isNotEmpty((Object)this.propertyPrefix)) {
            this.propertyPrefixResolved = FilePathResolver.resolvePath((String)this.propertyPrefix);
        }
    }

    public String getPropertySuffix() {
        return this.propertySuffix;
    }

    public void setPropertySuffix(String propertySuffix) {
        this.propertySuffix = propertySuffix;
        this.propertySuffixResolved = propertySuffix;
        if (ObjectHelper.isNotEmpty((Object)this.propertySuffix)) {
            this.propertySuffixResolved = FilePathResolver.resolvePath((String)this.propertySuffix);
        }
    }

    public boolean isFallbackToUnaugmentedProperty() {
        return this.fallbackToUnaugmentedProperty;
    }

    public void setFallbackToUnaugmentedProperty(boolean fallbackToUnaugmentedProperty) {
        this.fallbackToUnaugmentedProperty = fallbackToUnaugmentedProperty;
    }

    public boolean isDefaultFallbackEnabled() {
        return this.defaultFallbackEnabled;
    }

    public void setDefaultFallbackEnabled(boolean defaultFallbackEnabled) {
        this.defaultFallbackEnabled = defaultFallbackEnabled;
    }

    public boolean isIgnoreMissingLocation() {
        return this.ignoreMissingLocation;
    }

    public void setIgnoreMissingLocation(boolean ignoreMissingLocation) {
        this.ignoreMissingLocation = ignoreMissingLocation;
    }

    public String getPrefixToken() {
        return this.prefixToken;
    }

    public void setPrefixToken(String prefixToken) {
        this.prefixToken = prefixToken == null ? "{{" : prefixToken;
    }

    public String getSuffixToken() {
        return this.suffixToken;
    }

    public void setSuffixToken(String suffixToken) {
        this.suffixToken = suffixToken == null ? "}}" : suffixToken;
    }

    public Properties getInitialProperties() {
        return this.initialProperties;
    }

    public void setInitialProperties(Properties initialProperties) {
        this.initialProperties = initialProperties;
    }

    public Properties getOverrideProperties() {
        return this.overrideProperties;
    }

    public void setOverrideProperties(Properties overrideProperties) {
        this.overrideProperties = overrideProperties;
    }

    public Map<String, PropertiesFunction> getFunctions() {
        return this.functions;
    }

    public void addFunction(PropertiesFunction function) {
        this.functions.put(function.getName(), function);
    }

    public boolean hasFunction(String name) {
        return this.functions.containsKey(name);
    }

    public int getSystemPropertiesMode() {
        return this.systemPropertiesMode;
    }

    public void setSystemPropertiesMode(int systemPropertiesMode) {
        this.systemPropertiesMode = systemPropertiesMode;
    }

    public int getEnvironmentVariableMode() {
        return this.environmentVariableMode;
    }

    public void setEnvironmentVariableMode(int environmentVariableMode) {
        this.environmentVariableMode = environmentVariableMode;
    }

    public boolean isResolvePropertyPlaceholders() {
        return false;
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.systemPropertiesMode != 0 && this.systemPropertiesMode != 1 && this.systemPropertiesMode != 2) {
            throw new IllegalArgumentException("Option systemPropertiesMode has invalid value: " + this.systemPropertiesMode);
        }
        if (this.environmentVariableMode != 0 && this.environmentVariableMode != 1 && this.environmentVariableMode != 2) {
            throw new IllegalArgumentException("Option environmentVariableMode has invalid value: " + this.environmentVariableMode);
        }
        if (this.propertiesParser instanceof DefaultPropertiesParser) {
            ((DefaultPropertiesParser)this.propertiesParser).setPropertiesComponent(this);
        }
    }

    protected void doStop() throws Exception {
        this.cacheMap.clear();
        super.doStop();
    }

    private List<PropertiesLocation> parseLocations(List<PropertiesLocation> locations) {
        ArrayList<PropertiesLocation> answer = new ArrayList<PropertiesLocation>();
        for (PropertiesLocation location : locations) {
            this.log.trace("Parsing location: {}", (Object)location);
            try {
                String path = FilePathResolver.resolvePath((String)location.getPath());
                this.log.debug("Parsed location: {}", (Object)path);
                if (!ObjectHelper.isNotEmpty((Object)path)) continue;
                answer.add(new PropertiesLocation(location.getResolver(), path, location.isOptional()));
            }
            catch (IllegalArgumentException e) {
                if (!this.ignoreMissingLocation && !location.isOptional()) {
                    throw e;
                }
                this.log.debug("Ignored missing location: {}", (Object)location);
            }
        }
        return answer;
    }

    private static final class CacheKey
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final List<PropertiesLocation> locations;

        private CacheKey(List<PropertiesLocation> locations) {
            this.locations = new ArrayList<PropertiesLocation>(locations);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey that = (CacheKey)o;
            return this.locations.equals(that.locations);
        }

        public int hashCode() {
            return this.locations.hashCode();
        }

        public String toString() {
            return "LocationKey[" + this.locations.toString() + "]";
        }
    }
}

