/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.properties;

import java.util.Iterator;
import org.apache.camel.component.properties.PropertiesComponent;
import org.apache.camel.component.properties.PropertiesLookup;
import org.apache.camel.spi.PropertiesSource;

public class DefaultPropertiesLookup
implements PropertiesLookup {
    private final PropertiesComponent component;

    public DefaultPropertiesLookup(PropertiesComponent component) {
        this.component = component;
    }

    @Override
    public String lookup(String name) {
        String answer = null;
        if (this.component.getOverrideProperties() != null) {
            answer = this.component.getOverrideProperties().getProperty(name);
        }
        if (answer == null) {
            Iterator<PropertiesSource> it2 = this.component.getSources().iterator();
            while (answer == null && it2.hasNext()) {
                answer = it2.next().getProperty(name);
            }
        }
        if (answer == null && this.component.getInitialProperties() != null) {
            answer = this.component.getInitialProperties().getProperty(name);
        }
        return answer;
    }
}

