/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.properties;

import java.util.HashSet;
import java.util.Set;
import org.apache.camel.component.properties.PropertiesComponent;
import org.apache.camel.component.properties.PropertiesFunction;
import org.apache.camel.component.properties.PropertiesLookup;
import org.apache.camel.component.properties.PropertiesParser;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPropertiesParser
implements PropertiesParser {
    private static final String GET_OR_ELSE_TOKEN = ":";
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private PropertiesComponent propertiesComponent;

    public DefaultPropertiesParser() {
    }

    public DefaultPropertiesParser(PropertiesComponent propertiesComponent) {
        this.propertiesComponent = propertiesComponent;
    }

    public PropertiesComponent getPropertiesComponent() {
        return this.propertiesComponent;
    }

    public void setPropertiesComponent(PropertiesComponent propertiesComponent) {
        this.propertiesComponent = propertiesComponent;
    }

    @Override
    public String parseUri(String text, PropertiesLookup properties, String prefixToken, String suffixToken, boolean defaultFallbackEnabled) throws IllegalArgumentException {
        ParsingContext context = new ParsingContext(properties, prefixToken, suffixToken, defaultFallbackEnabled);
        return context.parse(text);
    }

    @Override
    public String parseProperty(String key, String value, PropertiesLookup properties) {
        return value;
    }

    private static final class Property {
        private final int beginIndex;
        private final int endIndex;
        private final String key;
        private final String value;

        private Property(int beginIndex, int endIndex, String key, String value) {
            this.beginIndex = beginIndex;
            this.endIndex = endIndex;
            this.key = key;
            this.value = value;
        }

        public int getBeginIndex() {
            return this.beginIndex;
        }

        public int getEndIndex() {
            return this.endIndex;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }
    }

    private final class ParsingContext {
        private final PropertiesLookup properties;
        private final String prefixToken;
        private final String suffixToken;
        private final boolean defaultFallbackEnabled;

        ParsingContext(PropertiesLookup properties, String prefixToken, String suffixToken, boolean defaultFallbackEnabled) {
            this.properties = properties;
            this.prefixToken = prefixToken;
            this.suffixToken = suffixToken;
            this.defaultFallbackEnabled = defaultFallbackEnabled;
        }

        public String parse(String input) {
            return this.doParse(input, new HashSet<String>());
        }

        private String doParse(String input, Set<String> replacedPropertyKeys) {
            Property property;
            if (input == null) {
                return null;
            }
            String answer = input;
            while ((property = this.readProperty(answer)) != null) {
                if (replacedPropertyKeys.contains(property.getKey())) {
                    throw new IllegalArgumentException("Circular reference detected with key [" + property.getKey() + "] from text: " + input);
                }
                HashSet<String> newReplaced = new HashSet<String>(replacedPropertyKeys);
                newReplaced.add(property.getKey());
                String before = answer.substring(0, property.getBeginIndex());
                String after = answer.substring(property.getEndIndex());
                answer = before + this.doParse(property.getValue(), newReplaced) + after;
            }
            return answer;
        }

        private Property readProperty(String input) {
            int suffix = this.getSuffixIndex(input);
            if (suffix == -1) {
                if (this.getMatchingPrefixIndex(input, input.length()) != -1) {
                    throw new IllegalArgumentException(String.format("Missing %s from the text: %s", this.suffixToken, input));
                }
                return null;
            }
            int prefix = this.getMatchingPrefixIndex(input, suffix);
            if (prefix == -1) {
                throw new IllegalArgumentException(String.format("Missing %s from the text: %s", this.prefixToken, input));
            }
            String key = input.substring(prefix + this.prefixToken.length(), suffix);
            String value = this.getPropertyValue(key, input);
            return new Property(prefix, suffix + this.suffixToken.length(), key, value);
        }

        private int getSuffixIndex(String input) {
            int index = -1;
            while ((index = input.indexOf(this.suffixToken, index + 1)) != -1 && this.isQuoted(input, index, this.suffixToken)) {
            }
            return index;
        }

        private int getMatchingPrefixIndex(String input, int suffixIndex) {
            int index = suffixIndex;
            while ((index = input.lastIndexOf(this.prefixToken, index - 1)) != -1 && this.isQuoted(input, index, this.prefixToken)) {
            }
            return index;
        }

        private boolean isQuoted(String input, int index, String token) {
            int beforeIndex = index - 1;
            int afterIndex = index + token.length();
            if (beforeIndex >= 0 && afterIndex < input.length()) {
                char after;
                char before = input.charAt(beforeIndex);
                return before == (after = input.charAt(afterIndex)) && (before == '\'' || before == '\"');
            }
            return false;
        }

        private String getPropertyValue(String key, String input) {
            String value;
            if (DefaultPropertiesParser.this.propertiesComponent != null) {
                for (PropertiesFunction function : DefaultPropertiesParser.this.propertiesComponent.getFunctions().values()) {
                    String token = function.getName() + DefaultPropertiesParser.GET_OR_ELSE_TOKEN;
                    if (!key.startsWith(token)) continue;
                    String remainder = key.substring(token.length());
                    DefaultPropertiesParser.this.log.debug("Property with key [{}] is applied by function [{}]", (Object)key, (Object)function.getName());
                    String value2 = function.apply(remainder);
                    if (value2 == null) {
                        throw new IllegalArgumentException("Property with key [" + key + "] using function [" + function.getName() + "] returned null value which is not allowed, from input: " + input);
                    }
                    if (DefaultPropertiesParser.this.log.isDebugEnabled()) {
                        DefaultPropertiesParser.this.log.debug("Property with key [{}] applied by function [{}] -> {}", new Object[]{key, function.getName(), value2});
                    }
                    return value2;
                }
            }
            String defaultValue = null;
            if (this.defaultFallbackEnabled && key.contains(DefaultPropertiesParser.GET_OR_ELSE_TOKEN)) {
                defaultValue = StringHelper.after((String)key, (String)DefaultPropertiesParser.GET_OR_ELSE_TOKEN);
                key = StringHelper.before((String)key, (String)DefaultPropertiesParser.GET_OR_ELSE_TOKEN);
            }
            if ((value = this.doGetPropertyValue(key)) == null && defaultValue != null) {
                DefaultPropertiesParser.this.log.debug("Property with key [{}] not found, using default value: {}", (Object)key, (Object)defaultValue);
                value = defaultValue;
            }
            if (value == null) {
                StringBuilder esb = new StringBuilder();
                if (DefaultPropertiesParser.this.propertiesComponent == null || "true".equals(DefaultPropertiesParser.this.propertiesComponent.getCamelContext().getGlobalOption("PropertiesComponentDefaultCreated"))) {
                    esb.append("PropertiesComponent with name properties must be defined in CamelContext to support property placeholders. ");
                }
                esb.append("Property with key [").append(key).append("] ");
                esb.append("not found in properties from text: ").append(input);
                throw new IllegalArgumentException(esb.toString());
            }
            return value;
        }

        private String doGetPropertyValue(String key) {
            int envMode;
            if (ObjectHelper.isEmpty((Object)key)) {
                return DefaultPropertiesParser.this.parseProperty(key, null, this.properties);
            }
            String value = null;
            int sysMode = DefaultPropertiesParser.this.propertiesComponent != null ? DefaultPropertiesParser.this.propertiesComponent.getSystemPropertiesMode() : 2;
            int n = envMode = DefaultPropertiesParser.this.propertiesComponent != null ? DefaultPropertiesParser.this.propertiesComponent.getEnvironmentVariableMode() : 1;
            if (sysMode == 2 && (value = System.getProperty(key)) != null) {
                DefaultPropertiesParser.this.log.debug("Found a JVM system property: {} with value: {} to be used.", (Object)key, (Object)value);
            }
            if (value == null && envMode == 2 && (value = IOHelper.lookupEnvironmentVariable((String)key)) != null) {
                DefaultPropertiesParser.this.log.debug("Found a environment property: {} with value: {} to be used.", (Object)key, (Object)value);
            }
            if (value == null && this.properties != null && (value = this.properties.lookup(key)) != null) {
                DefaultPropertiesParser.this.log.debug("Found property: {} with value: {} to be used.", (Object)key, (Object)value);
            }
            if (value == null && sysMode == 1 && (value = System.getProperty(key)) != null) {
                DefaultPropertiesParser.this.log.debug("Found a JVM system property: {} with value: {} to be used.", (Object)key, (Object)value);
            }
            if (value == null && envMode == 1 && (value = IOHelper.lookupEnvironmentVariable((String)key)) != null) {
                DefaultPropertiesParser.this.log.debug("Found a environment property: {} with value: {} to be used.", (Object)key, (Object)value);
            }
            return DefaultPropertiesParser.this.parseProperty(key, value, this.properties);
        }
    }
}

