/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.protobuf;

import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.camel.util.ObjectHelper;

public final class ProtobufConverter {
    private ProtobufConverter() {
    }

    public static Message toProto(Map<?, ?> inputData, Message defaultInstance) {
        ObjectHelper.notNull(inputData, (String)"inputData");
        ObjectHelper.notNull((Object)defaultInstance, (String)"defaultInstance");
        Descriptors.Descriptor descriptor = defaultInstance.getDescriptorForType();
        Message.Builder target = defaultInstance.newBuilderForType();
        return ProtobufConverter.convertMapToMessage(descriptor, target, inputData);
    }

    private static Message convertMapToMessage(Descriptors.Descriptor descriptor, Message.Builder builder, Map<?, ?> inputData) {
        ObjectHelper.notNull((Object)descriptor, (String)"descriptor");
        ObjectHelper.notNull((Object)builder, (String)"builder");
        ObjectHelper.notNull(inputData, (String)"inputData");
        inputData.forEach((key, value) -> {
            Descriptors.FieldDescriptor fieldDescriptor = descriptor.findFieldByName(key.toString());
            if (fieldDescriptor != null) {
                if (fieldDescriptor.isRepeated()) {
                    List repeatedValues = ProtobufConverter.castValue(value, List.class, String.format("Not able to cast value to list, make sure you have a list for the repeated field '%s'", fieldDescriptor.getName()));
                    repeatedValues.forEach(repeatedValue -> builder.addRepeatedField(fieldDescriptor, ProtobufConverter.getSuitableFieldValue(fieldDescriptor, builder, repeatedValue)));
                } else {
                    builder.setField(fieldDescriptor, ProtobufConverter.getSuitableFieldValue(fieldDescriptor, builder, value));
                }
            }
        });
        return builder.build();
    }

    private static Object getSuitableFieldValue(Descriptors.FieldDescriptor fieldDescriptor, Message.Builder builder, Object inputValue) {
        ObjectHelper.notNull((Object)fieldDescriptor, (String)"fieldDescriptor");
        ObjectHelper.notNull((Object)builder, (String)"builder");
        ObjectHelper.notNull((Object)inputValue, (String)"inputValue");
        switch (fieldDescriptor.getJavaType()) {
            case ENUM: {
                return ProtobufConverter.getEnumValue(fieldDescriptor, inputValue);
            }
            case MESSAGE: {
                Map nestedValue = ProtobufConverter.castValue(inputValue, Map.class, String.format("Not able to cast value to map, make sure you have a map for the nested field message '%s'", fieldDescriptor.getName()));
                return ProtobufConverter.convertMapToMessage(fieldDescriptor.getMessageType(), builder.newBuilderForField(fieldDescriptor), nestedValue);
            }
        }
        return inputValue;
    }

    private static Descriptors.EnumValueDescriptor getEnumValue(Descriptors.FieldDescriptor fieldDescriptor, Object value) {
        Descriptors.EnumValueDescriptor enumValueDescriptor = ProtobufConverter.getSuitableEnumValue(fieldDescriptor, value);
        if (enumValueDescriptor == null) {
            throw new IllegalArgumentException(String.format("Could not retrieve enum index '%s' for enum field '%s', most likely the index does not exist in the enum indexes '%s'", value, fieldDescriptor.getName(), fieldDescriptor.getEnumType().getValues()));
        }
        return enumValueDescriptor;
    }

    private static Descriptors.EnumValueDescriptor getSuitableEnumValue(Descriptors.FieldDescriptor fieldDescriptor, Object value) {
        if (value instanceof String) {
            return fieldDescriptor.getEnumType().findValueByName((String)value);
        }
        int index = ProtobufConverter.castValue(value, Integer.class, String.format("Not able to cast value to integer, make sure you have an integer index for the enum field '%s'", fieldDescriptor.getName()));
        return fieldDescriptor.getEnumType().findValueByNumber(index);
    }

    public static Map<String, Object> toMap(Message inputProto) {
        return ProtobufConverter.convertProtoMessageToMap(inputProto);
    }

    private static Map<String, Object> convertProtoMessageToMap(Message inputData) {
        ObjectHelper.notNull((Object)inputData, (String)"inputData");
        Map allFields = inputData.getAllFields();
        LinkedHashMap<String, Object> mapResult = new LinkedHashMap<String, Object>();
        allFields.forEach((fieldDescriptor, value) -> {
            String fieldName = fieldDescriptor.getName();
            if (fieldDescriptor.isRepeated()) {
                List repeatedValues = ProtobufConverter.castValue(value, List.class, String.format("Not able to cast value to list, make sure you have a list for the repeated field '%s'", fieldName));
                mapResult.put(fieldName, repeatedValues.stream().map(singleValue -> ProtobufConverter.convertValueToSuitableFieldType(singleValue, fieldDescriptor)).collect(Collectors.toList()));
            } else {
                mapResult.put(fieldName, ProtobufConverter.convertValueToSuitableFieldType(value, fieldDescriptor));
            }
        });
        return mapResult;
    }

    private static Object convertValueToSuitableFieldType(Object value, Descriptors.FieldDescriptor fieldDescriptor) {
        ObjectHelper.notNull((Object)fieldDescriptor, (String)"fieldDescriptor");
        ObjectHelper.notNull((Object)value, (String)"value");
        return switch (fieldDescriptor.getJavaType()) {
            case Descriptors.FieldDescriptor.JavaType.ENUM, Descriptors.FieldDescriptor.JavaType.BYTE_STRING -> value.toString();
            case Descriptors.FieldDescriptor.JavaType.MESSAGE -> ProtobufConverter.convertProtoMessageToMap((Message)value);
            default -> value;
        };
    }

    private static <T> T castValue(Object value, Class<T> type, String errorMessage) {
        try {
            return type.cast(value);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(errorMessage, e);
        }
    }
}

