/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.pubnub;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class PubNubEndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":channel";
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;

    public boolean isEnabled(String scheme) {
        return "pubnub".equals(scheme);
    }

    public String buildUri(String scheme, Map<String, Object> properties, boolean encode) throws URISyntaxException {
        String syntax;
        String uri = syntax = scheme + BASE;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, uri, "channel", null, true, copy);
        uri = this.buildQueryParameters(uri, copy, encode);
        return uri;
    }

    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    public boolean isLenientProperties() {
        return false;
    }

    static {
        HashSet<String> props = new HashSet<String>(15);
        props.add("authKey");
        props.add("pubnub");
        props.add("secretKey");
        props.add("channel");
        props.add("exchangePattern");
        props.add("secure");
        props.add("uuid");
        props.add("lazyStartProducer");
        props.add("bridgeErrorHandler");
        props.add("withPresence");
        props.add("cipherKey");
        props.add("subscribeKey");
        props.add("exceptionHandler");
        props.add("operation");
        props.add("publishKey");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        HashSet<String> secretProps = new HashSet<String>(5);
        secretProps.add("authKey");
        secretProps.add("secretKey");
        secretProps.add("cipherKey");
        secretProps.add("subscribeKey");
        secretProps.add("publishKey");
        SECRET_PROPERTY_NAMES = Collections.unmodifiableSet(secretProps);
    }
}

