/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.pubnub;

import com.pubnub.api.PNConfiguration;
import com.pubnub.api.PubNub;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.pubnub.PubNubComponent;
import org.apache.camel.component.pubnub.PubNubConfiguration;
import org.apache.camel.component.pubnub.PubNubConsumer;
import org.apache.camel.component.pubnub.PubNubProducer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.util.ObjectHelper;

@UriEndpoint(firstVersion="2.19.0", scheme="pubnub", title="PubNub", syntax="pubnub:channel", category={Category.CLOUD, Category.IOT, Category.MESSAGING})
public class PubNubEndpoint
extends DefaultEndpoint {
    @UriParam(label="advanced")
    @Metadata(autowired=true)
    private PubNub pubnub;
    @UriParam
    private PubNubConfiguration configuration;

    public PubNubEndpoint(String uri, PubNubComponent component, PubNubConfiguration configuration) {
        super(uri, (Component)component);
        this.configuration = configuration;
    }

    public Producer createProducer() throws Exception {
        return new PubNubProducer(this, this.configuration);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        return new PubNubConsumer(this, processor, this.configuration);
    }

    public PubNubConfiguration getConfiguration() {
        return this.configuration;
    }

    public PubNub getPubnub() {
        return this.pubnub;
    }

    public void setPubnub(PubNub pubnub) {
        this.pubnub = pubnub;
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this.pubnub != null) {
            this.pubnub.destroy();
            this.pubnub = null;
        }
    }

    protected void doStart() throws Exception {
        this.pubnub = this.getPubnub() != null ? this.getPubnub() : this.getInstance();
        super.doStart();
    }

    private PubNub getInstance() {
        PubNub answer = null;
        PNConfiguration pnConfiguration = new PNConfiguration();
        pnConfiguration.setPublishKey(this.configuration.getPublishKey());
        pnConfiguration.setSubscribeKey(this.configuration.getSubscribeKey());
        pnConfiguration.setSecretKey(this.configuration.getSecretKey());
        pnConfiguration.setAuthKey(this.configuration.getAuthKey());
        pnConfiguration.setCipherKey(this.configuration.getCipherKey());
        pnConfiguration.setSecure(this.configuration.isSecure());
        if (ObjectHelper.isNotEmpty((Object)this.configuration.getUuid())) {
            pnConfiguration.setUuid(this.configuration.getUuid());
        }
        answer = new PubNub(pnConfiguration);
        return answer;
    }
}

