/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.pulsar;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.pulsar.PulsarEndpoint;
import org.apache.camel.component.pulsar.configuration.PulsarConfiguration;
import org.apache.camel.component.pulsar.utils.AutoConfiguration;
import org.apache.camel.impl.DefaultComponent;
import org.apache.camel.spi.Metadata;
import org.apache.pulsar.client.api.PulsarClient;

public class PulsarComponent
extends DefaultComponent {
    @Metadata
    private AutoConfiguration autoConfiguration;
    @Metadata
    private PulsarClient pulsarClient;

    public PulsarComponent() {
        this(null);
    }

    public PulsarComponent(CamelContext context) {
        super(context);
    }

    protected Endpoint createEndpoint(String uri, String path, Map<String, Object> parameters) throws Exception {
        PulsarConfiguration configuration = new PulsarConfiguration();
        this.setProperties(configuration, parameters);
        if (this.autoConfiguration != null) {
            this.setProperties(this.autoConfiguration, parameters);
            if (this.autoConfiguration.isAutoConfigurable()) {
                this.autoConfiguration.ensureNameSpaceAndTenant(path);
            }
        }
        return PulsarEndpoint.create(uri, path, configuration, this, this.pulsarClient);
    }

    public AutoConfiguration getAutoConfiguration() {
        return this.autoConfiguration;
    }

    public void setAutoConfiguration(AutoConfiguration autoConfiguration) {
        this.autoConfiguration = autoConfiguration;
    }

    public PulsarClient getPulsarClient() {
        return this.pulsarClient;
    }

    public void setPulsarClient(PulsarClient pulsarClient) {
        this.pulsarClient = pulsarClient;
    }
}

