/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.pulsar;

import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.pulsar.PulsarEndpoint;
import org.apache.camel.component.pulsar.utils.message.PulsarMessageUtils;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.MessageListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PulsarMessageListener
implements MessageListener<byte[]> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PulsarMessageListener.class);
    private final PulsarEndpoint endpoint;
    private final ExceptionHandler exceptionHandler;
    private final Processor processor;

    public PulsarMessageListener(PulsarEndpoint endpoint, ExceptionHandler exceptionHandler, Processor processor) {
        this.endpoint = endpoint;
        this.exceptionHandler = exceptionHandler;
        this.processor = processor;
    }

    public void received(Consumer<byte[]> consumer, Message<byte[]> message) {
        Exchange exchange = PulsarMessageUtils.updateExchange(message, this.endpoint.createExchange());
        try {
            this.processor.process(exchange);
            consumer.acknowledge(message.getMessageId());
        }
        catch (Exception exception) {
            this.handleProcessorException(exchange, exception);
        }
    }

    private void handleProcessorException(Exchange exchange, Exception exception) {
        Exchange exchangeWithException = PulsarMessageUtils.updateExchangeWithException(exception, exchange);
        this.exceptionHandler.handleException("An error occurred", exchangeWithException, (Throwable)exception);
    }
}

