/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.pulsar.utils.consumers;

import org.apache.camel.component.pulsar.PulsarConsumer;
import org.apache.camel.component.pulsar.utils.consumers.ConsumerCreationStrategy;
import org.apache.camel.component.pulsar.utils.consumers.ExclusiveConsumerStrategy;
import org.apache.camel.component.pulsar.utils.consumers.FailoverConsumerStrategy;
import org.apache.camel.component.pulsar.utils.consumers.SharedConsumerStrategy;
import org.apache.camel.component.pulsar.utils.consumers.SubscriptionType;

public final class ConsumerCreationStrategyFactory {
    private final PulsarConsumer pulsarConsumer;

    private ConsumerCreationStrategyFactory(PulsarConsumer pulsarConsumer) {
        this.pulsarConsumer = pulsarConsumer;
    }

    public static ConsumerCreationStrategyFactory create(PulsarConsumer pulsarConsumer) {
        ConsumerCreationStrategyFactory.validate(pulsarConsumer);
        return new ConsumerCreationStrategyFactory(pulsarConsumer);
    }

    private static void validate(PulsarConsumer pulsarConsumer) {
        if (pulsarConsumer == null) {
            throw new IllegalArgumentException("Pulsar Consumer cannot be null");
        }
    }

    public ConsumerCreationStrategy getStrategy(SubscriptionType subscriptionType) {
        SubscriptionType type = subscriptionType == null ? SubscriptionType.EXCLUSIVE : subscriptionType;
        switch (type) {
            case SHARED: {
                return new SharedConsumerStrategy(this.pulsarConsumer);
            }
            case EXCLUSIVE: {
                return new ExclusiveConsumerStrategy(this.pulsarConsumer);
            }
            case FAILOVER: {
                return new FailoverConsumerStrategy(this.pulsarConsumer);
            }
        }
        return new ExclusiveConsumerStrategy(this.pulsarConsumer);
    }
}

