/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.pulsar;

import org.apache.camel.CamelContext;
import org.apache.camel.ExchangePattern;
import org.apache.camel.component.pulsar.PulsarEndpoint;
import org.apache.camel.component.pulsar.utils.consumers.SubscriptionType;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import org.apache.pulsar.client.api.CompressionType;

public class PulsarEndpointConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer {
    public boolean configure(CamelContext camelContext, Object endpoint, String name, Object value, boolean ignoreCase) {
        if (ignoreCase) {
            return PulsarEndpointConfigurer.doConfigureIgnoreCase(camelContext, endpoint, name, value);
        }
        return PulsarEndpointConfigurer.doConfigure(camelContext, endpoint, name, value);
    }

    private static boolean doConfigure(CamelContext camelContext, Object endpoint, String name, Object value) {
        switch (name) {
            case "subscriptionName": {
                ((PulsarEndpoint)((Object)endpoint)).getPulsarConfiguration().setSubscriptionName((String)PulsarEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "subscriptionType": {
                ((PulsarEndpoint)((Object)endpoint)).getPulsarConfiguration().setSubscriptionType((SubscriptionType)((Object)PulsarEndpointConfigurer.property((CamelContext)camelContext, SubscriptionType.class, (Object)value)));
                return true;
            }
            case "numberOfConsumers": {
                ((PulsarEndpoint)((Object)endpoint)).getPulsarConfiguration().setNumberOfConsumers((Integer)PulsarEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "consumerQueueSize": {
                ((PulsarEndpoint)((Object)endpoint)).getPulsarConfiguration().setConsumerQueueSize((Integer)PulsarEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "consumerName": {
                ((PulsarEndpoint)((Object)endpoint)).getPulsarConfiguration().setConsumerName((String)PulsarEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "producerName": {
                ((PulsarEndpoint)((Object)endpoint)).getPulsarConfiguration().setProducerName((String)PulsarEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "consumerNamePrefix": {
                ((PulsarEndpoint)((Object)endpoint)).getPulsarConfiguration().setConsumerNamePrefix((String)PulsarEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "allowManualAcknowledgement": {
                ((PulsarEndpoint)((Object)endpoint)).getPulsarConfiguration().setAllowManualAcknowledgement((Boolean)PulsarEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "ackTimeoutMillis": {
                ((PulsarEndpoint)((Object)endpoint)).getPulsarConfiguration().setAckTimeoutMillis((Long)PulsarEndpointConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "ackGroupTimeMillis": {
                ((PulsarEndpoint)((Object)endpoint)).getPulsarConfiguration().setAckGroupTimeMillis((Long)PulsarEndpointConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "sendTimeoutMs": {
                ((PulsarEndpoint)((Object)endpoint)).getPulsarConfiguration().setSendTimeoutMs((Integer)PulsarEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "blockIfQueueFull": {
                ((PulsarEndpoint)((Object)endpoint)).getPulsarConfiguration().setBlockIfQueueFull((Boolean)PulsarEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "maxPendingMessages": {
                ((PulsarEndpoint)((Object)endpoint)).getPulsarConfiguration().setMaxPendingMessages((Integer)PulsarEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "maxPendingMessagesAcrossPartitions": {
                ((PulsarEndpoint)((Object)endpoint)).getPulsarConfiguration().setMaxPendingMessagesAcrossPartitions((Integer)PulsarEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "batchingMaxPublishDelayMicros": {
                ((PulsarEndpoint)((Object)endpoint)).getPulsarConfiguration().setBatchingMaxPublishDelayMicros((Long)PulsarEndpointConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "batchingMaxMessages": {
                ((PulsarEndpoint)((Object)endpoint)).getPulsarConfiguration().setBatchingMaxMessages((Integer)PulsarEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "batchingEnabled": {
                ((PulsarEndpoint)((Object)endpoint)).getPulsarConfiguration().setBatchingEnabled((Boolean)PulsarEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "initialSequenceId": {
                ((PulsarEndpoint)((Object)endpoint)).getPulsarConfiguration().setInitialSequenceId((Long)PulsarEndpointConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "compressionType": {
                ((PulsarEndpoint)((Object)endpoint)).getPulsarConfiguration().setCompressionType((CompressionType)PulsarEndpointConfigurer.property((CamelContext)camelContext, CompressionType.class, (Object)value));
                return true;
            }
            case "lazyStartProducer": {
                ((PulsarEndpoint)((Object)endpoint)).setLazyStartProducer((Boolean)PulsarEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "bridgeErrorHandler": {
                ((PulsarEndpoint)((Object)endpoint)).setBridgeErrorHandler((Boolean)PulsarEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "exceptionHandler": {
                ((PulsarEndpoint)((Object)endpoint)).setExceptionHandler((ExceptionHandler)PulsarEndpointConfigurer.property((CamelContext)camelContext, ExceptionHandler.class, (Object)value));
                return true;
            }
            case "exchangePattern": {
                ((PulsarEndpoint)((Object)endpoint)).setExchangePattern((ExchangePattern)PulsarEndpointConfigurer.property((CamelContext)camelContext, ExchangePattern.class, (Object)value));
                return true;
            }
            case "synchronous": {
                ((PulsarEndpoint)((Object)endpoint)).setSynchronous((Boolean)PulsarEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "basicPropertyBinding": {
                ((PulsarEndpoint)((Object)endpoint)).setBasicPropertyBinding((Boolean)PulsarEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
        }
        return false;
    }

    private static boolean doConfigureIgnoreCase(CamelContext camelContext, Object endpoint, String name, Object value) {
        switch (name.toLowerCase()) {
            case "subscriptionname": {
                ((PulsarEndpoint)((Object)endpoint)).getPulsarConfiguration().setSubscriptionName((String)PulsarEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "subscriptiontype": {
                ((PulsarEndpoint)((Object)endpoint)).getPulsarConfiguration().setSubscriptionType((SubscriptionType)((Object)PulsarEndpointConfigurer.property((CamelContext)camelContext, SubscriptionType.class, (Object)value)));
                return true;
            }
            case "numberofconsumers": {
                ((PulsarEndpoint)((Object)endpoint)).getPulsarConfiguration().setNumberOfConsumers((Integer)PulsarEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "consumerqueuesize": {
                ((PulsarEndpoint)((Object)endpoint)).getPulsarConfiguration().setConsumerQueueSize((Integer)PulsarEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "consumername": {
                ((PulsarEndpoint)((Object)endpoint)).getPulsarConfiguration().setConsumerName((String)PulsarEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "producername": {
                ((PulsarEndpoint)((Object)endpoint)).getPulsarConfiguration().setProducerName((String)PulsarEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "consumernameprefix": {
                ((PulsarEndpoint)((Object)endpoint)).getPulsarConfiguration().setConsumerNamePrefix((String)PulsarEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "allowmanualacknowledgement": {
                ((PulsarEndpoint)((Object)endpoint)).getPulsarConfiguration().setAllowManualAcknowledgement((Boolean)PulsarEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "acktimeoutmillis": {
                ((PulsarEndpoint)((Object)endpoint)).getPulsarConfiguration().setAckTimeoutMillis((Long)PulsarEndpointConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "ackgrouptimemillis": {
                ((PulsarEndpoint)((Object)endpoint)).getPulsarConfiguration().setAckGroupTimeMillis((Long)PulsarEndpointConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "sendtimeoutms": {
                ((PulsarEndpoint)((Object)endpoint)).getPulsarConfiguration().setSendTimeoutMs((Integer)PulsarEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "blockifqueuefull": {
                ((PulsarEndpoint)((Object)endpoint)).getPulsarConfiguration().setBlockIfQueueFull((Boolean)PulsarEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "maxpendingmessages": {
                ((PulsarEndpoint)((Object)endpoint)).getPulsarConfiguration().setMaxPendingMessages((Integer)PulsarEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "maxpendingmessagesacrosspartitions": {
                ((PulsarEndpoint)((Object)endpoint)).getPulsarConfiguration().setMaxPendingMessagesAcrossPartitions((Integer)PulsarEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "batchingmaxpublishdelaymicros": {
                ((PulsarEndpoint)((Object)endpoint)).getPulsarConfiguration().setBatchingMaxPublishDelayMicros((Long)PulsarEndpointConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "batchingmaxmessages": {
                ((PulsarEndpoint)((Object)endpoint)).getPulsarConfiguration().setBatchingMaxMessages((Integer)PulsarEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "batchingenabled": {
                ((PulsarEndpoint)((Object)endpoint)).getPulsarConfiguration().setBatchingEnabled((Boolean)PulsarEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "initialsequenceid": {
                ((PulsarEndpoint)((Object)endpoint)).getPulsarConfiguration().setInitialSequenceId((Long)PulsarEndpointConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "compressiontype": {
                ((PulsarEndpoint)((Object)endpoint)).getPulsarConfiguration().setCompressionType((CompressionType)PulsarEndpointConfigurer.property((CamelContext)camelContext, CompressionType.class, (Object)value));
                return true;
            }
            case "lazystartproducer": {
                ((PulsarEndpoint)((Object)endpoint)).setLazyStartProducer((Boolean)PulsarEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "bridgeerrorhandler": {
                ((PulsarEndpoint)((Object)endpoint)).setBridgeErrorHandler((Boolean)PulsarEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "exceptionhandler": {
                ((PulsarEndpoint)((Object)endpoint)).setExceptionHandler((ExceptionHandler)PulsarEndpointConfigurer.property((CamelContext)camelContext, ExceptionHandler.class, (Object)value));
                return true;
            }
            case "exchangepattern": {
                ((PulsarEndpoint)((Object)endpoint)).setExchangePattern((ExchangePattern)PulsarEndpointConfigurer.property((CamelContext)camelContext, ExchangePattern.class, (Object)value));
                return true;
            }
            case "synchronous": {
                ((PulsarEndpoint)((Object)endpoint)).setSynchronous((Boolean)PulsarEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "basicpropertybinding": {
                ((PulsarEndpoint)((Object)endpoint)).setBasicPropertyBinding((Boolean)PulsarEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
        }
        return false;
    }
}

