/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.pulsar.configuration;

import java.util.concurrent.TimeUnit;
import org.apache.camel.component.pulsar.utils.consumers.SubscriptionType;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.apache.pulsar.client.api.CompressionType;

@UriParams
public class PulsarConfiguration {
    @UriParam(label="consumer", defaultValue="subs")
    private String subscriptionName = "subs";
    @UriParam(label="consumer", defaultValue="EXCLUSIVE")
    private SubscriptionType subscriptionType = SubscriptionType.EXCLUSIVE;
    @UriParam(label="consumer", defaultValue="1")
    private int numberOfConsumers = 1;
    @UriParam(label="consumer", defaultValue="10")
    private int consumerQueueSize = 10;
    @UriParam(label="consumer", defaultValue="sole-consumer")
    private String consumerName = "sole-consumer";
    @UriParam(label="producer", defaultValue="default-producer")
    private String producerName = "default-producer";
    @UriParam(label="consumer", defaultValue="cons")
    private String consumerNamePrefix = "cons";
    @UriParam(label="consumer", defaultValue="false")
    private boolean allowManualAcknowledgement;
    @UriParam(label="consumer", defaultValue="10000")
    private long ackTimeoutMillis = 10000L;
    @UriParam(label="consumer", defaultValue="100")
    private long ackGroupTimeMillis = 100L;
    @UriParam(label="producer", description="Send timeout in milliseconds", defaultValue="30000")
    private int sendTimeoutMs = 30000;
    @UriParam(label="producer", description="Whether to block the producing thread if pending messages queue is full or to throw a ProducerQueueIsFullError", defaultValue="false")
    private boolean blockIfQueueFull;
    @UriParam(label="producer", description="Size of the pending massages queue. When the queue is full, by default, any further sends will fail unless blockIfQueueFull=true", defaultValue="1000")
    private int maxPendingMessages = 1000;
    @UriParam(label="producer", description="The maximum number of pending messages for partitioned topics. The maxPendingMessages value will be reduced if (number of partitions * maxPendingMessages) exceeds this value. Partitioned topics have a pending message queue for each partition.", defaultValue="50000")
    private int maxPendingMessagesAcrossPartitions = 50000;
    @UriParam(label="producer", description="The maximum time period within which the messages sent will be batched if batchingEnabled is true.", defaultValue="1000")
    private long batchingMaxPublishDelayMicros = TimeUnit.MILLISECONDS.toMicros(1L);
    @UriParam(label="producer", description="The maximum size to batch messages.", defaultValue="1000")
    private int batchingMaxMessages = 1000;
    @UriParam(label="producer", description="Control whether automatic batching of messages is enabled for the producer.", defaultValue="true")
    private boolean batchingEnabled = true;
    @UriParam(label="producer", description="The first message published will have a sequence Id of initialSequenceId  1.", defaultValue="-1")
    private long initialSequenceId = -1L;
    @UriParam(label="producer", description="Compression type to use", defaultValue="NONE")
    private CompressionType compressionType = CompressionType.NONE;

    public String getSubscriptionName() {
        return this.subscriptionName;
    }

    public void setSubscriptionName(String subscriptionName) {
        this.subscriptionName = subscriptionName;
    }

    public SubscriptionType getSubscriptionType() {
        return this.subscriptionType;
    }

    public void setSubscriptionType(SubscriptionType subscriptionType) {
        this.subscriptionType = subscriptionType;
    }

    public int getNumberOfConsumers() {
        return this.numberOfConsumers;
    }

    public void setNumberOfConsumers(int numberOfConsumers) {
        this.numberOfConsumers = numberOfConsumers;
    }

    public int getConsumerQueueSize() {
        return this.consumerQueueSize;
    }

    public void setConsumerQueueSize(int consumerQueueSize) {
        this.consumerQueueSize = consumerQueueSize;
    }

    public String getConsumerName() {
        return this.consumerName;
    }

    public void setConsumerName(String consumerName) {
        this.consumerName = consumerName;
    }

    public String getProducerName() {
        return this.producerName;
    }

    public void setProducerName(String producerName) {
        this.producerName = producerName;
    }

    public String getConsumerNamePrefix() {
        return this.consumerNamePrefix;
    }

    public void setConsumerNamePrefix(String consumerNamePrefix) {
        this.consumerNamePrefix = consumerNamePrefix;
    }

    public boolean isAllowManualAcknowledgement() {
        return this.allowManualAcknowledgement;
    }

    public void setAllowManualAcknowledgement(boolean allowManualAcknowledgement) {
        this.allowManualAcknowledgement = allowManualAcknowledgement;
    }

    public long getAckTimeoutMillis() {
        return this.ackTimeoutMillis;
    }

    public void setAckTimeoutMillis(long ackTimeoutMillis) {
        this.ackTimeoutMillis = ackTimeoutMillis;
    }

    public long getAckGroupTimeMillis() {
        return this.ackGroupTimeMillis;
    }

    public void setAckGroupTimeMillis(long ackGroupTimeMillis) {
        this.ackGroupTimeMillis = ackGroupTimeMillis;
    }

    public void setSendTimeoutMs(int sendTimeoutMs) {
        this.sendTimeoutMs = sendTimeoutMs;
    }

    public int getSendTimeoutMs() {
        return this.sendTimeoutMs;
    }

    public void setBlockIfQueueFull(boolean blockIfQueueFull) {
        this.blockIfQueueFull = blockIfQueueFull;
    }

    public boolean isBlockIfQueueFull() {
        return this.blockIfQueueFull;
    }

    public void setMaxPendingMessages(int maxPendingMessages) {
        this.maxPendingMessages = maxPendingMessages;
    }

    public int getMaxPendingMessages() {
        return this.maxPendingMessages;
    }

    public void setMaxPendingMessagesAcrossPartitions(int maxPendingMessagesAcrossPartitions) {
        this.maxPendingMessagesAcrossPartitions = maxPendingMessagesAcrossPartitions;
    }

    public int getMaxPendingMessagesAcrossPartitions() {
        return this.maxPendingMessagesAcrossPartitions;
    }

    public void setBatchingMaxPublishDelayMicros(long batchingMaxPublishDelayMicros) {
        this.batchingMaxPublishDelayMicros = batchingMaxPublishDelayMicros;
    }

    public long getBatchingMaxPublishDelayMicros() {
        return this.batchingMaxPublishDelayMicros;
    }

    public void setBatchingMaxMessages(int batchingMaxMessages) {
        this.batchingMaxMessages = batchingMaxMessages;
    }

    public int getBatchingMaxMessages() {
        return this.batchingMaxMessages;
    }

    public void setBatchingEnabled(boolean batchingEnabled) {
        this.batchingEnabled = batchingEnabled;
    }

    public boolean isBatchingEnabled() {
        return this.batchingEnabled;
    }

    public void setInitialSequenceId(long initialSequenceId) {
        this.initialSequenceId = initialSequenceId;
    }

    public long getInitialSequenceId() {
        return this.initialSequenceId;
    }

    public void setCompressionType(String compressionType) {
        this.compressionType = CompressionType.valueOf((String)compressionType.toUpperCase());
    }

    public void setCompressionType(CompressionType compressionType) {
        this.compressionType = compressionType;
    }

    public CompressionType getCompressionType() {
        return this.compressionType;
    }
}

