/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.pulsar.utils.consumers;

import java.util.concurrent.TimeUnit;
import org.apache.camel.component.pulsar.PulsarConsumer;
import org.apache.camel.component.pulsar.PulsarEndpoint;
import org.apache.camel.component.pulsar.PulsarMessageListener;
import org.apache.camel.component.pulsar.configuration.PulsarConfiguration;
import org.apache.pulsar.client.api.ConsumerBuilder;
import org.apache.pulsar.client.api.MessageListener;

public final class CommonCreationStrategyImpl {
    private CommonCreationStrategyImpl() {
    }

    public static ConsumerBuilder<byte[]> create(String name, PulsarEndpoint pulsarEndpoint, PulsarConsumer pulsarConsumer) {
        PulsarConfiguration endpointConfiguration = pulsarEndpoint.getPulsarConfiguration();
        return pulsarEndpoint.getPulsarClient().newConsumer().topic(new String[]{pulsarEndpoint.getUri()}).subscriptionName(endpointConfiguration.getSubscriptionName()).receiverQueueSize(endpointConfiguration.getConsumerQueueSize()).consumerName(name).ackTimeout(endpointConfiguration.getAckTimeoutMillis(), TimeUnit.MILLISECONDS).acknowledgmentGroupTime(endpointConfiguration.getAckGroupTimeMillis(), TimeUnit.MILLISECONDS).messageListener((MessageListener)new PulsarMessageListener(pulsarEndpoint, pulsarConsumer.getExceptionHandler(), pulsarConsumer.getProcessor()));
    }
}

