/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.pulsar.utils;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import org.apache.camel.spi.ExecutorServiceManager;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.PulsarClientException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PulsarUtils {
    private static final Logger LOG = LoggerFactory.getLogger(PulsarUtils.class);

    private PulsarUtils() {
    }

    public static Queue<ExecutorService> stopExecutors(ExecutorServiceManager executorServiceManager, Queue<ExecutorService> executors) {
        for (ExecutorService executor : executors) {
            executorServiceManager.shutdownGraceful(executor, 500L);
        }
        return new ConcurrentLinkedQueue<ExecutorService>();
    }

    public static Queue<Consumer<byte[]>> stopConsumers(Queue<Consumer<byte[]>> consumers) throws PulsarClientException {
        while (!consumers.isEmpty()) {
            Consumer<byte[]> consumer = consumers.poll();
            if (consumer == null) continue;
            try {
                consumer.close();
            }
            catch (PulsarClientException.AlreadyClosedException alreadyClosedException) {
            }
            catch (Exception e) {
                LOG.debug("Error stopping consumer: {} due to {}. This exception is ignored", new Object[]{consumer, e.getMessage(), e});
            }
        }
        return new ConcurrentLinkedQueue<Consumer<byte[]>>();
    }
}

