/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.pulsar.utils.consumers;

import java.util.concurrent.TimeUnit;
import org.apache.camel.component.pulsar.PulsarConfiguration;
import org.apache.camel.component.pulsar.PulsarConsumer;
import org.apache.camel.component.pulsar.PulsarEndpoint;
import org.apache.camel.component.pulsar.PulsarMessageListener;
import org.apache.pulsar.client.api.ConsumerBuilder;
import org.apache.pulsar.client.api.DeadLetterPolicy;
import org.apache.pulsar.client.api.MessageListener;

public final class CommonCreationStrategyImpl {
    private CommonCreationStrategyImpl() {
    }

    protected static ConsumerBuilder<byte[]> getBuilder(String name, PulsarEndpoint pulsarEndpoint, PulsarConsumer pulsarConsumer) {
        PulsarConfiguration endpointConfiguration = pulsarEndpoint.getPulsarConfiguration();
        ConsumerBuilder builder = pulsarEndpoint.getPulsarClient().newConsumer();
        if (endpointConfiguration.isTopicsPattern()) {
            builder.topicsPattern(pulsarEndpoint.getUri());
            if (endpointConfiguration.getSubscriptionTopicsMode() != null) {
                builder.subscriptionTopicsMode(endpointConfiguration.getSubscriptionTopicsMode());
            }
        } else {
            builder.topic(new String[]{pulsarEndpoint.getUri()});
        }
        builder.subscriptionName(endpointConfiguration.getSubscriptionName()).receiverQueueSize(endpointConfiguration.getConsumerQueueSize()).consumerName(name).ackTimeout(endpointConfiguration.getAckTimeoutMillis(), TimeUnit.MILLISECONDS).subscriptionInitialPosition(endpointConfiguration.getSubscriptionInitialPosition().toPulsarSubscriptionInitialPosition()).acknowledgmentGroupTime(endpointConfiguration.getAckGroupTimeMillis(), TimeUnit.MILLISECONDS).negativeAckRedeliveryDelay(endpointConfiguration.getNegativeAckRedeliveryDelayMicros(), TimeUnit.MICROSECONDS).readCompacted(endpointConfiguration.isReadCompacted());
        if (endpointConfiguration.isMessageListener()) {
            builder.messageListener((MessageListener)new PulsarMessageListener(pulsarEndpoint, pulsarConsumer));
        }
        if (endpointConfiguration.getMaxRedeliverCount() != null) {
            DeadLetterPolicy.DeadLetterPolicyBuilder policy = DeadLetterPolicy.builder().maxRedeliverCount(endpointConfiguration.getMaxRedeliverCount().intValue());
            if (endpointConfiguration.getDeadLetterTopic() != null) {
                policy.deadLetterTopic(endpointConfiguration.getDeadLetterTopic());
            }
            builder.deadLetterPolicy(policy.build());
        }
        return builder;
    }
}

