/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.pulsar.utils.consumers;

import java.util.Collection;
import java.util.LinkedList;
import org.apache.camel.component.pulsar.PulsarConfiguration;
import org.apache.camel.component.pulsar.PulsarConsumer;
import org.apache.camel.component.pulsar.PulsarEndpoint;
import org.apache.camel.component.pulsar.utils.consumers.CommonCreationStrategyImpl;
import org.apache.camel.component.pulsar.utils.consumers.ConsumerCreationStrategy;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.ConsumerBuilder;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.SubscriptionType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SharedConsumerStrategy
implements ConsumerCreationStrategy {
    private static final Logger LOGGER = LoggerFactory.getLogger(SharedConsumerStrategy.class);
    private final PulsarConsumer pulsarConsumer;

    SharedConsumerStrategy(PulsarConsumer pulsarConsumer) {
        this.pulsarConsumer = pulsarConsumer;
    }

    @Override
    public Collection<Consumer<byte[]>> create(PulsarEndpoint pulsarEndpoint) {
        return this.createMultipleConsumers(pulsarEndpoint);
    }

    private Collection<Consumer<byte[]>> createMultipleConsumers(PulsarEndpoint pulsarEndpoint) {
        LinkedList<Consumer<byte[]>> consumers = new LinkedList<Consumer<byte[]>>();
        PulsarConfiguration configuration = pulsarEndpoint.getPulsarConfiguration();
        for (int i = 0; i < configuration.getNumberOfConsumers(); ++i) {
            String consumerName = configuration.getConsumerNamePrefix() + i;
            try {
                ConsumerBuilder<byte[]> builder = CommonCreationStrategyImpl.getBuilder(consumerName, pulsarEndpoint, this.pulsarConsumer);
                consumers.add((Consumer<byte[]>)builder.subscriptionType(SubscriptionType.Shared).subscribe());
                continue;
            }
            catch (PulsarClientException exception) {
                LOGGER.error("A PulsarClientException occurred when creating Consumer {}, {}", new Object[]{consumerName, exception.getMessage(), exception});
            }
        }
        return consumers;
    }
}

