/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.pulsar.utils.message;

import org.apache.camel.spi.Metadata;

public interface PulsarMessageHeaders {
    @Metadata(label="consumer", description="The properties attached to the message.", javaType="Map<String, String>")
    public static final String PROPERTIES = "properties";
    @Metadata(label="consumer", description="The producer name who produced the message.", javaType="String")
    public static final String PRODUCER_NAME = "producer_name";
    @Metadata(label="consumer", description="The sequence id associated with the message.", javaType="long")
    public static final String SEQUENCE_ID = "sequence_id";
    @Metadata(label="consumer", description="The publish time of the message.", javaType="long")
    public static final String PUBLISH_TIME = "publish_time";
    @Metadata(label="consumer", description="The unique message ID associated with the message.", javaType="org.apache.pulsar.client.api.MessageId")
    public static final String MESSAGE_ID = "message_id";
    @Metadata(label="consumer", description="The event time associated with the message.", javaType="long")
    public static final String EVENT_TIME = "event_time";
    @Metadata(label="consumer", description="The key of the message.", javaType="String")
    public static final String KEY = "key";
    @Metadata(label="consumer", description="The bytes in key.", javaType="byte[]")
    public static final String KEY_BYTES = "key_bytes";
    @Metadata(label="consumer", description="The topic the message was published to.", javaType="String")
    public static final String TOPIC_NAME = "topic_name";
    @Metadata(label="consumer", description="The message receipt.", javaType="org.apache.camel.component.pulsar.PulsarMessageReceipt")
    public static final String MESSAGE_RECEIPT = "message_receipt";
    @Metadata(label="producer", description="The key of the message for routing policy.", javaType="String")
    public static final String KEY_OUT = "CamelPulsarProducerMessageKey";
    @Metadata(label="producer", description="The properties of the message to add.", javaType="Map<String, String>")
    public static final String PROPERTIES_OUT = "CamelPulsarProducerMessageProperties";
    @Metadata(label="producer", description="The event time of the message message.", javaType="Long")
    public static final String EVENT_TIME_OUT = "CamelPulsarProducerMessageEventTime";
    @Metadata(label="producer", description="Deliver the message only at or after the specified absolute timestamp. The timestamp is milliseconds and based on UTC (eg: System.currentTimeMillis) Note: messages are only delivered with delay when a consumer is consuming through a Shared subscription. With other subscription types, the messages will still be delivered immediately.", javaType="Long")
    public static final String DELIVER_AT_OUT = "CamelPulsarProducerMessageDeliverAt";
    @Metadata(label="consumer", description="The message redelivery count, redelivery count maintain in pulsar broker.", javaType="int")
    public static final String PULSAR_REDELIVERY_COUNT = "CamelPulsarRedeliveryCount";
}

