/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.pulsar;

import org.apache.camel.CamelContext;
import org.apache.camel.component.pulsar.PulsarComponent;
import org.apache.camel.component.pulsar.PulsarConfiguration;
import org.apache.camel.component.pulsar.PulsarMessageReceiptFactory;
import org.apache.camel.component.pulsar.utils.AutoConfiguration;
import org.apache.camel.component.pulsar.utils.consumers.SubscriptionInitialPosition;
import org.apache.camel.component.pulsar.utils.consumers.SubscriptionType;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import org.apache.pulsar.client.api.BatcherBuilder;
import org.apache.pulsar.client.api.CompressionType;
import org.apache.pulsar.client.api.MessageRouter;
import org.apache.pulsar.client.api.MessageRoutingMode;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.RedeliveryBackoff;
import org.apache.pulsar.client.api.RegexSubscriptionMode;

public class PulsarComponentConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    private PulsarConfiguration getOrCreateConfiguration(PulsarComponent target) {
        if (target.getConfiguration() == null) {
            target.setConfiguration(new PulsarConfiguration());
        }
        return target.getConfiguration();
    }

    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        PulsarComponent target = (PulsarComponent)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "ackgrouptimemillis": 
            case "ackGroupTimeMillis": {
                this.getOrCreateConfiguration(target).setAckGroupTimeMillis((Long)PulsarComponentConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "acktimeoutmillis": 
            case "ackTimeoutMillis": {
                this.getOrCreateConfiguration(target).setAckTimeoutMillis((Long)PulsarComponentConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "acktimeoutredeliverybackoff": 
            case "ackTimeoutRedeliveryBackoff": {
                this.getOrCreateConfiguration(target).setAckTimeoutRedeliveryBackoff((RedeliveryBackoff)PulsarComponentConfigurer.property((CamelContext)camelContext, RedeliveryBackoff.class, (Object)value));
                return true;
            }
            case "allowmanualacknowledgement": 
            case "allowManualAcknowledgement": {
                this.getOrCreateConfiguration(target).setAllowManualAcknowledgement((Boolean)PulsarComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "authenticationclass": 
            case "authenticationClass": {
                this.getOrCreateConfiguration(target).setAuthenticationClass((String)PulsarComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "authenticationparams": 
            case "authenticationParams": {
                this.getOrCreateConfiguration(target).setAuthenticationParams((String)PulsarComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "autoconfiguration": 
            case "autoConfiguration": {
                target.setAutoConfiguration((AutoConfiguration)PulsarComponentConfigurer.property((CamelContext)camelContext, AutoConfiguration.class, (Object)value));
                return true;
            }
            case "autowiredenabled": 
            case "autowiredEnabled": {
                target.setAutowiredEnabled((Boolean)PulsarComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "batcherbuilder": 
            case "batcherBuilder": {
                this.getOrCreateConfiguration(target).setBatcherBuilder((BatcherBuilder)PulsarComponentConfigurer.property((CamelContext)camelContext, BatcherBuilder.class, (Object)value));
                return true;
            }
            case "batchingenabled": 
            case "batchingEnabled": {
                this.getOrCreateConfiguration(target).setBatchingEnabled((Boolean)PulsarComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "batchingmaxmessages": 
            case "batchingMaxMessages": {
                this.getOrCreateConfiguration(target).setBatchingMaxMessages((Integer)PulsarComponentConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "batchingmaxpublishdelaymicros": 
            case "batchingMaxPublishDelayMicros": {
                this.getOrCreateConfiguration(target).setBatchingMaxPublishDelayMicros((Long)PulsarComponentConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "blockifqueuefull": 
            case "blockIfQueueFull": {
                this.getOrCreateConfiguration(target).setBlockIfQueueFull((Boolean)PulsarComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                target.setBridgeErrorHandler((Boolean)PulsarComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "chunkingenabled": 
            case "chunkingEnabled": {
                this.getOrCreateConfiguration(target).setChunkingEnabled((Boolean)PulsarComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "compressiontype": 
            case "compressionType": {
                this.getOrCreateConfiguration(target).setCompressionType((CompressionType)PulsarComponentConfigurer.property((CamelContext)camelContext, CompressionType.class, (Object)value));
                return true;
            }
            case "configuration": {
                target.setConfiguration((PulsarConfiguration)PulsarComponentConfigurer.property((CamelContext)camelContext, PulsarConfiguration.class, (Object)value));
                return true;
            }
            case "consumername": 
            case "consumerName": {
                this.getOrCreateConfiguration(target).setConsumerName((String)PulsarComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "consumernameprefix": 
            case "consumerNamePrefix": {
                this.getOrCreateConfiguration(target).setConsumerNamePrefix((String)PulsarComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "consumerqueuesize": 
            case "consumerQueueSize": {
                this.getOrCreateConfiguration(target).setConsumerQueueSize((Integer)PulsarComponentConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "deadlettertopic": 
            case "deadLetterTopic": {
                this.getOrCreateConfiguration(target).setDeadLetterTopic((String)PulsarComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "initialsequenceid": 
            case "initialSequenceId": {
                this.getOrCreateConfiguration(target).setInitialSequenceId((Long)PulsarComponentConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer((Boolean)PulsarComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "maxpendingmessages": 
            case "maxPendingMessages": {
                this.getOrCreateConfiguration(target).setMaxPendingMessages((Integer)PulsarComponentConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "maxpendingmessagesacrosspartitions": 
            case "maxPendingMessagesAcrossPartitions": {
                this.getOrCreateConfiguration(target).setMaxPendingMessagesAcrossPartitions((Integer)PulsarComponentConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "maxredelivercount": 
            case "maxRedeliverCount": {
                this.getOrCreateConfiguration(target).setMaxRedeliverCount((Integer)PulsarComponentConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "messagelistener": 
            case "messageListener": {
                this.getOrCreateConfiguration(target).setMessageListener((Boolean)PulsarComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "messagerouter": 
            case "messageRouter": {
                this.getOrCreateConfiguration(target).setMessageRouter((MessageRouter)PulsarComponentConfigurer.property((CamelContext)camelContext, MessageRouter.class, (Object)value));
                return true;
            }
            case "messageroutingmode": 
            case "messageRoutingMode": {
                this.getOrCreateConfiguration(target).setMessageRoutingMode((MessageRoutingMode)PulsarComponentConfigurer.property((CamelContext)camelContext, MessageRoutingMode.class, (Object)value));
                return true;
            }
            case "negativeackredeliverybackoff": 
            case "negativeAckRedeliveryBackoff": {
                this.getOrCreateConfiguration(target).setNegativeAckRedeliveryBackoff((RedeliveryBackoff)PulsarComponentConfigurer.property((CamelContext)camelContext, RedeliveryBackoff.class, (Object)value));
                return true;
            }
            case "negativeackredeliverydelaymicros": 
            case "negativeAckRedeliveryDelayMicros": {
                this.getOrCreateConfiguration(target).setNegativeAckRedeliveryDelayMicros((Long)PulsarComponentConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "numberofconsumerthreads": 
            case "numberOfConsumerThreads": {
                this.getOrCreateConfiguration(target).setNumberOfConsumerThreads((Integer)PulsarComponentConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "numberofconsumers": 
            case "numberOfConsumers": {
                this.getOrCreateConfiguration(target).setNumberOfConsumers((Integer)PulsarComponentConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "producername": 
            case "producerName": {
                this.getOrCreateConfiguration(target).setProducerName((String)PulsarComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "pulsarclient": 
            case "pulsarClient": {
                target.setPulsarClient((PulsarClient)PulsarComponentConfigurer.property((CamelContext)camelContext, PulsarClient.class, (Object)value));
                return true;
            }
            case "pulsarmessagereceiptfactory": 
            case "pulsarMessageReceiptFactory": {
                target.setPulsarMessageReceiptFactory((PulsarMessageReceiptFactory)PulsarComponentConfigurer.property((CamelContext)camelContext, PulsarMessageReceiptFactory.class, (Object)value));
                return true;
            }
            case "readcompacted": 
            case "readCompacted": {
                this.getOrCreateConfiguration(target).setReadCompacted((Boolean)PulsarComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "sendtimeoutms": 
            case "sendTimeoutMs": {
                this.getOrCreateConfiguration(target).setSendTimeoutMs((Integer)PulsarComponentConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "serviceurl": 
            case "serviceUrl": {
                this.getOrCreateConfiguration(target).setServiceUrl((String)PulsarComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "subscriptioninitialposition": 
            case "subscriptionInitialPosition": {
                this.getOrCreateConfiguration(target).setSubscriptionInitialPosition((SubscriptionInitialPosition)((Object)PulsarComponentConfigurer.property((CamelContext)camelContext, SubscriptionInitialPosition.class, (Object)value)));
                return true;
            }
            case "subscriptionname": 
            case "subscriptionName": {
                this.getOrCreateConfiguration(target).setSubscriptionName((String)PulsarComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "subscriptiontopicsmode": 
            case "subscriptionTopicsMode": {
                this.getOrCreateConfiguration(target).setSubscriptionTopicsMode((RegexSubscriptionMode)PulsarComponentConfigurer.property((CamelContext)camelContext, RegexSubscriptionMode.class, (Object)value));
                return true;
            }
            case "subscriptiontype": 
            case "subscriptionType": {
                this.getOrCreateConfiguration(target).setSubscriptionType((SubscriptionType)((Object)PulsarComponentConfigurer.property((CamelContext)camelContext, SubscriptionType.class, (Object)value)));
                return true;
            }
            case "topicspattern": 
            case "topicsPattern": {
                this.getOrCreateConfiguration(target).setTopicsPattern((Boolean)PulsarComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
        }
        return false;
    }

    public String[] getAutowiredNames() {
        return new String[]{"pulsarClient"};
    }

    public Class<?> getOptionType(String name, boolean ignoreCase) {
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "ackgrouptimemillis": 
            case "ackGroupTimeMillis": {
                return Long.TYPE;
            }
            case "acktimeoutmillis": 
            case "ackTimeoutMillis": {
                return Long.TYPE;
            }
            case "acktimeoutredeliverybackoff": 
            case "ackTimeoutRedeliveryBackoff": {
                return RedeliveryBackoff.class;
            }
            case "allowmanualacknowledgement": 
            case "allowManualAcknowledgement": {
                return Boolean.TYPE;
            }
            case "authenticationclass": 
            case "authenticationClass": {
                return String.class;
            }
            case "authenticationparams": 
            case "authenticationParams": {
                return String.class;
            }
            case "autoconfiguration": 
            case "autoConfiguration": {
                return AutoConfiguration.class;
            }
            case "autowiredenabled": 
            case "autowiredEnabled": {
                return Boolean.TYPE;
            }
            case "batcherbuilder": 
            case "batcherBuilder": {
                return BatcherBuilder.class;
            }
            case "batchingenabled": 
            case "batchingEnabled": {
                return Boolean.TYPE;
            }
            case "batchingmaxmessages": 
            case "batchingMaxMessages": {
                return Integer.TYPE;
            }
            case "batchingmaxpublishdelaymicros": 
            case "batchingMaxPublishDelayMicros": {
                return Long.TYPE;
            }
            case "blockifqueuefull": 
            case "blockIfQueueFull": {
                return Boolean.TYPE;
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return Boolean.TYPE;
            }
            case "chunkingenabled": 
            case "chunkingEnabled": {
                return Boolean.TYPE;
            }
            case "compressiontype": 
            case "compressionType": {
                return CompressionType.class;
            }
            case "configuration": {
                return PulsarConfiguration.class;
            }
            case "consumername": 
            case "consumerName": {
                return String.class;
            }
            case "consumernameprefix": 
            case "consumerNamePrefix": {
                return String.class;
            }
            case "consumerqueuesize": 
            case "consumerQueueSize": {
                return Integer.TYPE;
            }
            case "deadlettertopic": 
            case "deadLetterTopic": {
                return String.class;
            }
            case "initialsequenceid": 
            case "initialSequenceId": {
                return Long.TYPE;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return Boolean.TYPE;
            }
            case "maxpendingmessages": 
            case "maxPendingMessages": {
                return Integer.TYPE;
            }
            case "maxpendingmessagesacrosspartitions": 
            case "maxPendingMessagesAcrossPartitions": {
                return Integer.TYPE;
            }
            case "maxredelivercount": 
            case "maxRedeliverCount": {
                return Integer.class;
            }
            case "messagelistener": 
            case "messageListener": {
                return Boolean.TYPE;
            }
            case "messagerouter": 
            case "messageRouter": {
                return MessageRouter.class;
            }
            case "messageroutingmode": 
            case "messageRoutingMode": {
                return MessageRoutingMode.class;
            }
            case "negativeackredeliverybackoff": 
            case "negativeAckRedeliveryBackoff": {
                return RedeliveryBackoff.class;
            }
            case "negativeackredeliverydelaymicros": 
            case "negativeAckRedeliveryDelayMicros": {
                return Long.TYPE;
            }
            case "numberofconsumerthreads": 
            case "numberOfConsumerThreads": {
                return Integer.TYPE;
            }
            case "numberofconsumers": 
            case "numberOfConsumers": {
                return Integer.TYPE;
            }
            case "producername": 
            case "producerName": {
                return String.class;
            }
            case "pulsarclient": 
            case "pulsarClient": {
                return PulsarClient.class;
            }
            case "pulsarmessagereceiptfactory": 
            case "pulsarMessageReceiptFactory": {
                return PulsarMessageReceiptFactory.class;
            }
            case "readcompacted": 
            case "readCompacted": {
                return Boolean.TYPE;
            }
            case "sendtimeoutms": 
            case "sendTimeoutMs": {
                return Integer.TYPE;
            }
            case "serviceurl": 
            case "serviceUrl": {
                return String.class;
            }
            case "subscriptioninitialposition": 
            case "subscriptionInitialPosition": {
                return SubscriptionInitialPosition.class;
            }
            case "subscriptionname": 
            case "subscriptionName": {
                return String.class;
            }
            case "subscriptiontopicsmode": 
            case "subscriptionTopicsMode": {
                return RegexSubscriptionMode.class;
            }
            case "subscriptiontype": 
            case "subscriptionType": {
                return SubscriptionType.class;
            }
            case "topicspattern": 
            case "topicsPattern": {
                return Boolean.TYPE;
            }
        }
        return null;
    }

    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        PulsarComponent target = (PulsarComponent)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "ackgrouptimemillis": 
            case "ackGroupTimeMillis": {
                return this.getOrCreateConfiguration(target).getAckGroupTimeMillis();
            }
            case "acktimeoutmillis": 
            case "ackTimeoutMillis": {
                return this.getOrCreateConfiguration(target).getAckTimeoutMillis();
            }
            case "acktimeoutredeliverybackoff": 
            case "ackTimeoutRedeliveryBackoff": {
                return this.getOrCreateConfiguration(target).getAckTimeoutRedeliveryBackoff();
            }
            case "allowmanualacknowledgement": 
            case "allowManualAcknowledgement": {
                return this.getOrCreateConfiguration(target).isAllowManualAcknowledgement();
            }
            case "authenticationclass": 
            case "authenticationClass": {
                return this.getOrCreateConfiguration(target).getAuthenticationClass();
            }
            case "authenticationparams": 
            case "authenticationParams": {
                return this.getOrCreateConfiguration(target).getAuthenticationParams();
            }
            case "autoconfiguration": 
            case "autoConfiguration": {
                return target.getAutoConfiguration();
            }
            case "autowiredenabled": 
            case "autowiredEnabled": {
                return target.isAutowiredEnabled();
            }
            case "batcherbuilder": 
            case "batcherBuilder": {
                return this.getOrCreateConfiguration(target).getBatcherBuilder();
            }
            case "batchingenabled": 
            case "batchingEnabled": {
                return this.getOrCreateConfiguration(target).isBatchingEnabled();
            }
            case "batchingmaxmessages": 
            case "batchingMaxMessages": {
                return this.getOrCreateConfiguration(target).getBatchingMaxMessages();
            }
            case "batchingmaxpublishdelaymicros": 
            case "batchingMaxPublishDelayMicros": {
                return this.getOrCreateConfiguration(target).getBatchingMaxPublishDelayMicros();
            }
            case "blockifqueuefull": 
            case "blockIfQueueFull": {
                return this.getOrCreateConfiguration(target).isBlockIfQueueFull();
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return target.isBridgeErrorHandler();
            }
            case "chunkingenabled": 
            case "chunkingEnabled": {
                return this.getOrCreateConfiguration(target).isChunkingEnabled();
            }
            case "compressiontype": 
            case "compressionType": {
                return this.getOrCreateConfiguration(target).getCompressionType();
            }
            case "configuration": {
                return target.getConfiguration();
            }
            case "consumername": 
            case "consumerName": {
                return this.getOrCreateConfiguration(target).getConsumerName();
            }
            case "consumernameprefix": 
            case "consumerNamePrefix": {
                return this.getOrCreateConfiguration(target).getConsumerNamePrefix();
            }
            case "consumerqueuesize": 
            case "consumerQueueSize": {
                return this.getOrCreateConfiguration(target).getConsumerQueueSize();
            }
            case "deadlettertopic": 
            case "deadLetterTopic": {
                return this.getOrCreateConfiguration(target).getDeadLetterTopic();
            }
            case "initialsequenceid": 
            case "initialSequenceId": {
                return this.getOrCreateConfiguration(target).getInitialSequenceId();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "maxpendingmessages": 
            case "maxPendingMessages": {
                return this.getOrCreateConfiguration(target).getMaxPendingMessages();
            }
            case "maxpendingmessagesacrosspartitions": 
            case "maxPendingMessagesAcrossPartitions": {
                return this.getOrCreateConfiguration(target).getMaxPendingMessagesAcrossPartitions();
            }
            case "maxredelivercount": 
            case "maxRedeliverCount": {
                return this.getOrCreateConfiguration(target).getMaxRedeliverCount();
            }
            case "messagelistener": 
            case "messageListener": {
                return this.getOrCreateConfiguration(target).isMessageListener();
            }
            case "messagerouter": 
            case "messageRouter": {
                return this.getOrCreateConfiguration(target).getMessageRouter();
            }
            case "messageroutingmode": 
            case "messageRoutingMode": {
                return this.getOrCreateConfiguration(target).getMessageRoutingMode();
            }
            case "negativeackredeliverybackoff": 
            case "negativeAckRedeliveryBackoff": {
                return this.getOrCreateConfiguration(target).getNegativeAckRedeliveryBackoff();
            }
            case "negativeackredeliverydelaymicros": 
            case "negativeAckRedeliveryDelayMicros": {
                return this.getOrCreateConfiguration(target).getNegativeAckRedeliveryDelayMicros();
            }
            case "numberofconsumerthreads": 
            case "numberOfConsumerThreads": {
                return this.getOrCreateConfiguration(target).getNumberOfConsumerThreads();
            }
            case "numberofconsumers": 
            case "numberOfConsumers": {
                return this.getOrCreateConfiguration(target).getNumberOfConsumers();
            }
            case "producername": 
            case "producerName": {
                return this.getOrCreateConfiguration(target).getProducerName();
            }
            case "pulsarclient": 
            case "pulsarClient": {
                return target.getPulsarClient();
            }
            case "pulsarmessagereceiptfactory": 
            case "pulsarMessageReceiptFactory": {
                return target.getPulsarMessageReceiptFactory();
            }
            case "readcompacted": 
            case "readCompacted": {
                return this.getOrCreateConfiguration(target).isReadCompacted();
            }
            case "sendtimeoutms": 
            case "sendTimeoutMs": {
                return this.getOrCreateConfiguration(target).getSendTimeoutMs();
            }
            case "serviceurl": 
            case "serviceUrl": {
                return this.getOrCreateConfiguration(target).getServiceUrl();
            }
            case "subscriptioninitialposition": 
            case "subscriptionInitialPosition": {
                return this.getOrCreateConfiguration(target).getSubscriptionInitialPosition();
            }
            case "subscriptionname": 
            case "subscriptionName": {
                return this.getOrCreateConfiguration(target).getSubscriptionName();
            }
            case "subscriptiontopicsmode": 
            case "subscriptionTopicsMode": {
                return this.getOrCreateConfiguration(target).getSubscriptionTopicsMode();
            }
            case "subscriptiontype": 
            case "subscriptionType": {
                return this.getOrCreateConfiguration(target).getSubscriptionType();
            }
            case "topicspattern": 
            case "topicsPattern": {
                return this.getOrCreateConfiguration(target).isTopicsPattern();
            }
        }
        return null;
    }
}

