/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.pulsar.utils.consumers;

import java.util.Collection;
import java.util.Collections;
import org.apache.camel.component.pulsar.PulsarConsumer;
import org.apache.camel.component.pulsar.PulsarEndpoint;
import org.apache.camel.component.pulsar.utils.consumers.CommonCreationStrategyImpl;
import org.apache.camel.component.pulsar.utils.consumers.ConsumerCreationStrategy;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.ConsumerBuilder;
import org.apache.pulsar.client.api.SubscriptionType;

public class ExclusiveConsumerStrategy
implements ConsumerCreationStrategy {
    private final PulsarConsumer pulsarConsumer;

    ExclusiveConsumerStrategy(PulsarConsumer pulsarConsumer) {
        this.pulsarConsumer = pulsarConsumer;
    }

    @Override
    public Collection<Consumer<byte[]>> create(PulsarEndpoint pulsarEndpoint) throws Exception {
        String consumerName = pulsarEndpoint.getPulsarConfiguration().getConsumerName();
        ConsumerBuilder<byte[]> builder = CommonCreationStrategyImpl.create(consumerName, pulsarEndpoint, this.pulsarConsumer);
        return Collections.singletonList(builder.subscriptionType(SubscriptionType.Exclusive).subscribe());
    }
}

