/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.pulsar.utils;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.PulsarClientException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PulsarUtils {
    private static final Logger LOG = LoggerFactory.getLogger(PulsarUtils.class);

    private PulsarUtils() {
    }

    public static Queue<Consumer<byte[]>> stopConsumers(Queue<Consumer<byte[]>> consumers) throws PulsarClientException {
        while (!consumers.isEmpty()) {
            Consumer<byte[]> consumer = consumers.poll();
            if (consumer == null) continue;
            try {
                consumer.close();
            }
            catch (Exception e) {
                if (e instanceof PulsarClientException.AlreadyClosedException) continue;
                LOG.debug("Error stopping consumer: {} due to {}. This exception is ignored", new Object[]{consumer, e.getMessage(), e});
            }
        }
        return new ConcurrentLinkedQueue<Consumer<byte[]>>();
    }
}

