/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.pulsar;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class PulsarEndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":persistence://tenant/namespace/topic";
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;

    public boolean isEnabled(String scheme) {
        return "pulsar".equals(scheme);
    }

    public String buildUri(String scheme, Map<String, Object> properties, boolean encode) throws URISyntaxException {
        String syntax;
        String uri = syntax = scheme + BASE;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, uri, "persistence", null, true, copy);
        uri = this.buildPathParameter(syntax, uri, "tenant", null, true, copy);
        uri = this.buildPathParameter(syntax, uri, "namespace", null, true, copy);
        uri = this.buildPathParameter(syntax, uri, "topic", null, true, copy);
        uri = this.buildQueryParameters(uri, copy, encode);
        return uri;
    }

    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    public boolean isLenientProperties() {
        return false;
    }

    static {
        HashSet<String> props = new HashSet<String>(37);
        props.add("initialSequenceId");
        props.add("maxRedeliverCount");
        props.add("messageRouter");
        props.add("batchingMaxMessages");
        props.add("compressionType");
        props.add("consumerQueueSize");
        props.add("topicsPattern");
        props.add("negativeAckRedeliveryDelayMicros");
        props.add("maxPendingMessagesAcrossPartitions");
        props.add("ackGroupTimeMillis");
        props.add("bridgeErrorHandler");
        props.add("batchingEnabled");
        props.add("sendTimeoutMs");
        props.add("tenant");
        props.add("batcherBuilder");
        props.add("blockIfQueueFull");
        props.add("numberOfConsumers");
        props.add("batchingMaxPublishDelayMicros");
        props.add("subscriptionTopicsMode");
        props.add("producerName");
        props.add("exchangePattern");
        props.add("subscriptionInitialPosition");
        props.add("maxPendingMessages");
        props.add("messageRoutingMode");
        props.add("ackTimeoutMillis");
        props.add("consumerNamePrefix");
        props.add("readCompacted");
        props.add("lazyStartProducer");
        props.add("subscriptionType");
        props.add("subscriptionName");
        props.add("namespace");
        props.add("persistence");
        props.add("topic");
        props.add("exceptionHandler");
        props.add("deadLetterTopic");
        props.add("allowManualAcknowledgement");
        props.add("consumerName");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        SECRET_PROPERTY_NAMES = Collections.emptySet();
    }
}

