/**
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.component.quartz;

import org.apache.camel.CamelContext;
import org.apache.camel.ExchangePattern;
import org.apache.camel.impl.DefaultExchange;
import org.quartz.JobExecutionContext;

/**
 * @version $Revision: 630591 $
 */
public class QuartzExchange extends DefaultExchange {
    public QuartzExchange(CamelContext context, ExchangePattern pattern, JobExecutionContext jobExecutionContext) {
        super(context, pattern);
        setIn(new QuartzMessage(this, jobExecutionContext));
    }

    @Override
    public QuartzMessage getIn() {
        return (QuartzMessage) super.getIn();
    }

    public JobExecutionContext getJobExecutionContext() {
        return getIn().getJobExecutionContext();
    }
}
