/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.quartz;

import java.util.Date;
import org.apache.camel.Component;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.quartz.CamelJob;
import org.apache.camel.component.quartz.QuartzComponent;
import org.apache.camel.component.quartz.QuartzConsumer;
import org.apache.camel.component.quartz.QuartzMessage;
import org.apache.camel.component.quartz.StatefulCamelJob;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.processor.loadbalancer.LoadBalancer;
import org.apache.camel.processor.loadbalancer.RoundRobinLoadBalancer;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;

public class QuartzEndpoint
extends DefaultEndpoint {
    private static final transient Log LOG = LogFactory.getLog(QuartzEndpoint.class);
    private Scheduler scheduler;
    private LoadBalancer loadBalancer;
    private Trigger trigger;
    private JobDetail jobDetail;
    private boolean started;
    private boolean stateful;

    public QuartzEndpoint() {
    }

    public QuartzEndpoint(String endpointUri, QuartzComponent component, Scheduler scheduler) {
        super(endpointUri, (Component)component);
        this.scheduler = scheduler;
    }

    public QuartzEndpoint(String endpointUri, Scheduler scheduler) {
        super(endpointUri);
        this.scheduler = scheduler;
    }

    public void addTrigger(Trigger trigger, JobDetail detail) throws SchedulerException {
        if (trigger.getName() == null) {
            trigger.setName(detail.getName());
        }
        if (trigger.getGroup() == null) {
            trigger.setGroup(detail.getGroup());
        }
        if (trigger.getStartTime() == null) {
            trigger.setStartTime(new Date());
        }
        detail.getJobDataMap().put((Object)"CamelQuartzEndpoint", this.isStateful() ? this.getEndpointUri() : this);
        if (detail.getJobClass() == null) {
            detail.setJobClass(this.isStateful() ? StatefulCamelJob.class : CamelJob.class);
        }
        if (detail.getName() == null) {
            detail.setName(this.getEndpointUri());
        }
        this.getScheduler().scheduleJob(detail, trigger);
    }

    public void removeTrigger(Trigger trigger, JobDetail jobDetail) throws SchedulerException {
        this.getScheduler().unscheduleJob(trigger.getName(), trigger.getGroup());
    }

    public void onJobExecute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Firing Quartz Job with context: " + jobExecutionContext));
        }
        Exchange exchange = this.createExchange(jobExecutionContext);
        try {
            this.getLoadBalancer().process(exchange);
            if (exchange.getException() != null) {
                throw new JobExecutionException((Throwable)exchange.getException());
            }
        }
        catch (Exception e) {
            LOG.error((Object)ExchangeHelper.createExceptionMessage((String)"Error processing exchange", (Exchange)exchange, (Throwable)e));
            if (e instanceof JobExecutionException) {
                throw (JobExecutionException)e;
            }
            throw new JobExecutionException((Throwable)e);
        }
    }

    public Exchange createExchange(JobExecutionContext jobExecutionContext) {
        Exchange exchange = this.createExchange();
        exchange.setIn((Message)new QuartzMessage(exchange, jobExecutionContext));
        return exchange;
    }

    public Producer createProducer() throws Exception {
        throw new UnsupportedOperationException("You cannot send messages to this endpoint");
    }

    public QuartzConsumer createConsumer(Processor processor) throws Exception {
        return new QuartzConsumer(this, processor);
    }

    protected String createEndpointUri() {
        return "quartz://" + this.getTrigger().getGroup() + "/" + this.getTrigger().getName();
    }

    public QuartzComponent getComponent() {
        return (QuartzComponent)super.getComponent();
    }

    public boolean isSingleton() {
        return true;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public LoadBalancer getLoadBalancer() {
        if (this.loadBalancer == null) {
            this.loadBalancer = this.createLoadBalancer();
        }
        return this.loadBalancer;
    }

    public void setLoadBalancer(LoadBalancer loadBalancer) {
        this.loadBalancer = loadBalancer;
    }

    public JobDetail getJobDetail() {
        if (this.jobDetail == null) {
            this.jobDetail = this.createJobDetail();
        }
        return this.jobDetail;
    }

    public void setJobDetail(JobDetail jobDetail) {
        this.jobDetail = jobDetail;
    }

    public Trigger getTrigger() {
        return this.trigger;
    }

    public void setTrigger(Trigger trigger) {
        this.trigger = trigger;
    }

    public boolean isStateful() {
        return this.stateful;
    }

    public void setStateful(boolean stateful) {
        this.stateful = stateful;
    }

    public void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    public synchronized void consumerStarted(QuartzConsumer consumer) throws SchedulerException {
        ObjectHelper.notNull((Object)this.trigger, (String)"trigger");
        this.getLoadBalancer().addProcessor(consumer.getProcessor());
        if (!this.started) {
            this.addTrigger(this.getTrigger(), this.getJobDetail());
            this.started = true;
        }
    }

    public synchronized void consumerStopped(QuartzConsumer consumer) throws SchedulerException {
        ObjectHelper.notNull((Object)this.trigger, (String)"trigger");
        this.getLoadBalancer().removeProcessor(consumer.getProcessor());
        if (this.getLoadBalancer().getProcessors().isEmpty() && this.started) {
            this.removeTrigger(this.getTrigger(), this.getJobDetail());
            this.started = false;
        }
    }

    protected LoadBalancer createLoadBalancer() {
        return new RoundRobinLoadBalancer();
    }

    protected JobDetail createJobDetail() {
        return new JobDetail();
    }
}

