/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.routepolicy.quartz;

import java.util.concurrent.TimeUnit;
import org.apache.camel.Route;
import org.apache.camel.component.quartz.QuartzComponent;
import org.apache.camel.routepolicy.quartz.ScheduledRouteDetails;
import org.apache.camel.routepolicy.quartz.ScheduledRoutePolicy;
import org.apache.camel.routepolicy.quartz.ScheduledRoutePolicyConstants;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.CronTrigger;
import org.quartz.Trigger;

public class CronScheduledRoutePolicy
extends ScheduledRoutePolicy
implements ScheduledRoutePolicyConstants {
    private static final transient Log LOG = LogFactory.getLog(CronScheduledRoutePolicy.class);
    private String routeStartTime;
    private String routeStopTime;
    private String routeSuspendTime;
    private String routeResumeTime;

    public void onInit(Route route) {
        try {
            QuartzComponent quartz = (QuartzComponent)route.getRouteContext().getCamelContext().getComponent("quartz", QuartzComponent.class);
            this.setScheduler(quartz.getScheduler());
            if (this.getRouteStopGracePeriod() == 0) {
                this.setRouteStopGracePeriod(10000);
            }
            if (this.getTimeUnit() == null) {
                this.setTimeUnit(TimeUnit.MILLISECONDS);
            }
            if (this.getRouteStartTime() == null && this.getRouteStopTime() == null && this.getRouteSuspendTime() == null && this.getRouteResumeTime() == null) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn((Object)("Scheduled Route Policy for route " + route.getId() + " is not set since the no start, stop and/or suspend times are specified"));
                }
                return;
            }
            if (this.scheduledRouteDetails == null) {
                this.scheduledRouteDetails = new ScheduledRouteDetails();
                this.scheduledRouteDetails.setRoute(route);
                if (this.getRouteStartTime() != null) {
                    this.scheduleRoute(ScheduledRoutePolicyConstants.Action.START);
                }
                if (this.getRouteStopTime() != null) {
                    this.scheduleRoute(ScheduledRoutePolicyConstants.Action.STOP);
                }
                if (this.getRouteSuspendTime() != null) {
                    this.scheduleRoute(ScheduledRoutePolicyConstants.Action.SUSPEND);
                }
                if (this.getRouteResumeTime() != null) {
                    this.scheduleRoute(ScheduledRoutePolicyConstants.Action.RESUME);
                }
            }
            this.getScheduler().start();
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    protected void doStop() throws Exception {
        if (this.scheduledRouteDetails.getStartJobDetail() != null) {
            this.deleteRouteJob(ScheduledRoutePolicyConstants.Action.START);
        }
        if (this.scheduledRouteDetails.getStopJobDetail() != null) {
            this.deleteRouteJob(ScheduledRoutePolicyConstants.Action.STOP);
        }
        if (this.scheduledRouteDetails.getSuspendJobDetail() != null) {
            this.deleteRouteJob(ScheduledRoutePolicyConstants.Action.SUSPEND);
        }
        if (this.scheduledRouteDetails.getResumeJobDetail() != null) {
            this.deleteRouteJob(ScheduledRoutePolicyConstants.Action.RESUME);
        }
    }

    protected Trigger createTrigger(ScheduledRoutePolicyConstants.Action action, Route route) throws Exception {
        CronTrigger trigger = null;
        if (action == ScheduledRoutePolicyConstants.Action.START) {
            trigger = new CronTrigger(TRIGGER_START + route.getId(), "triggerGroup-" + route.getId(), this.getRouteStartTime());
        } else if (action == ScheduledRoutePolicyConstants.Action.STOP) {
            trigger = new CronTrigger(TRIGGER_STOP + route.getId(), "triggerGroup-" + route.getId(), this.getRouteStopTime());
        } else if (action == ScheduledRoutePolicyConstants.Action.SUSPEND) {
            trigger = new CronTrigger(TRIGGER_SUSPEND + route.getId(), "triggerGroup-" + route.getId(), this.getRouteSuspendTime());
        } else if (action == ScheduledRoutePolicyConstants.Action.RESUME) {
            trigger = new CronTrigger(TRIGGER_RESUME + route.getId(), "triggerGroup-" + route.getId(), this.getRouteResumeTime());
        }
        return trigger;
    }

    public void setRouteStartTime(String routeStartTime) {
        this.routeStartTime = routeStartTime;
    }

    public String getRouteStartTime() {
        return this.routeStartTime;
    }

    public void setRouteStopTime(String routeStopTime) {
        this.routeStopTime = routeStopTime;
    }

    public String getRouteStopTime() {
        return this.routeStopTime;
    }

    public void setRouteSuspendTime(String routeSuspendTime) {
        this.routeSuspendTime = routeSuspendTime;
    }

    public String getRouteSuspendTime() {
        return this.routeSuspendTime;
    }

    public void setRouteResumeTime(String routeResumeTime) {
        this.routeResumeTime = routeResumeTime;
    }

    public String getRouteResumeTime() {
        return this.routeResumeTime;
    }
}

