/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.routepolicy.quartz;

import java.util.concurrent.TimeUnit;
import org.apache.camel.Route;
import org.apache.camel.ServiceStatus;
import org.apache.camel.impl.RoutePolicySupport;
import org.apache.camel.routepolicy.quartz.ScheduledJob;
import org.apache.camel.routepolicy.quartz.ScheduledJobState;
import org.apache.camel.routepolicy.quartz.ScheduledRouteDetails;
import org.apache.camel.routepolicy.quartz.ScheduledRoutePolicyConstants;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ScheduledRoutePolicy
extends RoutePolicySupport
implements ScheduledRoutePolicyConstants {
    private static final transient Logger LOG = LoggerFactory.getLogger(ScheduledRoutePolicy.class);
    protected ScheduledRouteDetails scheduledRouteDetails;
    private Scheduler scheduler;
    private int routeStopGracePeriod;
    private TimeUnit timeUnit;

    protected abstract Trigger createTrigger(ScheduledRoutePolicyConstants.Action var1, Route var2) throws Exception;

    protected void onJobExecute(ScheduledRoutePolicyConstants.Action action, Route route) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Scheduled Event notification received. Performing requested operation " + (Object)((Object)action) + " for route " + route.getId());
        }
        ServiceStatus routeStatus = route.getRouteContext().getCamelContext().getRouteStatus(route.getId());
        if (action == ScheduledRoutePolicyConstants.Action.START) {
            if (routeStatus == ServiceStatus.Stopped) {
                this.startRoute(route);
            } else if (routeStatus == ServiceStatus.Suspended) {
                this.startConsumer(route.getConsumer());
            }
        } else if (action == ScheduledRoutePolicyConstants.Action.STOP) {
            if (routeStatus == ServiceStatus.Started || routeStatus == ServiceStatus.Suspended) {
                this.stopRoute(route, this.getRouteStopGracePeriod(), this.getTimeUnit());
            }
        } else if (action == ScheduledRoutePolicyConstants.Action.SUSPEND) {
            if (routeStatus == ServiceStatus.Started) {
                this.stopConsumer(route.getConsumer());
            } else if (LOG.isWarnEnabled()) {
                LOG.warn("Route is not in a started state and cannot be suspended. The current route state is " + routeStatus);
            }
        } else if (action == ScheduledRoutePolicyConstants.Action.RESUME) {
            if (routeStatus == ServiceStatus.Started) {
                this.startConsumer(route.getConsumer());
            } else if (LOG.isWarnEnabled()) {
                LOG.warn("Route is not in a started state and cannot be resumed. The current route state is " + routeStatus);
            }
        }
    }

    public void scheduleRoute(ScheduledRoutePolicyConstants.Action action) throws Exception {
        Route route = this.scheduledRouteDetails.getRoute();
        JobDetail jobDetail = this.createJobDetail(action, route);
        Trigger trigger = this.createTrigger(action, route);
        this.updateScheduledRouteDetails(action, jobDetail, trigger);
        this.loadCallbackDataIntoSchedulerContext(jobDetail, action, route);
        this.getScheduler().scheduleJob(jobDetail, trigger);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Scheduled Trigger: " + trigger.getFullName() + " is operational");
        }
    }

    public void pauseRouteTrigger(ScheduledRoutePolicyConstants.Action action) throws SchedulerException {
        String triggerName = this.retrieveTriggerName(action);
        String triggerGroup = this.retrieveTriggerGroup(action);
        this.getScheduler().pauseTrigger(triggerName, triggerGroup);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Scheduled Trigger: " + triggerGroup + "." + triggerName + " is paused");
        }
    }

    public void resumeRouteTrigger(ScheduledRoutePolicyConstants.Action action) throws SchedulerException {
        String triggerName = this.retrieveTriggerName(action);
        String triggerGroup = this.retrieveTriggerGroup(action);
        this.getScheduler().resumeTrigger(triggerName, triggerGroup);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Scheduled Trigger: " + triggerGroup + "." + triggerName + " has been resumed");
        }
    }

    public void deleteRouteJob(ScheduledRoutePolicyConstants.Action action) throws SchedulerException {
        String jobDetailName = this.retrieveJobDetailName(action);
        String jobDetailGroup = this.retrieveJobDetailGroup(action);
        if (!this.getScheduler().isShutdown()) {
            this.getScheduler().deleteJob(jobDetailName, jobDetailGroup);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Scheduled Job: " + jobDetailGroup + "." + jobDetailName + " has been deleted");
        }
    }

    protected JobDetail createJobDetail(ScheduledRoutePolicyConstants.Action action, Route route) throws Exception {
        JobDetail jobDetail = null;
        if (action == ScheduledRoutePolicyConstants.Action.START) {
            jobDetail = new JobDetail(JOB_START + route.getId(), "jobGroup-" + route.getId(), ScheduledJob.class);
        } else if (action == ScheduledRoutePolicyConstants.Action.STOP) {
            jobDetail = new JobDetail(JOB_STOP + route.getId(), "jobGroup-" + route.getId(), ScheduledJob.class);
        } else if (action == ScheduledRoutePolicyConstants.Action.SUSPEND) {
            jobDetail = new JobDetail(JOB_SUSPEND + route.getId(), "jobGroup-" + route.getId(), ScheduledJob.class);
        } else if (action == ScheduledRoutePolicyConstants.Action.RESUME) {
            jobDetail = new JobDetail(JOB_RESUME + route.getId(), "jobGroup-" + route.getId(), ScheduledJob.class);
        }
        return jobDetail;
    }

    protected void updateScheduledRouteDetails(ScheduledRoutePolicyConstants.Action action, JobDetail jobDetail, Trigger trigger) throws Exception {
        if (action == ScheduledRoutePolicyConstants.Action.START) {
            this.scheduledRouteDetails.setStartJobDetail(jobDetail);
            this.scheduledRouteDetails.setStartTrigger(trigger);
        } else if (action == ScheduledRoutePolicyConstants.Action.STOP) {
            this.scheduledRouteDetails.setStopJobDetail(jobDetail);
            this.scheduledRouteDetails.setStopTrigger(trigger);
        } else if (action == ScheduledRoutePolicyConstants.Action.SUSPEND) {
            this.scheduledRouteDetails.setSuspendJobDetail(jobDetail);
            this.scheduledRouteDetails.setSuspendTrigger(trigger);
        } else if (action == ScheduledRoutePolicyConstants.Action.RESUME) {
            this.scheduledRouteDetails.setResumeJobDetail(jobDetail);
            this.scheduledRouteDetails.setResumeTrigger(trigger);
        }
    }

    protected void loadCallbackDataIntoSchedulerContext(JobDetail jobDetail, ScheduledRoutePolicyConstants.Action action, Route route) throws SchedulerException {
        this.getScheduler().getContext().put((Object)jobDetail.getName(), (Object)new ScheduledJobState(action, route));
    }

    public String retrieveTriggerName(ScheduledRoutePolicyConstants.Action action) {
        String triggerName = null;
        if (action == ScheduledRoutePolicyConstants.Action.START) {
            triggerName = this.scheduledRouteDetails.getStartTrigger().getName();
        } else if (action == ScheduledRoutePolicyConstants.Action.STOP) {
            triggerName = this.scheduledRouteDetails.getStopTrigger().getName();
        } else if (action == ScheduledRoutePolicyConstants.Action.SUSPEND) {
            triggerName = this.scheduledRouteDetails.getSuspendTrigger().getName();
        } else if (action == ScheduledRoutePolicyConstants.Action.RESUME) {
            triggerName = this.scheduledRouteDetails.getResumeTrigger().getName();
        }
        return triggerName;
    }

    public String retrieveTriggerGroup(ScheduledRoutePolicyConstants.Action action) {
        String triggerGroup = null;
        if (action == ScheduledRoutePolicyConstants.Action.START) {
            triggerGroup = this.scheduledRouteDetails.getStartTrigger().getGroup();
        } else if (action == ScheduledRoutePolicyConstants.Action.STOP) {
            triggerGroup = this.scheduledRouteDetails.getStopTrigger().getGroup();
        } else if (action == ScheduledRoutePolicyConstants.Action.SUSPEND) {
            triggerGroup = this.scheduledRouteDetails.getSuspendTrigger().getGroup();
        } else if (action == ScheduledRoutePolicyConstants.Action.RESUME) {
            triggerGroup = this.scheduledRouteDetails.getResumeTrigger().getGroup();
        }
        return triggerGroup;
    }

    public String retrieveJobDetailName(ScheduledRoutePolicyConstants.Action action) {
        String jobDetailName = null;
        if (action == ScheduledRoutePolicyConstants.Action.START) {
            jobDetailName = this.scheduledRouteDetails.getStartJobDetail().getName();
        } else if (action == ScheduledRoutePolicyConstants.Action.STOP) {
            jobDetailName = this.scheduledRouteDetails.getStopJobDetail().getName();
        } else if (action == ScheduledRoutePolicyConstants.Action.SUSPEND) {
            jobDetailName = this.scheduledRouteDetails.getSuspendJobDetail().getName();
        } else if (action == ScheduledRoutePolicyConstants.Action.RESUME) {
            jobDetailName = this.scheduledRouteDetails.getResumeJobDetail().getName();
        }
        return jobDetailName;
    }

    public String retrieveJobDetailGroup(ScheduledRoutePolicyConstants.Action action) {
        String jobDetailGroup = null;
        if (action == ScheduledRoutePolicyConstants.Action.START) {
            jobDetailGroup = this.scheduledRouteDetails.getStartJobDetail().getGroup();
        } else if (action == ScheduledRoutePolicyConstants.Action.STOP) {
            jobDetailGroup = this.scheduledRouteDetails.getStopJobDetail().getGroup();
        } else if (action == ScheduledRoutePolicyConstants.Action.SUSPEND) {
            jobDetailGroup = this.scheduledRouteDetails.getSuspendJobDetail().getGroup();
        } else if (action == ScheduledRoutePolicyConstants.Action.RESUME) {
            jobDetailGroup = this.scheduledRouteDetails.getResumeJobDetail().getGroup();
        }
        return jobDetailGroup;
    }

    public ScheduledRouteDetails getScheduledRouteDetails() {
        return this.scheduledRouteDetails;
    }

    public void setScheduledRouteDetails(ScheduledRouteDetails scheduledRouteDetails) {
        this.scheduledRouteDetails = scheduledRouteDetails;
    }

    public void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public void setRouteStopGracePeriod(int routeStopGracePeriod) {
        this.routeStopGracePeriod = routeStopGracePeriod;
    }

    public int getRouteStopGracePeriod() {
        return this.routeStopGracePeriod;
    }

    public void setTimeUnit(TimeUnit timeUnit) {
        this.timeUnit = timeUnit;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }
}

