/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.routepolicy.quartz;

import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.apache.camel.Route;
import org.apache.camel.component.quartz.QuartzComponent;
import org.apache.camel.routepolicy.quartz.CronScheduledRoutePolicy;
import org.apache.camel.routepolicy.quartz.ScheduledRouteDetails;
import org.apache.camel.routepolicy.quartz.ScheduledRoutePolicy;
import org.apache.camel.routepolicy.quartz.ScheduledRoutePolicyConstants;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleScheduledRoutePolicy
extends ScheduledRoutePolicy {
    private static final transient Logger LOG = LoggerFactory.getLogger(CronScheduledRoutePolicy.class);
    private Date routeStartDate;
    private int routeStartRepeatCount;
    private long routeStartRepeatInterval;
    private Date routeStopDate;
    private int routeStopRepeatCount;
    private long routeStopRepeatInterval;
    private Date routeSuspendDate;
    private int routeSuspendRepeatCount;
    private long routeSuspendRepeatInterval;
    private Date routeResumeDate;
    private int routeResumeRepeatCount;
    private long routeResumeRepeatInterval;

    public void onInit(Route route) {
        try {
            QuartzComponent quartz = (QuartzComponent)route.getRouteContext().getCamelContext().getComponent("quartz", QuartzComponent.class);
            this.setScheduler(quartz.getScheduler());
            if (this.getRouteStopGracePeriod() == 0) {
                this.setRouteStopGracePeriod(10000);
            }
            if (this.getTimeUnit() == null) {
                this.setTimeUnit(TimeUnit.MILLISECONDS);
            }
            if (this.getRouteStartDate() == null && this.getRouteStopDate() == null && this.getRouteSuspendDate() == null && this.getRouteResumeDate() == null) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn("Scheduled Route Policy for route " + route.getId() + " is not set since the no start, stop and/or suspend times are specified");
                }
                return;
            }
            if (this.scheduledRouteDetails == null) {
                this.scheduledRouteDetails = new ScheduledRouteDetails();
                this.scheduledRouteDetails.setRoute(route);
                if (this.getRouteStartDate() != null) {
                    this.scheduleRoute(ScheduledRoutePolicyConstants.Action.START);
                }
                if (this.getRouteStopDate() != null) {
                    this.scheduleRoute(ScheduledRoutePolicyConstants.Action.STOP);
                }
                if (this.getRouteSuspendDate() != null) {
                    this.scheduleRoute(ScheduledRoutePolicyConstants.Action.SUSPEND);
                }
                if (this.getRouteResumeDate() != null) {
                    this.scheduleRoute(ScheduledRoutePolicyConstants.Action.RESUME);
                }
            }
            this.getScheduler().start();
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    protected void doStop() throws Exception {
        if (this.scheduledRouteDetails.getStartJobDetail() != null) {
            this.deleteRouteJob(ScheduledRoutePolicyConstants.Action.START);
        }
        if (this.scheduledRouteDetails.getStopJobDetail() != null) {
            this.deleteRouteJob(ScheduledRoutePolicyConstants.Action.STOP);
        }
        if (this.scheduledRouteDetails.getSuspendJobDetail() != null) {
            this.deleteRouteJob(ScheduledRoutePolicyConstants.Action.SUSPEND);
        }
        if (this.scheduledRouteDetails.getResumeJobDetail() != null) {
            this.deleteRouteJob(ScheduledRoutePolicyConstants.Action.RESUME);
        }
    }

    @Override
    protected Trigger createTrigger(ScheduledRoutePolicyConstants.Action action, Route route) throws Exception {
        SimpleTrigger trigger = null;
        if (action == ScheduledRoutePolicyConstants.Action.START) {
            trigger = new SimpleTrigger(TRIGGER_START + route.getId(), "triggerGroup-" + route.getId(), this.getRouteStartDate(), null, this.getRouteStartRepeatCount(), this.getRouteStartRepeatInterval());
        } else if (action == ScheduledRoutePolicyConstants.Action.STOP) {
            trigger = new SimpleTrigger(TRIGGER_STOP + route.getId(), "triggerGroup-" + route.getId(), this.getRouteStopDate(), null, this.getRouteStopRepeatCount(), this.getRouteStopRepeatInterval());
        } else if (action == ScheduledRoutePolicyConstants.Action.SUSPEND) {
            trigger = new SimpleTrigger(TRIGGER_SUSPEND + route.getId(), "triggerGroup-" + route.getId(), this.getRouteSuspendDate(), null, this.getRouteSuspendRepeatCount(), this.getRouteSuspendRepeatInterval());
        } else if (action == ScheduledRoutePolicyConstants.Action.RESUME) {
            trigger = new SimpleTrigger(TRIGGER_RESUME + route.getId(), "triggerGroup-" + route.getId(), this.getRouteResumeDate(), null, this.getRouteResumeRepeatCount(), this.getRouteResumeRepeatInterval());
        }
        return trigger;
    }

    public Date getRouteStartDate() {
        return this.routeStartDate;
    }

    public void setRouteStartDate(Date routeStartDate) {
        this.routeStartDate = routeStartDate;
    }

    public Date getRouteStopDate() {
        return this.routeStopDate;
    }

    public void setRouteStopDate(Date routeStopDate) {
        this.routeStopDate = routeStopDate;
    }

    public Date getRouteSuspendDate() {
        return this.routeSuspendDate;
    }

    public void setRouteSuspendDate(Date routeSuspendDate) {
        this.routeSuspendDate = routeSuspendDate;
    }

    public int getRouteStartRepeatCount() {
        return this.routeStartRepeatCount;
    }

    public void setRouteStartRepeatCount(int routeStartRepeatCount) {
        this.routeStartRepeatCount = routeStartRepeatCount;
    }

    public long getRouteStartRepeatInterval() {
        return this.routeStartRepeatInterval;
    }

    public void setRouteStartRepeatInterval(long routeStartRepeatInterval) {
        this.routeStartRepeatInterval = routeStartRepeatInterval;
    }

    public int getRouteStopRepeatCount() {
        return this.routeStopRepeatCount;
    }

    public void setRouteStopRepeatCount(int routeStopRepeatCount) {
        this.routeStopRepeatCount = routeStopRepeatCount;
    }

    public long getRouteStopRepeatInterval() {
        return this.routeStopRepeatInterval;
    }

    public void setRouteStopRepeatInterval(long routeStopRepeatInterval) {
        this.routeStopRepeatInterval = routeStopRepeatInterval;
    }

    public int getRouteSuspendRepeatCount() {
        return this.routeSuspendRepeatCount;
    }

    public void setRouteSuspendRepeatCount(int routeSuspendRepeatCount) {
        this.routeSuspendRepeatCount = routeSuspendRepeatCount;
    }

    public long getRouteSuspendRepeatInterval() {
        return this.routeSuspendRepeatInterval;
    }

    public void setRouteSuspendRepeatInterval(long routeSuspendRepeatInterval) {
        this.routeSuspendRepeatInterval = routeSuspendRepeatInterval;
    }

    public void setRouteResumeDate(Date routeResumeDate) {
        this.routeResumeDate = routeResumeDate;
    }

    public Date getRouteResumeDate() {
        return this.routeResumeDate;
    }

    public void setRouteResumeRepeatCount(int routeResumeRepeatCount) {
        this.routeResumeRepeatCount = routeResumeRepeatCount;
    }

    public int getRouteResumeRepeatCount() {
        return this.routeResumeRepeatCount;
    }

    public void setRouteResumeRepeatInterval(long routeResumeRepeatInterval) {
        this.routeResumeRepeatInterval = routeResumeRepeatInterval;
    }

    public long getRouteResumeRepeatInterval() {
        return this.routeResumeRepeatInterval;
    }
}

