/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reactive.vertx;

import io.vertx.core.Vertx;
import org.apache.camel.Experimental;
import org.apache.camel.StaticService;
import org.apache.camel.spi.ReactiveExecutor;
import org.apache.camel.spi.annotations.JdkService;
import org.apache.camel.support.service.ServiceSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Experimental
@JdkService(value="reactive-executor")
public class VertXReactiveExecutor
extends ServiceSupport
implements ReactiveExecutor,
StaticService {
    private static final Logger LOG = LoggerFactory.getLogger(VertXReactiveExecutor.class);
    private Vertx vertx;
    private boolean shouldClose;

    public Vertx getVertx() {
        return this.vertx;
    }

    public void setVertx(Vertx vertx) {
        this.vertx = vertx;
    }

    public void schedule(Runnable runnable) {
        LOG.trace("schedule: {}", (Object)runnable);
        this.vertx.nettyEventLoopGroup().execute(runnable);
    }

    public void scheduleMain(Runnable runnable) {
        LOG.trace("scheduleMain: {}", (Object)runnable);
        this.vertx.nettyEventLoopGroup().execute(runnable);
    }

    public void scheduleSync(Runnable runnable) {
        LOG.trace("scheduleSync: {}", (Object)runnable);
        Runnable task = runnable;
        this.vertx.executeBlocking(future -> {
            task.run();
            future.complete();
        }, res -> {});
    }

    public boolean executeFromQueue() {
        return false;
    }

    protected void doStart() throws Exception {
        if (this.vertx == null) {
            LOG.debug("Starting VertX");
            this.shouldClose = true;
            this.vertx = Vertx.vertx();
        }
    }

    protected void doStop() throws Exception {
        if (this.vertx != null && this.shouldClose) {
            LOG.debug("Stopping VertX");
            this.vertx.close();
        }
    }

    public String toString() {
        return "camel-reactive-executor-vertx";
    }
}

