/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reactive.vertx;

import io.vertx.core.Vertx;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Experimental;
import org.apache.camel.StaticService;
import org.apache.camel.spi.ReactiveExecutor;
import org.apache.camel.spi.annotations.JdkService;
import org.apache.camel.support.service.ServiceSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Experimental
@JdkService(value="reactive-executor")
public class VertXReactiveExecutor
extends ServiceSupport
implements CamelContextAware,
ReactiveExecutor,
StaticService {
    private static final Logger LOG = LoggerFactory.getLogger(VertXReactiveExecutor.class);
    private CamelContext camelContext;
    private Vertx vertx;

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public Vertx getVertx() {
        return this.vertx;
    }

    public void setVertx(Vertx vertx) {
        this.vertx = vertx;
    }

    protected void doInit() throws Exception {
        Set set;
        super.doInit();
        if (this.vertx == null && (set = this.getCamelContext().getRegistry().findByType(Vertx.class)).size() == 1) {
            this.vertx = (Vertx)set.iterator().next();
        }
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.vertx == null) {
            throw new IllegalArgumentException("VertX instance must be configured.");
        }
    }

    public void schedule(Runnable runnable) {
        LOG.trace("schedule: {}", (Object)runnable);
        this.vertx.nettyEventLoopGroup().execute(runnable);
    }

    public void scheduleMain(Runnable runnable) {
        LOG.trace("scheduleMain: {}", (Object)runnable);
        this.vertx.nettyEventLoopGroup().execute(runnable);
    }

    public void scheduleSync(Runnable runnable) {
        LOG.trace("scheduleSync: {}", (Object)runnable);
        Runnable task = runnable;
        this.vertx.executeBlocking(future -> {
            task.run();
            future.complete();
        }, res -> {});
    }

    public boolean executeFromQueue() {
        return false;
    }

    public String toString() {
        return "camel-reactive-executor-vertx";
    }
}

