/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.github;

import org.apache.camel.CamelContext;
import org.apache.camel.github.GitHubResource;
import org.apache.camel.spi.Resource;
import org.apache.camel.spi.annotations.ResourceResolver;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.StringHelper;

@ResourceResolver(value="github")
public class GitHubResourceResolver
extends ServiceSupport
implements org.apache.camel.spi.ResourceResolver {
    private static final String GITHUB_URL = "https://raw.githubusercontent.com/%s/%s/%s/%s";
    private CamelContext camelContext;

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public String getSupportedScheme() {
        return "github";
    }

    public Resource resolve(String location) {
        String[] parts = location.split(":");
        String org = null;
        String rep = null;
        String branch = "main";
        String name = null;
        if (parts.length == 3) {
            org = parts[1];
            rep = parts[2];
            if (rep.contains("/")) {
                name = StringHelper.after((String)rep, (String)"/");
                rep = StringHelper.before((String)rep, (String)"/");
            }
        } else if (parts.length == 4) {
            org = parts[1];
            rep = parts[2];
            name = parts[3];
        } else if (parts.length == 5) {
            org = parts[1];
            rep = parts[2];
            branch = parts[3];
            name = parts[4];
        }
        if (org == null || rep == null || branch == null || name == null) {
            throw new IllegalArgumentException(location);
        }
        String target = String.format(GITHUB_URL, org, rep, branch, name);
        return new GitHubResource(this.camelContext, target);
    }
}

