/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.rest.openapi;

import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.SpecVersion;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.responses.ApiResponse;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.camel.CamelContext;
import org.apache.camel.StartupStep;
import org.apache.camel.component.rest.openapi.RestOpenApiProcessor;
import org.apache.camel.spi.PackageScanClassResolver;
import org.apache.camel.spi.StartupStepRecorder;
import org.apache.camel.support.PluginHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenApiUtils {
    private static final Logger LOG = LoggerFactory.getLogger(OpenApiUtils.class);
    private static final Map<String, Class<?>> OPENAPI_TYPES = Map.of("integer", Integer.class, "number", Double.class, "string", String.class, "boolean", Boolean.class);
    private static final Map<String, Class<?>> OPENAPI_FORMATS = Map.of("int32", Integer.class, "int64", Long.class, "float", Float.class, "double", Double.class, "byte", byte[].class, "binary", byte[].class, "date", LocalDate.class, "date-time", LocalDateTime.class);
    private static final Pattern CLASS_NAME_PATTERN = Pattern.compile(".*\\/(.*)");
    private final AtomicBoolean packageScanInit = new AtomicBoolean();
    private final Set<Class<?>> scannedClasses = new HashSet();
    private final CamelContext camelContext;
    private final String bindingPackage;
    private final Components components;

    public OpenApiUtils(CamelContext camelContext, String bindingPackage, Components components) {
        this.camelContext = camelContext;
        this.bindingPackage = bindingPackage;
        this.components = components;
    }

    public boolean isRequiredBody(Operation operation) {
        return operation.getRequestBody() != null && Boolean.TRUE == operation.getRequestBody().getRequired();
    }

    public String getConsumes(Operation operation) {
        Content content;
        if (operation.getRequestBody() != null && (content = operation.getRequestBody().getContent()) != null) {
            return content.keySet().stream().sorted().collect(Collectors.joining(","));
        }
        return null;
    }

    public String getProduces(Operation operation) {
        if (operation.getResponses() != null) {
            HashSet mediaTypes = new HashSet();
            for (ApiResponse apiResponse : operation.getResponses().values()) {
                Content content = apiResponse.getContent();
                if (content == null) continue;
                mediaTypes.addAll(content.keySet());
            }
            if (!mediaTypes.isEmpty()) {
                return mediaTypes.stream().sorted().collect(Collectors.joining(","));
            }
        }
        return null;
    }

    public Set<String> getRequiredQueryParameters(Operation operation) {
        return this.getRequiredParameters(operation, "query");
    }

    public Set<String> getRequiredHeaders(Operation operation) {
        return this.getRequiredParameters(operation, "header");
    }

    public Map<String, String> getQueryParametersDefaultValue(Operation operation) {
        Map<String, String> defaultValues = null;
        if (operation.getParameters() != null) {
            defaultValues = operation.getParameters().stream().filter(p -> "query".equals(p.getIn())).filter(p -> p.getSchema() != null).filter(p -> p.getSchema().getDefault() != null).collect(Collectors.toMap(Parameter::getName, p -> p.getSchema().getDefault().toString()));
        }
        return defaultValues;
    }

    public String manageRequestBody(Operation operation) {
        if (operation.getRequestBody() != null) {
            Content content = operation.getRequestBody().getContent();
            return this.findClass(content);
        }
        return null;
    }

    public String manageResponseBody(Operation operation) {
        if (operation.getResponses() != null) {
            for (ApiResponse a : operation.getResponses().values()) {
                Content content = a.getContent();
                String className = this.findClass(content);
                if (className == null) continue;
                return className;
            }
        }
        return null;
    }

    public void clear() {
        this.scannedClasses.clear();
    }

    private String findClass(Content content) {
        if (content != null) {
            for (Map.Entry mediaTypeEntry : content.entrySet()) {
                Class<?> clazz = this.loadBindingClass(mediaTypeEntry);
                if (clazz == null) continue;
                return this.resolveClassName(((MediaType)mediaTypeEntry.getValue()).getSchema(), clazz);
            }
        }
        return null;
    }

    private Class<?> loadBindingClass(Map.Entry<String, MediaType> mediaType) {
        this.scan();
        String mediaTypeName = mediaType.getKey();
        Schema schema = mediaType.getValue().getSchema();
        if (mediaTypeName.contains("xml") && schema.getXml() != null) {
            return this.loadBindingClassForXml(schema);
        }
        if (mediaTypeName.contains("json")) {
            return this.loadBindingClassForJson(schema);
        }
        return null;
    }

    private Class<?> loadBindingClassForXml(Schema<?> schema) {
        Object ref = schema.getXml().getName();
        ref = Character.toUpperCase(((String)ref).charAt(0)) + ((String)ref).substring(1);
        for (Class<?> clazz : this.scannedClasses) {
            if (!clazz.getSimpleName().equals(ref)) continue;
            return clazz;
        }
        return null;
    }

    private Class<?> loadBindingClassForJson(Schema<?> schema) {
        Class<?> primitiveType;
        String schemaName;
        if (this.isArrayType(schema)) {
            schema = schema.getItems();
        }
        if ((schemaName = this.findSchemaName(schema)) == null && (primitiveType = this.resolvePrimitiveType(schema)) != null) {
            return primitiveType;
        }
        if ((schemaName = Optional.ofNullable(schemaName).orElse(Optional.ofNullable(schema.get$ref()).orElse(this.getSchemaType(schema)))) == null) {
            return null;
        }
        Matcher classNameMatcher = CLASS_NAME_PATTERN.matcher(schemaName);
        String classToFind = classNameMatcher.find() ? classNameMatcher.group(1) : schemaName;
        String schemaTitle = schema.getTitle();
        return this.scannedClasses.stream().filter(aClass -> aClass.getSimpleName().equals(classToFind) || aClass.getSimpleName().equals(schemaTitle)).findFirst().orElse(null);
    }

    public boolean isArrayType(Schema<?> schema) {
        if (schema.getSpecVersion() == SpecVersion.V30) {
            return schema instanceof ArraySchema;
        }
        if (schema.getTypes() == null) {
            return false;
        }
        return "array".equals(schema.getTypes().stream().findFirst().orElse(null));
    }

    private String getSchemaType(Schema<?> schema) {
        if (schema.getSpecVersion() == SpecVersion.V30) {
            return schema.getType();
        }
        return schema.getTypes() == null ? null : (String)schema.getTypes().stream().findFirst().orElse(null);
    }

    private String resolveClassName(Schema<?> schema, Class<?> clazz) {
        if (this.isArrayType(schema)) {
            return clazz.getName().concat("[]");
        }
        return clazz.getName();
    }

    private Class<?> resolvePrimitiveType(Schema<?> schema) {
        String type = this.getSchemaType(schema);
        if (type == null) {
            return null;
        }
        String format = schema.getFormat();
        Class<?> classType = OPENAPI_TYPES.get(type);
        if (format != null && (classType = OPENAPI_FORMATS.get(format)) == null) {
            return String.class;
        }
        return classType;
    }

    private void scan() {
        if (this.packageScanInit.compareAndSet(false, true) && this.bindingPackage != null) {
            StartupStepRecorder recorder = this.camelContext.getCamelContextExtension().getStartupStepRecorder();
            StartupStep step = recorder.beginStep(RestOpenApiProcessor.class, "openapi-binding", "OpenAPI binding classes package scan");
            String[] pcks = this.bindingPackage.split(",");
            PackageScanClassResolver resolver = PluginHelper.getPackageScanClassResolver((CamelContext)this.camelContext);
            this.scannedClasses.addAll(resolver.findImplementations(Object.class, pcks));
            if (!this.scannedClasses.isEmpty()) {
                LOG.info("Binding package scan found {} classes in packages: {}", (Object)this.scannedClasses.size(), (Object)this.bindingPackage);
            }
            recorder.endStep(step);
        }
    }

    private Set<String> getRequiredParameters(Operation operation, String type) {
        Set parameters = null;
        if (operation.getParameters() != null) {
            parameters = operation.getParameters().stream().filter(parameter -> type.equals(parameter.getIn())).filter(parameter -> Boolean.TRUE == parameter.getRequired()).map(Parameter::getName).collect(Collectors.toSet());
        }
        return parameters;
    }

    private String findSchemaName(Schema<?> schema) {
        if (this.components != null) {
            for (Map.Entry schemaEntry : this.components.getSchemas().entrySet()) {
                if (schemaEntry.getValue() != schema) continue;
                return (String)schemaEntry.getKey();
            }
        }
        return null;
    }
}

