/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.rest;

import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.StringJoiner;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.Message;
import org.apache.camel.Producer;
import org.apache.camel.component.rest.RestEndpoint;
import org.apache.camel.component.rest.RestProducerBindingProcessor;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.PropertyConfigurer;
import org.apache.camel.spi.RestConfiguration;
import org.apache.camel.support.AsyncProcessorConverterHelper;
import org.apache.camel.support.DefaultAsyncProducer;
import org.apache.camel.support.PropertyBindingSupport;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;

public class RestProducer
extends DefaultAsyncProducer {
    private static final String ACCEPT = "Accept";
    private final CamelContext camelContext;
    private final RestConfiguration configuration;
    private boolean prepareUriTemplate = true;
    private RestConfiguration.RestBindingMode bindingMode;
    private Boolean skipBindingOnErrorCode;
    private String type;
    private String outType;
    private AsyncProcessor producer;
    private AsyncProcessor binding;

    public RestProducer(Endpoint endpoint, Producer producer, RestConfiguration configuration) {
        super(endpoint);
        this.camelContext = endpoint.getCamelContext();
        this.configuration = configuration;
        this.producer = AsyncProcessorConverterHelper.convert((Producer)producer);
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        try {
            this.prepareExchange(exchange);
            if (this.binding != null) {
                return this.binding.process(exchange, callback);
            }
            return this.producer.process(exchange, callback);
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
            callback.done(true);
            return true;
        }
    }

    public RestEndpoint getEndpoint() {
        return (RestEndpoint)super.getEndpoint();
    }

    public boolean isPrepareUriTemplate() {
        return this.prepareUriTemplate;
    }

    public void setPrepareUriTemplate(boolean prepareUriTemplate) {
        this.prepareUriTemplate = prepareUriTemplate;
    }

    public RestConfiguration.RestBindingMode getBindingMode() {
        return this.bindingMode;
    }

    public void setBindingMode(RestConfiguration.RestBindingMode bindingMode) {
        this.bindingMode = bindingMode;
    }

    public Boolean getSkipBindingOnErrorCode() {
        return this.skipBindingOnErrorCode;
    }

    public void setSkipBindingOnErrorCode(Boolean skipBindingOnErrorCode) {
        this.skipBindingOnErrorCode = skipBindingOnErrorCode;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getOutType() {
        return this.outType;
    }

    public void setOutType(String outType) {
        this.outType = outType;
    }

    protected void prepareExchange(Exchange exchange) throws Exception {
        String method;
        String query;
        boolean hasPath = false;
        String resolvedUriTemplate = this.getEndpoint().getUriTemplate() != null ? this.getEndpoint().getUriTemplate() : this.getEndpoint().getPath();
        Message inMessage = exchange.getIn();
        if (this.prepareUriTemplate && resolvedUriTemplate.contains("{")) {
            String[] arr = resolvedUriTemplate.split("\\/");
            StringJoiner uriTemplateBuilder = new StringJoiner("/");
            for (String a : arr) {
                String resolvedUriParam = this.resolveHeaderPlaceholders(a, inMessage);
                if (!(a.equals(resolvedUriParam) || resolvedUriParam.contains("{") || resolvedUriParam.contains("}"))) {
                    hasPath = true;
                    uriTemplateBuilder.add(resolvedUriParam);
                    continue;
                }
                uriTemplateBuilder.add(a);
            }
            resolvedUriTemplate = uriTemplateBuilder.toString();
        }
        if ((query = RestProducer.createQueryParameters(this.getEndpoint().getQueryParameters(), inMessage)) != null) {
            inMessage.setHeader("CamelRestHttpQuery", (Object)query);
        }
        if (hasPath) {
            String host = this.getEndpoint().getHost();
            String basePath = this.getEndpoint().getUriTemplate() != null ? this.getEndpoint().getPath() : null;
            basePath = FileUtil.stripLeadingSeparator((String)basePath);
            resolvedUriTemplate = FileUtil.stripLeadingSeparator((String)resolvedUriTemplate);
            String overrideUri = host;
            if (!ObjectHelper.isEmpty((Object)basePath)) {
                overrideUri = overrideUri + "/" + basePath;
            }
            if (!ObjectHelper.isEmpty((Object)resolvedUriTemplate)) {
                overrideUri = overrideUri + "/" + resolvedUriTemplate;
            }
            inMessage.setHeader("CamelRestHttpUri", (Object)overrideUri);
            inMessage.removeHeader("CamelHttpPath");
        }
        if ((method = this.getEndpoint().getMethod()) != null) {
            String upper = method.toUpperCase(Locale.US);
            inMessage.setHeader("CamelHttpMethod", (Object)upper);
        }
        String produces = this.getEndpoint().getProduces();
        if (ObjectHelper.isEmpty((Object)inMessage.getHeader("Content-Type")) && ObjectHelper.isNotEmpty((Object)produces)) {
            inMessage.setHeader("Content-Type", (Object)produces);
        }
        String consumes = this.getEndpoint().getConsumes();
        if (ObjectHelper.isEmpty((Object)inMessage.getHeader(ACCEPT)) && ObjectHelper.isNotEmpty((Object)consumes)) {
            inMessage.setHeader(ACCEPT, (Object)consumes);
        }
    }

    private String resolveHeaderPlaceholders(String str, Message msg) {
        int startIndex = -1;
        String res = str;
        while ((startIndex = res.indexOf(123, startIndex + 1)) >= 0) {
            String key;
            String headerValue;
            int endIndex = res.indexOf(125, startIndex);
            if (endIndex == -1 || (headerValue = (String)msg.getHeader(key = res.substring(startIndex + 1, endIndex), String.class)) == null) continue;
            res = res.substring(0, startIndex) + headerValue + res.substring(endIndex + 1);
        }
        return res;
    }

    protected void doInit() throws Exception {
        super.doInit();
        this.binding = this.createBindingProcessor();
    }

    protected void doStart() throws Exception {
        super.doStart();
        ServiceHelper.startService((Object[])new Object[]{this.binding, this.producer});
    }

    protected void doStop() throws Exception {
        super.doStop();
        ServiceHelper.stopService((Object[])new Object[]{this.producer, this.binding});
    }

    protected AsyncProcessor createBindingProcessor() throws Exception {
        String mode = this.configuration.getBindingMode().name();
        if (this.bindingMode != null) {
            mode = this.bindingMode.name();
        }
        boolean skip = this.configuration.isSkipBindingOnErrorCode();
        if (this.skipBindingOnErrorCode != null) {
            skip = this.skipBindingOnErrorCode;
        }
        if ("off".equals(mode)) {
            return null;
        }
        String name = this.configuration.getJsonDataFormat();
        if (name != null) {
            Object instance = this.camelContext.getRegistry().lookupByName(name);
            if (instance != null) {
                throw new IllegalArgumentException("JsonDataFormat name: " + name + " must not be an existing bean instance from the registry");
            }
        } else {
            name = "json-jackson";
        }
        DataFormat json = this.camelContext.createDataFormat(name);
        DataFormat outJson = this.camelContext.createDataFormat(name);
        if (mode.contains("json") && json == null) {
            throw new IllegalArgumentException("JSON DataFormat " + name + " not found.");
        }
        if (json != null) {
            String typeName;
            PropertyConfigurer configurer = ((ExtendedCamelContext)this.camelContext.adapt(ExtendedCamelContext.class)).getConfigurerResolver().resolvePropertyConfigurer(name + "-dataformat-configurer", this.camelContext);
            if (configurer == null) {
                throw new IllegalStateException("Cannot find configurer for dataformat: " + name);
            }
            PropertyBindingSupport.Builder builder = PropertyBindingSupport.build().withCamelContext(this.camelContext).withConfigurer(configurer).withTarget((Object)json);
            if (this.type != null) {
                typeName = this.type.endsWith("[]") ? this.type.substring(0, this.type.length() - 2) : this.type;
                builder.withProperty("unmarshalType", (Object)typeName);
                builder.withProperty("useList", (Object)this.type.endsWith("[]"));
            }
            this.setAdditionalConfiguration(this.configuration, "json.in.", builder);
            builder.bind();
            builder = PropertyBindingSupport.build().withCamelContext(this.camelContext).withConfigurer(configurer).withTarget((Object)outJson);
            if (this.outType != null) {
                typeName = this.outType.endsWith("[]") ? this.outType.substring(0, this.outType.length() - 2) : this.outType;
                builder.withProperty("unmarshalType", (Object)typeName);
                builder.withProperty("useList", (Object)this.outType.endsWith("[]"));
            }
            this.setAdditionalConfiguration(this.configuration, "json.out.", builder);
            builder.bind();
        }
        if ((name = this.configuration.getXmlDataFormat()) != null) {
            Object instance = this.camelContext.getRegistry().lookupByName(name);
            if (instance != null) {
                throw new IllegalArgumentException("XmlDataFormat name: " + name + " must not be an existing bean instance from the registry");
            }
        } else {
            name = "jaxb";
        }
        DataFormat jaxb = this.camelContext.createDataFormat(name);
        DataFormat outJaxb = this.camelContext.createDataFormat(name);
        if (mode.contains("xml") && jaxb == null) {
            throw new IllegalArgumentException("XML DataFormat " + name + " not found.");
        }
        if (jaxb != null) {
            ((ExtendedCamelContext)this.camelContext.adapt(ExtendedCamelContext.class)).getRestBindingJaxbDataFormatFactory().setupJaxb(this.camelContext, this.configuration, this.type, null, this.outType, null, jaxb, outJaxb);
        }
        return new RestProducerBindingProcessor(this.producer, this.camelContext, json, jaxb, outJson, outJaxb, mode, skip, this.outType);
    }

    private void setAdditionalConfiguration(RestConfiguration config, String prefix, PropertyBindingSupport.Builder builder) {
        if (config.getDataFormatProperties() != null && !config.getDataFormatProperties().isEmpty()) {
            HashMap copy = new HashMap();
            for (Map.Entry entry : config.getDataFormatProperties().entrySet()) {
                String key = (String)entry.getKey();
                boolean known = this.isKeyKnownPrefix(key);
                String copyKey = known ? key.substring(prefix.length()) : key;
                if (known && !key.startsWith(prefix)) continue;
                copy.put(copyKey, entry.getValue());
            }
            builder.withProperties(copy);
        }
    }

    private boolean isKeyKnownPrefix(String key) {
        return key.startsWith("json.in.") || key.startsWith("json.out.") || key.startsWith("xml.in.") || key.startsWith("xml.out.");
    }

    static String createQueryParameters(String query, Message inMessage) throws URISyntaxException, UnsupportedEncodingException {
        if (query != null) {
            Map givenParams = URISupport.parseQuery((String)query);
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>(givenParams.size());
            for (Map.Entry entry : givenParams.entrySet()) {
                Object v = entry.getValue();
                if (v == null) continue;
                String a = v.toString();
                if ((a = URLDecoder.decode(a, "UTF-8")).startsWith("{") && a.endsWith("}")) {
                    Object value;
                    String key = a.substring(1, a.length() - 1);
                    boolean optional = false;
                    if (key.endsWith("?")) {
                        key = key.substring(0, key.length() - 1);
                        optional = true;
                    }
                    if ((value = inMessage.getHeader(key)) != null) {
                        params.put((String)entry.getKey(), value);
                        continue;
                    }
                    if (optional) continue;
                    params.put((String)entry.getKey(), entry.getValue());
                    continue;
                }
                params.put((String)entry.getKey(), entry.getValue());
            }
            query = URISupport.createQueryString(params);
            while (query.endsWith("&")) {
                query = query.substring(0, query.length() - 1);
            }
        }
        return query;
    }
}

