/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.rest;

import java.util.Map;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.ExchangePattern;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.NoFactoryAvailableException;
import org.apache.camel.NoSuchBeanException;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.rest.RestComponent;
import org.apache.camel.component.rest.RestProducer;
import org.apache.camel.spi.FactoryFinder;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.RestConfiguration;
import org.apache.camel.spi.RestConsumerFactory;
import org.apache.camel.spi.RestProducerFactory;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.support.RestProducerFactoryHelper;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import org.apache.camel.util.HostUtils;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriEndpoint(firstVersion="2.14.0", scheme="rest", title="REST", syntax="rest:method:path:uriTemplate", label="core,rest", lenientProperties=true)
public class RestEndpoint
extends DefaultEndpoint {
    public static final String[] DEFAULT_REST_CONSUMER_COMPONENTS = new String[]{"coap", "netty-http", "jetty", "servlet", "spark-java", "undertow"};
    public static final String[] DEFAULT_REST_PRODUCER_COMPONENTS = new String[]{"http", "netty-http", "undertow"};
    public static final String DEFAULT_API_COMPONENT_NAME = "openapi";
    public static final String RESOURCE_PATH = "META-INF/services/org/apache/camel/rest/";
    private static final Logger LOG = LoggerFactory.getLogger(RestEndpoint.class);
    @UriPath(label="common", enums="get,post,put,delete,patch,head,trace,connect,options")
    @Metadata(required=true)
    private String method;
    @UriPath(label="common")
    @Metadata(required=true)
    private String path;
    @UriPath(label="common")
    private String uriTemplate;
    @UriParam(label="common")
    private String consumes;
    @UriParam(label="common")
    private String produces;
    @UriParam(label="common")
    private String inType;
    @UriParam(label="common")
    private String outType;
    @UriParam(label="common")
    private String routeId;
    @UriParam(label="consumer")
    private String description;
    @UriParam(label="producer")
    private String apiDoc;
    @UriParam(label="producer")
    private String host;
    @UriParam(label="producer", multiValue=true)
    private String queryParameters;
    @UriParam(label="producer", enums="auto,off,json,xml,json_xml")
    private RestConfiguration.RestBindingMode bindingMode;
    @UriParam(label="producer")
    private String producerComponentName;
    @UriParam(label="consumer")
    private String consumerComponentName;
    private Map<String, Object> parameters;

    public RestEndpoint(String endpointUri, RestComponent component) {
        super(endpointUri, (Component)component);
        this.setExchangePattern(ExchangePattern.InOut);
    }

    public void configureProperties(Map<String, Object> options) {
        Object parameters = options.remove("parameters");
        if (parameters != null) {
            this.setParameters((Map)PropertyConfigurerSupport.property((CamelContext)this.getCamelContext(), Map.class, (Object)parameters));
        }
        super.configureProperties(options);
    }

    public RestComponent getComponent() {
        return (RestComponent)super.getComponent();
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getUriTemplate() {
        return this.uriTemplate;
    }

    public void setUriTemplate(String uriTemplate) {
        this.uriTemplate = uriTemplate;
    }

    public String getConsumes() {
        return this.consumes;
    }

    public void setConsumes(String consumes) {
        this.consumes = consumes;
    }

    public String getProduces() {
        return this.produces;
    }

    public void setProduces(String produces) {
        this.produces = produces;
    }

    public String getProducerComponentName() {
        return this.producerComponentName;
    }

    public void setProducerComponentName(String producerComponentName) {
        this.producerComponentName = producerComponentName;
    }

    public String getConsumerComponentName() {
        return this.consumerComponentName;
    }

    public void setConsumerComponentName(String consumerComponentName) {
        this.consumerComponentName = consumerComponentName;
    }

    public String getInType() {
        return this.inType;
    }

    public void setInType(String inType) {
        this.inType = inType;
    }

    public String getOutType() {
        return this.outType;
    }

    public void setOutType(String outType) {
        this.outType = outType;
    }

    public String getRouteId() {
        return this.routeId;
    }

    public void setRouteId(String routeId) {
        this.routeId = routeId;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, Object> parameters) {
        this.parameters = parameters;
    }

    public String getApiDoc() {
        return this.apiDoc;
    }

    public void setApiDoc(String apiDoc) {
        this.apiDoc = apiDoc;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getQueryParameters() {
        return this.queryParameters;
    }

    public void setQueryParameters(String queryParameters) {
        this.queryParameters = queryParameters;
    }

    public RestConfiguration.RestBindingMode getBindingMode() {
        return this.bindingMode;
    }

    public void setBindingMode(RestConfiguration.RestBindingMode bindingMode) {
        this.bindingMode = bindingMode;
    }

    public void setBindingMode(String bindingMode) {
        this.bindingMode = RestConfiguration.RestBindingMode.valueOf((String)bindingMode.toLowerCase());
    }

    public Producer createProducer() throws Exception {
        Set factories;
        String pname;
        if (ObjectHelper.isEmpty((Object)this.host)) {
            throw new IllegalArgumentException("Hostname must be configured on either restConfiguration or in the rest endpoint uri as a query parameter with name host, eg rest:" + this.method + ":" + this.path + "?host=someserver");
        }
        RestProducerFactory apiDocFactory = null;
        RestProducerFactory factory = null;
        if (this.apiDoc != null) {
            LOG.debug("Discovering camel-openapi-java on classpath for using api-doc: {}", (Object)this.apiDoc);
            FactoryFinder finder = null;
            try {
                finder = ((ExtendedCamelContext)this.getCamelContext().adapt(ExtendedCamelContext.class)).getFactoryFinder(RESOURCE_PATH);
                apiDocFactory = finder.newInstance(DEFAULT_API_COMPONENT_NAME, RestProducerFactory.class).orElse(null);
                if (apiDocFactory == null) {
                    throw new NoFactoryAvailableException("Cannot find camel-openapi-java on classpath");
                }
                this.parameters.put("apiDoc", this.apiDoc);
            }
            catch (NoFactoryAvailableException e) {
                try {
                    LOG.debug("Discovering camel-swagger-java on classpath as fallback for using api-doc: {}", (Object)this.apiDoc);
                    Object instance = finder.newInstance("swagger").get();
                    if (instance instanceof RestProducerFactory) {
                        apiDocFactory = (RestProducerFactory)instance;
                    }
                    this.parameters.put("apiDoc", this.apiDoc);
                }
                catch (Exception ex) {
                    throw new IllegalStateException("Cannot find camel-openapi-java neither camel-swagger-java on classpath to use with api-doc: " + this.apiDoc);
                }
            }
        }
        if ((pname = this.getProducerComponentName()) != null) {
            Component comp = this.getCamelContext().getRegistry().lookupByName(pname);
            if (comp instanceof RestProducerFactory) {
                factory = (RestProducerFactory)comp;
            } else {
                comp = RestProducerFactoryHelper.setupComponent((String)this.getProducerComponentName(), (CamelContext)this.getCamelContext(), (Map)((Map)this.parameters.get("component")));
                if (comp instanceof RestProducerFactory) {
                    factory = (RestProducerFactory)comp;
                }
            }
            if (factory == null) {
                if (comp != null) {
                    throw new IllegalArgumentException("Component " + pname + " is not a RestProducerFactory");
                }
                throw new NoSuchBeanException(this.getProducerComponentName(), RestProducerFactory.class.getName());
            }
        }
        if (factory == null) {
            for (String name : this.getCamelContext().getComponentNames()) {
                Component comp = RestProducerFactoryHelper.setupComponent((String)name, (CamelContext)this.getCamelContext(), (Map)((Map)this.parameters.get("component")));
                if (!(comp instanceof RestProducerFactory)) continue;
                factory = (RestProducerFactory)comp;
                pname = name;
                break;
            }
        }
        if (pname == null && this.getConsumerComponentName() != null) {
            String cname = this.getConsumerComponentName();
            Object comp = this.getCamelContext().getRegistry().lookupByName(cname);
            if (comp instanceof RestProducerFactory) {
                factory = (RestProducerFactory)comp;
                pname = cname;
            } else {
                comp = RestProducerFactoryHelper.setupComponent((String)cname, (CamelContext)this.getCamelContext(), (Map)((Map)this.parameters.get("component")));
                if (comp instanceof RestProducerFactory) {
                    factory = (RestProducerFactory)comp;
                    pname = cname;
                }
            }
        }
        if (factory == null && (factories = this.getCamelContext().getRegistry().findByType(RestProducerFactory.class)) != null && factories.size() == 1) {
            factory = (RestProducerFactory)factories.iterator().next();
        }
        if (factory == null) {
            RestProducerFactory found = null;
            Component foundName = null;
            for (Component name : DEFAULT_REST_PRODUCER_COMPONENTS) {
                Component comp = RestProducerFactoryHelper.setupComponent((String)name, (CamelContext)this.getCamelContext(), (Map)((Map)this.parameters.get("component")));
                if (!(comp instanceof RestProducerFactory)) continue;
                if (found == null) {
                    found = (RestProducerFactory)comp;
                    foundName = name;
                    continue;
                }
                throw new IllegalArgumentException("Multiple RestProducerFactory found on classpath. Configure explicit which component to use");
            }
            if (found != null) {
                LOG.debug("Auto discovered {} as RestProducerFactory", foundName);
                factory = found;
            }
        }
        if (factory != null) {
            Producer producer;
            LOG.debug("Using RestProducerFactory: {}", (Object)factory);
            RestConfiguration config = CamelContextHelper.getRestConfiguration((CamelContext)this.getCamelContext(), null, (String)pname);
            if (apiDocFactory != null) {
                this.parameters.put("restProducerFactory", factory);
                producer = apiDocFactory.createProducer(this.getCamelContext(), this.host, this.method, this.path, this.uriTemplate, this.queryParameters, this.consumes, this.produces, config, this.parameters);
            } else {
                producer = factory.createProducer(this.getCamelContext(), this.host, this.method, this.path, this.uriTemplate, this.queryParameters, this.consumes, this.produces, config, this.parameters);
            }
            RestProducer answer = new RestProducer((Endpoint)this, producer, config);
            answer.setOutType(this.outType);
            answer.setType(this.inType);
            answer.setBindingMode(this.bindingMode);
            return answer;
        }
        throw new IllegalStateException("Cannot find RestProducerFactory in Registry or as a Component to use");
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        Set factories;
        RestConsumerFactory factory = null;
        String cname = null;
        if (this.getConsumerComponentName() != null) {
            Component comp = this.getCamelContext().getRegistry().lookupByName(this.getConsumerComponentName());
            if (comp instanceof RestConsumerFactory) {
                factory = (RestConsumerFactory)comp;
            } else {
                comp = this.getCamelContext().getComponent(this.getConsumerComponentName());
                if (comp instanceof RestConsumerFactory) {
                    factory = (RestConsumerFactory)comp;
                }
            }
            if (factory == null) {
                if (comp != null) {
                    throw new IllegalArgumentException("Component " + this.getConsumerComponentName() + " is not a RestConsumerFactory");
                }
                throw new NoSuchBeanException(this.getConsumerComponentName(), RestConsumerFactory.class.getName());
            }
            cname = this.getConsumerComponentName();
        }
        if (factory == null) {
            for (String name : this.getCamelContext().getComponentNames()) {
                Component comp = this.getCamelContext().getComponent(name);
                if (!(comp instanceof RestConsumerFactory)) continue;
                factory = (RestConsumerFactory)comp;
                cname = name;
                break;
            }
        }
        if (factory == null && (factories = this.getCamelContext().getRegistry().findByType(RestConsumerFactory.class)) != null && factories.size() == 1) {
            factory = (RestConsumerFactory)factories.iterator().next();
        }
        if (factory == null) {
            RestConsumerFactory found = null;
            Component foundName = null;
            for (Component name : DEFAULT_REST_CONSUMER_COMPONENTS) {
                Component comp = this.getCamelContext().getComponent((String)name, true);
                if (!(comp instanceof RestConsumerFactory)) continue;
                if (found == null) {
                    found = (RestConsumerFactory)comp;
                    foundName = name;
                    continue;
                }
                throw new IllegalArgumentException("Multiple RestConsumerFactory found on classpath. Configure explicit which component to use");
            }
            if (found != null) {
                LOG.debug("Auto discovered {} as RestConsumerFactory", foundName);
                factory = found;
            }
        }
        if (factory != null) {
            String baseUrl;
            String contextPath;
            String path;
            int num;
            String scheme = "http";
            String host = "";
            int port = 80;
            RestConfiguration config = CamelContextHelper.getRestConfiguration((CamelContext)this.getCamelContext(), cname);
            if (config.getScheme() != null) {
                scheme = config.getScheme();
            }
            if (config.getHost() != null) {
                host = config.getHost();
            }
            if ((num = config.getPort()) > 0) {
                port = num;
            }
            if (ObjectHelper.isEmpty((Object)host)) {
                if (config.getHostNameResolver() == RestConfiguration.RestHostNameResolver.allLocalIp) {
                    host = "0.0.0.0";
                } else if (config.getHostNameResolver() == RestConfiguration.RestHostNameResolver.localHostName) {
                    host = HostUtils.getLocalHostName();
                } else if (config.getHostNameResolver() == RestConfiguration.RestHostNameResolver.localIp) {
                    host = HostUtils.getLocalIp();
                }
            }
            if (!(path = this.getPath()).startsWith("/")) {
                path = "/" + path;
            }
            if ((contextPath = config.getContextPath()) != null) {
                path = !contextPath.startsWith("/") ? "/" + contextPath + path : contextPath + path;
            }
            String url = baseUrl = scheme + "://" + host + (port != 80 ? ":" + port : "") + path;
            if (this.uriTemplate != null) {
                url = this.uriTemplate.startsWith("/") ? url + this.uriTemplate : url + "/" + this.uriTemplate;
            }
            Consumer consumer = factory.createConsumer(this.getCamelContext(), processor, this.getMethod(), this.getPath(), this.getUriTemplate(), this.getConsumes(), this.getProduces(), config, this.getParameters());
            this.configureConsumer(consumer);
            this.getCamelContext().getRestRegistry().addRestService(consumer, url, baseUrl, this.getPath(), this.getUriTemplate(), this.getMethod(), this.getConsumes(), this.getProduces(), this.getInType(), this.getOutType(), this.getRouteId(), this.getDescription());
            return consumer;
        }
        throw new IllegalStateException("Cannot find RestConsumerFactory in Registry or as a Component to use");
    }

    public boolean isLenientProperties() {
        return true;
    }
}

