/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.resteasy.servlet;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.camel.component.resteasy.servlet.ResteasyServletInputStreamCopier;

public class ResteasyHttpServletRequestWrapper
extends HttpServletRequestWrapper {
    private ServletInputStream inputStream;
    private BufferedReader reader;
    private ResteasyServletInputStreamCopier copier;

    public ResteasyHttpServletRequestWrapper(HttpServletRequest request) {
        super(request);
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.inputStream == null) {
            this.inputStream = this.getRequest().getInputStream();
            this.copier = new ResteasyServletInputStreamCopier((InputStream)this.inputStream);
        }
        return this.copier;
    }

    public BufferedReader getReader() throws IOException {
        if (this.inputStream != null) {
            throw new IllegalStateException("getInputStream() has already been called on this response.");
        }
        if (this.reader == null) {
            this.reader = new BufferedReader(new InputStreamReader((InputStream)((Object)this.copier), this.getRequest().getCharacterEncoding()));
        }
        return this.reader;
    }

    public byte[] getCopy() {
        if (this.copier != null) {
            return this.copier.getCopy();
        }
        return new byte[0];
    }

    public ByteArrayOutputStream getStream() {
        if (this.copier != null) {
            return this.copier.getStream();
        }
        return null;
    }
}

