/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.restlet;

import java.io.IOException;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.apache.camel.CamelContext;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.Service;
import org.apache.camel.component.restlet.MethodBasedRouter;
import org.apache.camel.component.restlet.RestletConsumer;
import org.apache.camel.component.restlet.RestletEndpoint;
import org.apache.camel.impl.HeaderFilterStrategyComponent;
import org.apache.camel.spi.RestApiConsumerFactory;
import org.apache.camel.spi.RestConfiguration;
import org.apache.camel.spi.RestConsumerFactory;
import org.apache.camel.spi.RestProducerFactory;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.HostUtils;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ServiceHelper;
import org.apache.camel.util.URISupport;
import org.apache.camel.util.UnsafeUriCharactersEncoder;
import org.apache.camel.util.jsse.SSLContextParameters;
import org.restlet.Component;
import org.restlet.Restlet;
import org.restlet.Server;
import org.restlet.data.ChallengeScheme;
import org.restlet.data.Method;
import org.restlet.data.Parameter;
import org.restlet.data.Protocol;
import org.restlet.engine.Engine;
import org.restlet.security.ChallengeAuthenticator;
import org.restlet.security.MapVerifier;
import org.restlet.security.Verifier;
import org.restlet.util.Series;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestletComponent
extends HeaderFilterStrategyComponent
implements RestConsumerFactory,
RestApiConsumerFactory,
RestProducerFactory {
    private static final Logger LOG = LoggerFactory.getLogger(RestletComponent.class);
    private static final Object LOCK = new Object();
    private final Map<String, Server> servers = new HashMap<String, Server>();
    private final Map<String, MethodBasedRouter> routers = new HashMap<String, MethodBasedRouter>();
    private final Component component;
    private Boolean controllerDaemon;
    private Integer controllerSleepTimeMs;
    private Integer inboundBufferSize;
    private Integer minThreads;
    private Integer maxThreads;
    private Integer lowThreads;
    private Integer maxConnectionsPerHost;
    private Integer maxTotalConnections;
    private Integer outboundBufferSize;
    private Integer maxQueued;
    private Boolean persistingConnections;
    private Boolean pipeliningConnections;
    private Integer threadMaxIdleTimeMs;
    private Boolean useForwardedForHeader;
    private Boolean reuseAddress;
    private boolean disableStreamCache;
    private int port;
    private Boolean synchronous;
    private List<String> enabledConverters;

    public RestletComponent() {
        this(new Component());
    }

    public RestletComponent(Component component) {
        super(RestletEndpoint.class);
        this.component = component;
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        String remainingRaw = URISupport.extractRemainderPath((URI)new URI(uri), (boolean)true);
        RestletEndpoint result = new RestletEndpoint(this, remainingRaw);
        if (this.synchronous != null) {
            result.setSynchronous(this.synchronous);
        }
        result.setDisableStreamCache(this.isDisableStreamCache());
        this.setEndpointHeaderFilterStrategy((Endpoint)result);
        this.setProperties((Object)result, parameters);
        result.updateEndpointUri();
        URI u = new URI(remainingRaw);
        String protocol = u.getScheme();
        String uriPattern = u.getRawPath();
        if (parameters.size() > 0) {
            uriPattern = uriPattern + "?" + URISupport.createQueryString(parameters);
        }
        int port = 0;
        String host = u.getHost();
        port = u.getPort() > 0 ? u.getPort() : this.port;
        result.setProtocol(protocol);
        result.setUriPattern(uriPattern);
        result.setHost(host);
        if (port > 0) {
            result.setPort(port);
        }
        return result;
    }

    protected void doStart() throws Exception {
        super.doStart();
        RestConfiguration config = this.getCamelContext().getRestConfiguration("restlet", true);
        if (config.getComponentProperties() != null && !config.getComponentProperties().isEmpty()) {
            this.setProperties((Object)this, config.getComponentProperties());
        }
        RestletComponent.cleanupConverters(this.enabledConverters);
        this.component.start();
    }

    protected void doStop() throws Exception {
        this.component.stop();
        this.servers.clear();
        super.doStop();
    }

    protected boolean useIntrospectionOnEndpoint() {
        return false;
    }

    public void connect(RestletConsumer consumer) throws Exception {
        RestletEndpoint endpoint = consumer.getEndpoint();
        this.addServerIfNecessary(endpoint);
        String offsetPath = (String)this.component.getContext().getAttributes().get("org.restlet.ext.servlet.offsetPath");
        if (endpoint.getUriPattern() != null && endpoint.getUriPattern().length() > 0) {
            this.attachUriPatternToRestlet(offsetPath, endpoint.getUriPattern(), endpoint, consumer.getRestlet());
        }
        if (endpoint.getRestletUriPatterns() != null) {
            for (String uriPattern : endpoint.getRestletUriPatterns()) {
                this.attachUriPatternToRestlet(offsetPath, uriPattern, endpoint, consumer.getRestlet());
            }
        }
    }

    public void disconnect(RestletConsumer consumer) throws Exception {
        MethodBasedRouter methodRouter;
        RestletEndpoint endpoint = consumer.getEndpoint();
        ArrayList<MethodBasedRouter> routesToRemove = new ArrayList<MethodBasedRouter>();
        String pattern = RestletComponent.decodePattern(endpoint.getUriPattern());
        if (pattern != null && !pattern.isEmpty() && (methodRouter = this.getMethodRouter(pattern, false)) != null) {
            routesToRemove.add(methodRouter);
        }
        if (endpoint.getRestletUriPatterns() != null) {
            for (String uriPattern : endpoint.getRestletUriPatterns()) {
                MethodBasedRouter methodRouter2 = this.getMethodRouter(uriPattern, false);
                if (methodRouter2 == null) continue;
                routesToRemove.add(methodRouter2);
            }
        }
        for (MethodBasedRouter router : routesToRemove) {
            if (endpoint.getRestletMethods() != null) {
                Method[] methods;
                for (Method method : methods = endpoint.getRestletMethods()) {
                    router.removeRoute(method);
                }
            } else {
                router.removeRoute(endpoint.getRestletMethod());
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Detached restlet uriPattern: {} method: {}", (Object)router.getUriPattern(), (Object)endpoint.getRestletMethod());
            }
            if (router.hasRoutes()) continue;
            this.deattachUriPatternFrimRestlet(router.getUriPattern(), endpoint, router);
            if (!router.isStopped()) {
                router.stop();
            }
            this.routers.remove(router.getUriPattern());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MethodBasedRouter getMethodRouter(String uriPattern, boolean addIfEmpty) {
        Map<String, MethodBasedRouter> map = this.routers;
        synchronized (map) {
            MethodBasedRouter result = this.routers.get(uriPattern);
            if (result == null && addIfEmpty) {
                result = new MethodBasedRouter(uriPattern);
                LOG.debug("Added method based router: {}", (Object)result);
                this.routers.put(uriPattern, result);
            }
            return result;
        }
    }

    protected Server createServer(RestletEndpoint endpoint) {
        if (endpoint.getHost() != null) {
            return new Server(this.component.getContext().createChildContext(), Protocol.valueOf((String)endpoint.getProtocol()), endpoint.getHost(), endpoint.getPort(), null);
        }
        return new Server(this.component.getContext().createChildContext(), Protocol.valueOf((String)endpoint.getProtocol()), endpoint.getPort());
    }

    protected String stringArrayToString(String[] strings) {
        StringBuffer result = new StringBuffer();
        for (String str : strings) {
            result.append(str);
            result.append(" ");
        }
        return result.toString();
    }

    protected void setupServerWithSSLContext(Series<Parameter> params, SSLContextParameters scp) throws GeneralSecurityException, IOException {
        params.add("sslContextFactory", "org.restlet.engine.ssl.DefaultSslContextFactory");
        SSLContext context = scp.createSSLContext(this.getCamelContext());
        SSLEngine engine = context.createSSLEngine();
        params.add("enabledProtocols", this.stringArrayToString(engine.getEnabledProtocols()));
        params.add("enabledCipherSuites", this.stringArrayToString(engine.getEnabledCipherSuites()));
        if (scp.getSecureSocketProtocol() != null) {
            params.add("protocol", scp.getSecureSocketProtocol());
        }
        if (scp.getServerParameters() != null && scp.getServerParameters().getClientAuthentication() != null) {
            boolean b = !scp.getServerParameters().getClientAuthentication().equals("NONE");
            params.add("needClientAuthentication", String.valueOf(b));
        }
        if (scp.getKeyManagers() != null) {
            if (scp.getKeyManagers().getAlgorithm() != null) {
                params.add("keyManagerAlgorithm", scp.getKeyManagers().getAlgorithm());
            }
            if (scp.getKeyManagers().getKeyPassword() != null) {
                params.add("keyPassword", scp.getKeyManagers().getKeyPassword());
            }
            if (scp.getKeyManagers().getKeyStore().getResource() != null) {
                params.add("keyStorePath", scp.getKeyManagers().getKeyStore().getResource());
            }
            if (scp.getKeyManagers().getKeyStore().getPassword() != null) {
                params.add("keyStorePassword", scp.getKeyManagers().getKeyStore().getPassword());
            }
            if (scp.getKeyManagers().getKeyStore().getType() != null) {
                params.add("keyStoreType", scp.getKeyManagers().getKeyStore().getType());
            }
        }
        if (scp.getTrustManagers() != null) {
            if (scp.getTrustManagers().getAlgorithm() != null) {
                params.add("trustManagerAlgorithm", scp.getKeyManagers().getAlgorithm());
            }
            if (scp.getTrustManagers().getKeyStore().getResource() != null) {
                params.add("trustStorePath", scp.getTrustManagers().getKeyStore().getResource());
            }
            if (scp.getTrustManagers().getKeyStore().getPassword() != null) {
                params.add("trustStorePassword", scp.getTrustManagers().getKeyStore().getPassword());
            }
            if (scp.getTrustManagers().getKeyStore().getType() != null) {
                params.add("trustStoreType", scp.getTrustManagers().getKeyStore().getType());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addServerIfNecessary(RestletEndpoint endpoint) throws Exception {
        String key = RestletComponent.buildKey(endpoint);
        Map<String, Server> map = this.servers;
        synchronized (map) {
            Server server = this.servers.get(key);
            if (server == null) {
                server = this.createServer(endpoint);
                this.component.getServers().add(server);
                Series params = server.getContext().getParameters();
                if ("https".equals(endpoint.getProtocol())) {
                    SSLContextParameters scp = endpoint.getSslContextParameters();
                    if (endpoint.getSslContextParameters() == null) {
                        throw new InvalidParameterException("Need to specify the SSLContextParameters option here!");
                    }
                    this.setupServerWithSSLContext((Series<Parameter>)params, scp);
                }
                if (this.getControllerDaemon() != null) {
                    params.add("controllerDaemon", this.getControllerDaemon().toString());
                }
                if (this.getControllerSleepTimeMs() != null) {
                    params.add("controllerSleepTimeMs", this.getControllerSleepTimeMs().toString());
                }
                if (this.getInboundBufferSize() != null) {
                    params.add("inboundBufferSize", this.getInboundBufferSize().toString());
                }
                if (this.getMinThreads() != null) {
                    params.add("minThreads", this.getMinThreads().toString());
                }
                if (this.getMaxThreads() != null) {
                    params.add("maxThreads", this.getMaxThreads().toString());
                }
                if (this.getLowThreads() != null) {
                    params.add("lowThreads", this.getLowThreads().toString());
                }
                if (this.getMaxQueued() != null) {
                    params.add("maxQueued", this.getMaxQueued().toString());
                }
                if (this.getMaxConnectionsPerHost() != null) {
                    params.add("maxConnectionsPerHost", this.getMaxConnectionsPerHost().toString());
                }
                if (this.getMaxTotalConnections() != null) {
                    params.add("maxTotalConnections", this.getMaxTotalConnections().toString());
                }
                if (this.getOutboundBufferSize() != null) {
                    params.add("outboundBufferSize", this.getOutboundBufferSize().toString());
                }
                if (this.getPersistingConnections() != null) {
                    params.add("persistingConnections", this.getPersistingConnections().toString());
                }
                if (this.getPipeliningConnections() != null) {
                    params.add("pipeliningConnections", this.getPipeliningConnections().toString());
                }
                if (this.getThreadMaxIdleTimeMs() != null) {
                    params.add("threadMaxIdleTimeMs", this.getThreadMaxIdleTimeMs().toString());
                }
                if (this.getUseForwardedForHeader() != null) {
                    params.add("useForwardedForHeader", this.getUseForwardedForHeader().toString());
                }
                if (this.getReuseAddress() != null) {
                    params.add("reuseAddress", this.getReuseAddress().toString());
                }
                LOG.debug("Setting parameters: {} to server: {}", (Object)params, (Object)server);
                server.getContext().setParameters(params);
                this.servers.put(key, server);
                LOG.debug("Added server: {}", (Object)key);
                server.start();
            }
        }
    }

    private static String buildKey(RestletEndpoint endpoint) {
        return endpoint.getHost() + ":" + endpoint.getPort();
    }

    private void attachUriPatternToRestlet(String offsetPath, String uriPattern, RestletEndpoint endpoint, Restlet target) throws Exception {
        uriPattern = RestletComponent.decodePattern(uriPattern);
        MethodBasedRouter router = this.getMethodRouter(uriPattern, true);
        Map<String, String> realm = endpoint.getRestletRealm();
        if (realm != null && realm.size() > 0) {
            ChallengeAuthenticator guard = new ChallengeAuthenticator(this.component.getContext().createChildContext(), ChallengeScheme.HTTP_BASIC, "Camel-Restlet Endpoint Realm");
            MapVerifier verifier = new MapVerifier();
            for (Map.Entry<String, String> entry : realm.entrySet()) {
                verifier.getLocalSecrets().put(entry.getKey(), entry.getValue().toCharArray());
            }
            guard.setVerifier((Verifier)verifier);
            guard.setNext(target);
            target = guard;
            LOG.debug("Target has been set to guard: {}", (Object)guard);
        }
        if (endpoint.getRestletMethods() != null) {
            Method[] methods;
            for (Method method : methods = endpoint.getRestletMethods()) {
                router.addRoute(method, target);
                LOG.debug("Attached restlet uriPattern: {} method: {}", (Object)uriPattern, (Object)method);
            }
        } else {
            Method method = endpoint.getRestletMethod();
            router.addRoute(method, target);
            LOG.debug("Attached restlet uriPattern: {} method: {}", (Object)uriPattern, (Object)method);
        }
        if (!router.hasBeenAttached()) {
            this.component.getDefaultHost().attach(offsetPath == null ? uriPattern : offsetPath + uriPattern, (Restlet)router);
            LOG.debug("Attached methodRouter uriPattern: {}", (Object)uriPattern);
        }
        if (!router.isStarted()) {
            router.start();
            LOG.debug("Started methodRouter uriPattern: {}", (Object)uriPattern);
        }
    }

    private void deattachUriPatternFrimRestlet(String uriPattern, RestletEndpoint endpoint, Restlet target) throws Exception {
        this.component.getDefaultHost().detach(target);
        LOG.debug("Deattached methodRouter uriPattern: {}", (Object)uriPattern);
    }

    @Deprecated
    protected String preProcessUri(String uri) {
        return UnsafeUriCharactersEncoder.encode((String)uri.replaceAll("%7B", "(").replaceAll("%7D", ")"));
    }

    private static String decodePattern(String pattern) {
        return pattern == null ? null : pattern.replaceAll("\\(", "{").replaceAll("\\)", "}");
    }

    public Boolean getControllerDaemon() {
        return this.controllerDaemon;
    }

    public void setControllerDaemon(Boolean controllerDaemon) {
        this.controllerDaemon = controllerDaemon;
    }

    public Integer getControllerSleepTimeMs() {
        return this.controllerSleepTimeMs;
    }

    public void setControllerSleepTimeMs(Integer controllerSleepTimeMs) {
        this.controllerSleepTimeMs = controllerSleepTimeMs;
    }

    public Integer getInboundBufferSize() {
        return this.inboundBufferSize;
    }

    public void setInboundBufferSize(Integer inboundBufferSize) {
        this.inboundBufferSize = inboundBufferSize;
    }

    public Integer getMaxConnectionsPerHost() {
        return this.maxConnectionsPerHost;
    }

    public void setMaxConnectionsPerHost(Integer maxConnectionsPerHost) {
        this.maxConnectionsPerHost = maxConnectionsPerHost;
    }

    public Integer getMaxThreads() {
        return this.maxThreads;
    }

    public void setMaxThreads(Integer maxThreads) {
        this.maxThreads = maxThreads;
    }

    public Integer getLowThreads() {
        return this.lowThreads;
    }

    public void setLowThreads(Integer lowThreads) {
        this.lowThreads = lowThreads;
    }

    public Integer getMaxTotalConnections() {
        return this.maxTotalConnections;
    }

    public void setMaxTotalConnections(Integer maxTotalConnections) {
        this.maxTotalConnections = maxTotalConnections;
    }

    public Integer getMinThreads() {
        return this.minThreads;
    }

    public void setMinThreads(Integer minThreads) {
        this.minThreads = minThreads;
    }

    public Integer getOutboundBufferSize() {
        return this.outboundBufferSize;
    }

    public void setOutboundBufferSize(Integer outboundBufferSize) {
        this.outboundBufferSize = outboundBufferSize;
    }

    public Boolean getPersistingConnections() {
        return this.persistingConnections;
    }

    public void setPersistingConnections(Boolean persistingConnections) {
        this.persistingConnections = persistingConnections;
    }

    public Boolean getPipeliningConnections() {
        return this.pipeliningConnections;
    }

    public void setPipeliningConnections(Boolean pipeliningConnections) {
        this.pipeliningConnections = pipeliningConnections;
    }

    public Integer getThreadMaxIdleTimeMs() {
        return this.threadMaxIdleTimeMs;
    }

    public void setThreadMaxIdleTimeMs(Integer threadMaxIdleTimeMs) {
        this.threadMaxIdleTimeMs = threadMaxIdleTimeMs;
    }

    public Boolean getUseForwardedForHeader() {
        return this.useForwardedForHeader;
    }

    public void setUseForwardedForHeader(Boolean useForwardedForHeader) {
        this.useForwardedForHeader = useForwardedForHeader;
    }

    public Boolean getReuseAddress() {
        return this.reuseAddress;
    }

    public void setReuseAddress(Boolean reuseAddress) {
        this.reuseAddress = reuseAddress;
    }

    public Integer getMaxQueued() {
        return this.maxQueued;
    }

    public void setMaxQueued(Integer maxQueued) {
        this.maxQueued = maxQueued;
    }

    public boolean isDisableStreamCache() {
        return this.disableStreamCache;
    }

    public void setDisableStreamCache(boolean disableStreamCache) {
        this.disableStreamCache = disableStreamCache;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public Boolean getSynchronous() {
        return this.synchronous;
    }

    public void setSynchronous(Boolean synchronous) {
        this.synchronous = synchronous;
    }

    public List<String> getEnabledConverters() {
        return this.enabledConverters;
    }

    public void setEnabledConverters(List<String> enabledConverters) {
        if (enabledConverters != null && !enabledConverters.isEmpty()) {
            this.enabledConverters = new ArrayList<String>(enabledConverters);
        }
    }

    public void setEnabledConverters(String enabledConverters) {
        if (ObjectHelper.isNotEmpty((Object)enabledConverters)) {
            this.enabledConverters = Arrays.asList(enabledConverters.split(","));
        }
    }

    public Consumer createConsumer(CamelContext camelContext, Processor processor, String verb, String basePath, String uriTemplate, String consumes, String produces, RestConfiguration configuration, Map<String, Object> parameters) throws Exception {
        String url;
        String contextPath;
        int num;
        String path = basePath;
        if (uriTemplate != null) {
            path = uriTemplate.startsWith("/") ? path + uriTemplate : path + "/" + uriTemplate;
        }
        path = FileUtil.stripLeadingSeparator((String)path);
        String scheme = "http";
        String host = "";
        int port = this.getPort();
        RestConfiguration config = configuration;
        if (config == null) {
            config = camelContext.getRestConfiguration("restlet", true);
        }
        if (config.getScheme() != null) {
            scheme = config.getScheme();
        }
        if (config.getHost() != null) {
            host = config.getHost();
        }
        if ((num = config.getPort()) > 0) {
            port = num;
        }
        if (ObjectHelper.isNotEmpty((Object)(contextPath = config.getContextPath()))) {
            contextPath = FileUtil.stripTrailingSeparator((String)contextPath);
            if (ObjectHelper.isNotEmpty((Object)(contextPath = FileUtil.stripLeadingSeparator((String)contextPath)))) {
                path = contextPath + "/" + path;
            }
        }
        if (ObjectHelper.isEmpty((Object)host)) {
            if (config.getRestHostNameResolver() == RestConfiguration.RestHostNameResolver.allLocalIp) {
                host = "0.0.0.0";
            } else if (config.getRestHostNameResolver() == RestConfiguration.RestHostNameResolver.localHostName) {
                host = HostUtils.getLocalHostName();
            } else if (config.getRestHostNameResolver() == RestConfiguration.RestHostNameResolver.localIp) {
                host = HostUtils.getLocalIp();
            }
        }
        HashMap map = new HashMap();
        if ((config.getComponent() == null || config.getComponent().equals("restlet")) && config.getEndpointProperties() != null && !config.getEndpointProperties().isEmpty()) {
            map.putAll(config.getEndpointProperties());
        }
        boolean cors = config.isEnableCORS();
        String query = URISupport.createQueryString(map);
        String restrict = verb.toUpperCase(Locale.US);
        if (cors) {
            restrict = restrict + ",OPTIONS";
        }
        if (port > 0) {
            url = "restlet:%s://%s:%s/%s?restletMethods=%s";
            url = String.format(url, scheme, host, port, path, restrict);
        } else {
            url = "restlet:/%s?restletMethods=%s";
            url = String.format(url, path, restrict);
        }
        if (!query.isEmpty()) {
            url = url + "&" + query;
        }
        RestletEndpoint endpoint = (RestletEndpoint)camelContext.getEndpoint(url, RestletEndpoint.class);
        this.setProperties(camelContext, (Object)endpoint, parameters);
        Consumer consumer = endpoint.createConsumer(processor);
        if (config.getConsumerProperties() != null && !config.getConsumerProperties().isEmpty()) {
            this.setProperties(camelContext, consumer, config.getConsumerProperties());
        }
        return consumer;
    }

    public Consumer createApiConsumer(CamelContext camelContext, Processor processor, String contextPath, RestConfiguration configuration, Map<String, Object> parameters) throws Exception {
        return this.createConsumer(camelContext, processor, "GET", contextPath, null, null, null, configuration, parameters);
    }

    public Producer createProducer(CamelContext camelContext, String host, String verb, String basePath, String uriTemplate, String queryParameters, String consumes, String produces, Map<String, Object> parameters) throws Exception {
        basePath = FileUtil.stripLeadingSeparator((String)basePath);
        uriTemplate = FileUtil.stripLeadingSeparator((String)uriTemplate);
        String restletMethod = verb.toUpperCase(Locale.US);
        String url = uriTemplate != null ? String.format("restlet:%s/%s/%s?restletMethods=%s", host, basePath, uriTemplate, restletMethod) : String.format("restlet:%s/%s?restletMethods=%s", host, basePath, restletMethod);
        RestletEndpoint endpoint = (RestletEndpoint)camelContext.getEndpoint(url, RestletEndpoint.class);
        if (parameters != null && !parameters.isEmpty()) {
            this.setProperties(camelContext, (Object)endpoint, parameters);
        }
        ServiceHelper.startService((Service)endpoint);
        return endpoint.createProducer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void cleanupConverters(List<String> converters) {
        if (converters != null && !converters.isEmpty()) {
            Object object = LOCK;
            synchronized (object) {
                Engine.getInstance().getRegisteredConverters().removeIf(converter -> !converters.contains(converter.getClass().getName()) && !converters.contains(converter.getClass().getSimpleName()));
            }
        }
    }
}

