/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.restlet;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.InvalidParameterException;
import java.util.Arrays;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.apache.camel.component.restlet.RestletEndpoint;
import org.apache.camel.component.restlet.RestletHost;
import org.apache.camel.component.restlet.RestletHostOptions;
import org.apache.camel.util.jsse.SSLContextParameters;
import org.restlet.Component;
import org.restlet.Server;
import org.restlet.data.Parameter;
import org.restlet.data.Protocol;
import org.restlet.util.Series;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultRestletHost
implements RestletHost {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultRestletHost.class);
    private final RestletHostOptions resletHostOptions;
    private Server server;

    public DefaultRestletHost(RestletHostOptions restletHostOptions) {
        this.resletHostOptions = restletHostOptions;
    }

    @Override
    public void configure(RestletEndpoint endpoint, Component component) {
        this.server = this.createServer(endpoint, component);
        component.getServers().add(this.server);
        Series params = this.server.getContext().getParameters();
        if ("https".equals(endpoint.getProtocol())) {
            SSLContextParameters scp = endpoint.getSslContextParameters();
            if (endpoint.getSslContextParameters() == null) {
                throw new InvalidParameterException("Need to specify the SSLContextParameters option here!");
            }
            try {
                this.setupServerWithSSLContext(endpoint, (Series<Parameter>)params, scp);
            }
            catch (Exception e) {
                throw new IllegalStateException("Error configuring Restlet server SSL context", e);
            }
        }
        if (this.resletHostOptions.getControllerDaemon() != null) {
            params.add("controllerDaemon", this.resletHostOptions.getControllerDaemon().toString());
        }
        if (this.resletHostOptions.getControllerSleepTimeMs() != null) {
            params.add("controllerSleepTimeMs", this.resletHostOptions.getControllerSleepTimeMs().toString());
        }
        if (this.resletHostOptions.getInboundBufferSize() != null) {
            params.add("inboundBufferSize", this.resletHostOptions.getInboundBufferSize().toString());
        }
        if (this.resletHostOptions.getMaxConnectionsPerHost() != null) {
            params.add("maxConnectionsPerHost", this.resletHostOptions.getMaxConnectionsPerHost().toString());
        }
        if (this.resletHostOptions.getMaxQueued() != null) {
            params.add("maxQueued", this.resletHostOptions.getMaxQueued().toString());
        }
        if (this.resletHostOptions.getMaxThreads() != null) {
            params.add("maxThreads", this.resletHostOptions.getMaxThreads().toString());
        }
        if (this.resletHostOptions.getMaxTotalConnections() != null) {
            params.add("maxTotalConnections", this.resletHostOptions.getMaxTotalConnections().toString());
        }
        if (this.resletHostOptions.getMinThreads() != null) {
            params.add("minThreads", this.resletHostOptions.getMinThreads().toString());
        }
        if (this.resletHostOptions.getLowThreads() != null) {
            params.add("lowThreads", this.resletHostOptions.getLowThreads().toString());
        }
        if (this.resletHostOptions.getOutboundBufferSize() != null) {
            params.add("outboundBufferSize", this.resletHostOptions.getOutboundBufferSize().toString());
        }
        if (this.resletHostOptions.getPersistingConnections() != null) {
            params.add("persistingConnections", this.resletHostOptions.getPersistingConnections().toString());
        }
        if (this.resletHostOptions.getPipeliningConnections() != null) {
            params.add("pipeliningConnections", this.resletHostOptions.getPipeliningConnections().toString());
        }
        if (this.resletHostOptions.getThreadMaxIdleTimeMs() != null) {
            params.add("threadMaxIdleTimeMs", this.resletHostOptions.getThreadMaxIdleTimeMs().toString());
        }
        if (this.resletHostOptions.getUseForwardedForHeader() != null) {
            params.add("useForwardedForHeader", this.resletHostOptions.getUseForwardedForHeader().toString());
        }
        if (this.resletHostOptions.getReuseAddress() != null) {
            params.add("reuseAddress", this.resletHostOptions.getReuseAddress().toString());
        }
        LOG.debug("Setting parameters: {} to server: {}", (Object)params, (Object)this.server);
        this.server.getContext().setParameters(params);
    }

    @Override
    public void start() throws Exception {
        this.server.start();
    }

    @Override
    public void stop() throws Exception {
        this.server.stop();
    }

    private Server createServer(RestletEndpoint endpoint, Component component) {
        if (endpoint.getHost() != null) {
            return new Server(component.getContext().createChildContext(), Protocol.valueOf((String)endpoint.getProtocol()), endpoint.getHost(), endpoint.getPort(), null);
        }
        return new Server(component.getContext().createChildContext(), Protocol.valueOf((String)endpoint.getProtocol()), endpoint.getPort());
    }

    private void setupServerWithSSLContext(RestletEndpoint endpoint, Series<Parameter> params, SSLContextParameters scp) throws GeneralSecurityException, IOException {
        params.add("sslContextFactory", "org.restlet.engine.ssl.DefaultSslContextFactory");
        SSLContext context = scp.createSSLContext(endpoint.getCamelContext());
        SSLEngine engine = context.createSSLEngine();
        params.add("enabledProtocols", String.join((CharSequence)" ", Arrays.asList(engine.getEnabledProtocols())));
        params.add("enabledCipherSuites", String.join((CharSequence)" ", Arrays.asList(engine.getEnabledCipherSuites())));
        if (scp.getSecureSocketProtocol() != null) {
            params.add("protocol", scp.getSecureSocketProtocol());
        }
        if (scp.getServerParameters() != null && scp.getServerParameters().getClientAuthentication() != null) {
            boolean b = !scp.getServerParameters().getClientAuthentication().equals("NONE");
            params.add("needClientAuthentication", String.valueOf(b));
        }
        if (scp.getKeyManagers() != null) {
            if (scp.getKeyManagers().getAlgorithm() != null) {
                params.add("keyManagerAlgorithm", scp.getKeyManagers().getAlgorithm());
            }
            if (scp.getKeyManagers().getKeyPassword() != null) {
                params.add("keyPassword", scp.getKeyManagers().getKeyPassword());
            }
            if (scp.getKeyManagers().getKeyStore().getResource() != null) {
                params.add("keyStorePath", scp.getKeyManagers().getKeyStore().getResource());
            }
            if (scp.getKeyManagers().getKeyStore().getPassword() != null) {
                params.add("keyStorePassword", scp.getKeyManagers().getKeyStore().getPassword());
            }
            if (scp.getKeyManagers().getKeyStore().getType() != null) {
                params.add("keyStoreType", scp.getKeyManagers().getKeyStore().getType());
            }
        }
        if (scp.getTrustManagers() != null) {
            if (scp.getTrustManagers().getAlgorithm() != null) {
                params.add("trustManagerAlgorithm", scp.getKeyManagers().getAlgorithm());
            }
            if (scp.getTrustManagers().getKeyStore().getResource() != null) {
                params.add("trustStorePath", scp.getTrustManagers().getKeyStore().getResource());
            }
            if (scp.getTrustManagers().getKeyStore().getPassword() != null) {
                params.add("trustStorePassword", scp.getTrustManagers().getKeyStore().getPassword());
            }
            if (scp.getTrustManagers().getKeyStore().getType() != null) {
                params.add("trustStoreType", scp.getTrustManagers().getKeyStore().getType());
            }
        }
    }
}

