/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.restlet;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.restlet.RestletBinding;
import org.apache.camel.component.restlet.RestletEndpoint;
import org.apache.camel.support.DefaultConsumer;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.Restlet;
import org.restlet.Uniform;

public class RestletConsumer
extends DefaultConsumer {
    private Restlet restlet;

    public RestletConsumer(Endpoint endpoint, Processor processor) throws Exception {
        super(endpoint, processor);
    }

    public RestletEndpoint getEndpoint() {
        return (RestletEndpoint)super.getEndpoint();
    }

    protected Restlet createRestlet() {
        return new Restlet(){

            public void handle(Request request, Response response) {
                block4: {
                    super.handle(request, response);
                    RestletConsumer.this.log.debug("Consumer restlet handle request method: {}", (Object)request.getMethod());
                    Exchange exchange = null;
                    try {
                        exchange = RestletConsumer.this.getEndpoint().createExchange();
                        RestletConsumer.this.createUoW(exchange);
                        RestletBinding binding = RestletConsumer.this.getEndpoint().getRestletBinding();
                        binding.populateExchangeFromRestletRequest(request, response, exchange);
                        try {
                            RestletConsumer.this.getProcessor().process(exchange);
                        }
                        catch (Exception e) {
                            exchange.setException((Throwable)e);
                        }
                        binding.populateRestletResponseFromExchange(exchange, response);
                        Uniform callback = RestletConsumer.this.newResponseUniform(exchange);
                        response.setOnError(callback);
                        response.setOnSent(callback);
                    }
                    catch (Throwable e) {
                        RestletConsumer.this.getExceptionHandler().handleException("Error processing request", exchange, e);
                        if (exchange == null) break block4;
                        RestletConsumer.this.doneUoW(exchange);
                    }
                }
            }
        };
    }

    private Uniform newResponseUniform(final Exchange exchange) {
        return new Uniform(){

            public void handle(Request request, Response response) {
                if (exchange != null) {
                    RestletConsumer.this.doneUoW(exchange);
                }
            }
        };
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.restlet = this.createRestlet();
        this.getEndpoint().connect(this);
        this.restlet.start();
    }

    public void doStop() throws Exception {
        this.getEndpoint().disconnect(this);
        if (this.restlet != null) {
            this.restlet.stop();
        }
        super.doStop();
    }

    public Restlet getRestlet() {
        return this.restlet;
    }
}

