/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ribbon.processor;

import com.netflix.loadbalancer.IRule;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Processor;
import org.apache.camel.component.ribbon.RibbonConfiguration;
import org.apache.camel.component.ribbon.processor.RibbonServer;
import org.apache.camel.component.ribbon.processor.RibbonServiceCallProcessor;
import org.apache.camel.impl.remote.DefaultServiceCallProcessorFactory;
import org.apache.camel.model.remote.RibbonConfigurationDefinition;
import org.apache.camel.model.remote.ServiceCallConfigurationDefinition;
import org.apache.camel.model.remote.ServiceCallDefinition;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.spi.ServiceCallServerListStrategy;
import org.apache.camel.util.CamelContextHelper;
import org.apache.camel.util.IntrospectionSupport;

public class RibbonProcessorFactory
extends DefaultServiceCallProcessorFactory<RibbonConfiguration, RibbonServer> {
    protected Processor createProcessor(RouteContext routeContext, ServiceCallDefinition definition, RibbonConfiguration cfg) throws Exception {
        String component;
        ServiceCallServerListStrategy sl;
        Set set;
        String name = definition.getName();
        String uri = definition.getUri();
        ExchangePattern mep = definition.getPattern();
        RibbonConfigurationDefinition config = (RibbonConfigurationDefinition)definition.getServiceCallConfiguration();
        RibbonConfigurationDefinition configRef = null;
        if (definition.getServiceCallConfigurationRef() != null && (configRef = (RibbonConfigurationDefinition)CamelContextHelper.lookup((CamelContext)routeContext.getCamelContext(), (String)definition.getServiceCallConfigurationRef(), RibbonConfigurationDefinition.class)) == null) {
            routeContext.getCamelContext().getServiceCallConfiguration(definition.getServiceCallConfigurationRef(), RibbonConfigurationDefinition.class);
        }
        if (config == null && configRef == null) {
            config = (RibbonConfigurationDefinition)routeContext.getCamelContext().getServiceCallConfiguration(null, RibbonConfigurationDefinition.class);
        }
        if (config == null && (set = routeContext.getCamelContext().getRegistry().findByType(RibbonConfigurationDefinition.class)).size() == 1) {
            config = (RibbonConfigurationDefinition)set.iterator().next();
        }
        if (config == null && configRef == null) {
            throw new IllegalStateException("The ServiceCall: " + definition + " must be configured before it can be used.");
        }
        HashMap parameters = new HashMap();
        if (configRef != null) {
            IntrospectionSupport.getProperties((Object)configRef, parameters, null);
        }
        if (config != null) {
            IntrospectionSupport.getProperties((Object)config, parameters, null);
        }
        IntrospectionSupport.setProperties((Object)cfg, parameters);
        Object lb = this.configureLoadBalancer(routeContext, definition);
        if (lb == null && config != null) {
            lb = this.configureLoadBalancer(routeContext, (ServiceCallConfigurationDefinition)config);
        }
        if (lb == null && configRef != null) {
            lb = this.configureLoadBalancer(routeContext, (ServiceCallConfigurationDefinition)configRef);
        }
        if ((sl = this.configureServerListStrategy(routeContext, definition)) == null && config != null) {
            sl = this.configureServerListStrategy(routeContext, (ServiceCallConfigurationDefinition)config);
        }
        if (sl == null && configRef != null) {
            sl = this.configureServerListStrategy(routeContext, (ServiceCallConfigurationDefinition)configRef);
        }
        if (lb != null && !(lb instanceof IRule)) {
            throw new IllegalArgumentException("Load balancer must be of type: " + IRule.class + " but is of type: " + lb.getClass().getName());
        }
        String string = component = config != null ? config.getComponent() : null;
        if (component == null && configRef != null) {
            component = configRef.getComponent();
        }
        Map properties = this.configureProperties(routeContext, (ServiceCallConfigurationDefinition)config, (ServiceCallConfigurationDefinition)configRef);
        RibbonServiceCallProcessor processor = new RibbonServiceCallProcessor(name, uri, component, mep, cfg);
        processor.setRule((IRule)lb);
        processor.setServerListStrategy(sl);
        processor.setRibbonClientConfig(properties);
        return processor;
    }

    protected RibbonConfiguration createConfiguration(RouteContext routeContext) throws Exception {
        return new RibbonConfiguration();
    }

    private Object configureLoadBalancer(RouteContext routeContext, ServiceCallDefinition sd) {
        Object lb = null;
        if (sd != null && (lb = sd.getLoadBalancer()) == null && sd.getLoadBalancerRef() != null) {
            String ref = sd.getLoadBalancerRef();
            lb = CamelContextHelper.mandatoryLookup((CamelContext)routeContext.getCamelContext(), (String)ref);
        }
        return lb;
    }

    private Object configureLoadBalancer(RouteContext routeContext, ServiceCallConfigurationDefinition config) {
        Object lb = config.getLoadBalancer();
        if (lb == null && config.getLoadBalancerRef() != null) {
            String ref = config.getLoadBalancerRef();
            lb = CamelContextHelper.mandatoryLookup((CamelContext)routeContext.getCamelContext(), (String)ref);
        }
        return lb;
    }

    private ServiceCallServerListStrategy configureServerListStrategy(RouteContext routeContext, ServiceCallDefinition sd) {
        ServiceCallServerListStrategy lb = null;
        if (sd != null && (lb = sd.getServerListStrategy()) == null && sd.getServerListStrategyRef() != null) {
            lb = (ServiceCallServerListStrategy)CamelContextHelper.mandatoryLookup((CamelContext)routeContext.getCamelContext(), (String)sd.getServerListStrategyRef(), ServiceCallServerListStrategy.class);
        }
        return lb;
    }

    private ServiceCallServerListStrategy configureServerListStrategy(RouteContext routeContext, ServiceCallConfigurationDefinition config) {
        ServiceCallServerListStrategy lb = config.getServerListStrategy();
        if (lb == null && config.getServerListStrategyRef() != null) {
            String ref = config.getServerListStrategyRef();
            lb = (ServiceCallServerListStrategy)CamelContextHelper.mandatoryLookup((CamelContext)routeContext.getCamelContext(), (String)ref, ServiceCallServerListStrategy.class);
        }
        return lb;
    }
}

