/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ribbon.processor;

import com.netflix.client.config.IClientConfig;
import com.netflix.loadbalancer.AbstractServerList;
import com.netflix.loadbalancer.ServerList;
import java.util.ArrayList;
import java.util.List;
import org.apache.camel.component.ribbon.processor.RibbonServer;
import org.apache.camel.spi.ServiceCallServerListStrategy;
import org.apache.camel.util.ObjectHelper;

public class RibbonServiceCallStaticServerListStrategy
extends AbstractServerList<RibbonServer>
implements ServerList<RibbonServer>,
ServiceCallServerListStrategy<RibbonServer> {
    private IClientConfig clientConfig;
    private final List<RibbonServer> servers = new ArrayList<RibbonServer>();

    public RibbonServiceCallStaticServerListStrategy() {
    }

    public RibbonServiceCallStaticServerListStrategy(List<RibbonServer> servers) {
        this.servers.addAll(servers);
    }

    public static RibbonServiceCallStaticServerListStrategy build(String servers) {
        String[] parts;
        RibbonServiceCallStaticServerListStrategy answer = new RibbonServiceCallStaticServerListStrategy();
        for (String part : parts = servers.split(",")) {
            String host = ObjectHelper.before((String)part, (String)":");
            String port = ObjectHelper.after((String)part, (String)":");
            int num = Integer.valueOf(port);
            answer.addServer(host, num);
        }
        return answer;
    }

    public void addServer(RibbonServer server) {
        this.servers.add(server);
    }

    public void addServer(String host, int port) {
        this.servers.add(new RibbonServer(host, port));
    }

    public void removeServer(String host, int port) {
        this.servers.remove((Object)new RibbonServer(host, port));
    }

    public void initWithNiwsConfig(IClientConfig clientConfig) {
        this.clientConfig = clientConfig;
    }

    public List<RibbonServer> getInitialListOfServers() {
        return this.servers;
    }

    public List<RibbonServer> getUpdatedListOfServers() {
        return this.servers;
    }

    public List<RibbonServer> getInitialListOfServers(String name) {
        return this.getInitialListOfServers();
    }

    public List<RibbonServer> getUpdatedListOfServers(String name) {
        return this.getUpdatedListOfServers();
    }
}

