/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ribbon.cloud;

import com.netflix.client.config.IClientConfig;
import com.netflix.client.config.IClientConfigKey;
import com.netflix.loadbalancer.DummyPing;
import com.netflix.loadbalancer.DynamicServerListLoadBalancer;
import com.netflix.loadbalancer.ILoadBalancer;
import com.netflix.loadbalancer.PollingServerListUpdater;
import com.netflix.loadbalancer.RoundRobinRule;
import com.netflix.loadbalancer.Server;
import com.netflix.loadbalancer.ServerList;
import com.netflix.loadbalancer.ServerListUpdater;
import com.netflix.loadbalancer.ZoneAwareLoadBalancer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.RejectedExecutionException;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.cloud.ServiceDefinition;
import org.apache.camel.cloud.ServiceDiscovery;
import org.apache.camel.cloud.ServiceDiscoveryAware;
import org.apache.camel.cloud.ServiceFilter;
import org.apache.camel.cloud.ServiceFilterAware;
import org.apache.camel.cloud.ServiceLoadBalancer;
import org.apache.camel.cloud.ServiceLoadBalancerFunction;
import org.apache.camel.component.ribbon.RibbonConfiguration;
import org.apache.camel.component.ribbon.cloud.RibbonServiceDefinition;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RibbonServiceLoadBalancer
extends ServiceSupport
implements CamelContextAware,
ServiceDiscoveryAware,
ServiceFilterAware,
ServiceLoadBalancer {
    private static final Logger LOGGER = LoggerFactory.getLogger(RibbonServiceLoadBalancer.class);
    private final RibbonConfiguration configuration;
    private final ConcurrentMap<String, ZoneAwareLoadBalancer<RibbonServiceDefinition>> loadBalancers;
    private CamelContext camelContext;
    private ServiceDiscovery serviceDiscovery;
    private ServiceFilter serviceFilter;

    public RibbonServiceLoadBalancer(RibbonConfiguration configuration) {
        this.configuration = configuration;
        this.loadBalancers = new ConcurrentHashMap<String, ZoneAwareLoadBalancer<RibbonServiceDefinition>>();
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public ServiceDiscovery getServiceDiscovery() {
        return this.serviceDiscovery;
    }

    public void setServiceDiscovery(ServiceDiscovery serviceDiscovery) {
        this.serviceDiscovery = serviceDiscovery;
    }

    public ServiceFilter getServiceFilter() {
        return this.serviceFilter;
    }

    public void setServiceFilter(ServiceFilter serviceFilter) {
        this.serviceFilter = serviceFilter;
    }

    protected void doStart() throws Exception {
        ObjectHelper.notNull((Object)this.configuration, (String)"configuration");
        ObjectHelper.notNull((Object)this.camelContext, (String)"camel context");
        if (this.serviceDiscovery != null) {
            LOGGER.info("ServiceCall is using ribbon load balancer with service discovery type: {} and service filter: {}", this.serviceDiscovery.getClass(), this.serviceDiscovery != null ? this.serviceFilter.getClass() : "none");
        } else {
            LOGGER.info("ServiceCall is using ribbon load balancer");
        }
        ServiceHelper.startService((Object)this.serviceDiscovery);
    }

    protected void doStop() throws Exception {
        this.loadBalancers.values().forEach(DynamicServerListLoadBalancer::stopServerListRefreshing);
        this.loadBalancers.clear();
        ServiceHelper.stopService((Object)this.serviceDiscovery);
    }

    public <T> T process(String serviceName, ServiceLoadBalancerFunction<T> request) throws Exception {
        ServiceDefinition definition;
        ILoadBalancer loadBalancer = (ILoadBalancer)this.loadBalancers.computeIfAbsent(serviceName, key -> this.createLoadBalancer((String)key));
        Server server = loadBalancer.chooseServer((Object)serviceName);
        if (server == null) {
            throw new RejectedExecutionException("No active services with name " + serviceName);
        }
        if (server instanceof ServiceDefinition) {
            definition = (ServiceDefinition)server;
        } else {
            definition = new RibbonServiceDefinition(serviceName, server.getHost(), server.getPort());
            String zone = server.getZone();
            if (zone != null) {
                server.setZone(zone);
            }
        }
        return (T)request.apply(definition);
    }

    private ZoneAwareLoadBalancer<RibbonServiceDefinition> createLoadBalancer(String serviceName) {
        IClientConfig config;
        IClientConfig iClientConfig = config = this.configuration.getClientName() != null ? IClientConfig.Builder.newBuilder((String)this.configuration.getClientName()).build() : IClientConfig.Builder.newBuilder().build();
        if (this.configuration.getProperties() != null) {
            for (Map.Entry<String, String> entry : this.configuration.getProperties().entrySet()) {
                IClientConfigKey key = IClientConfigKey.Keys.valueOf((String)entry.getKey());
                String value = entry.getValue();
                LOGGER.debug("RibbonClientConfig: {}={}", (Object)key.key(), (Object)value);
                config.set(key, (Object)value);
            }
        }
        ZoneAwareLoadBalancer loadBalancer = this.serviceDiscovery != null ? new ZoneAwareLoadBalancer(config, this.configuration.getRuleOrDefault(RoundRobinRule::new), this.configuration.getPingOrDefault(DummyPing::new), (ServerList)new RibbonServerList(serviceName, this.serviceDiscovery, this.serviceFilter), null, (ServerListUpdater)new PollingServerListUpdater(config)) : new ZoneAwareLoadBalancer(config);
        return loadBalancer;
    }

    static final class RibbonServerList
    implements ServerList<RibbonServiceDefinition> {
        private final String serviceName;
        private final ServiceDiscovery serviceDiscovery;
        private final ServiceFilter serviceFilter;

        RibbonServerList(String serviceName, ServiceDiscovery serviceDiscovery, ServiceFilter serviceFilter) {
            this.serviceName = serviceName;
            this.serviceDiscovery = serviceDiscovery;
            this.serviceFilter = serviceFilter;
        }

        public List<RibbonServiceDefinition> getInitialListOfServers() {
            List services = this.serviceDiscovery.getServices(this.serviceName);
            if (this.serviceFilter != null) {
                services = this.serviceFilter.apply(services);
            }
            return this.asRibbonServerList(services);
        }

        public List<RibbonServiceDefinition> getUpdatedListOfServers() {
            List services = this.serviceDiscovery.getServices(this.serviceName);
            if (this.serviceFilter != null) {
                services = this.serviceFilter.apply(services);
            }
            return this.asRibbonServerList(services);
        }

        private List<RibbonServiceDefinition> asRibbonServerList(List<ServiceDefinition> services) {
            ArrayList<RibbonServiceDefinition> ribbonServers = new ArrayList<RibbonServiceDefinition>();
            for (ServiceDefinition service : services) {
                if (service instanceof RibbonServiceDefinition) {
                    ribbonServers.add((RibbonServiceDefinition)service);
                    continue;
                }
                RibbonServiceDefinition serviceDef = new RibbonServiceDefinition(this.serviceName, service.getHost(), service.getPort(), service.getHealth());
                String zone = serviceDef.getMetadata().get("zone");
                if (zone != null) {
                    serviceDef.setZone(zone);
                }
                ribbonServers.add(serviceDef);
            }
            return ribbonServers;
        }
    }
}

